/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.multifilesearch.CancelException;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearch;
import oracle.jdevimpl.multifilesearch.MultiFileSearchDialog;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;
import oracle.jdevimpl.multifilesearch.MultiFileSearchLog;
import oracle.jdevimpl.multifilesearch.ReplaceTextCriteria;
import oracle.jdevimpl.multifilesearch.ReplaceTextSearchOperationImpl;
import oracle.jdevimpl.multifilesearch.ReplaceTextURLHandler;
import oracle.jdevimpl.multifilesearch.SearchException;

public class MultiFileSearchAddin
implements Addin,
Controller {
    public static final int MFS_CMD_ID = 28;
    public static final String MFS_CMD = "oracle.jdevimpl.multifilesearch.MultiFileSearchCommand";
    public static final int MFS_LOG_WINDOW_STOP_SEARCH_CMD_ID = Ide.findOrCreateCmdID((String)"MFSLogWindowStopSearch");
    public static IdeAction actionLogWindowStopSearch;
    public static final int MFS_LOG_WINDOW_SEARCH_AGAIN_CMD_ID;
    public static IdeAction actionLogWindowSearchAgain;
    public static final int MFS_REPLACE_CMD_ID = 76;
    public static final String MFS_REPLACE_CMD = "oracle.jdevimpl.multifilesearch.MultiFileSearchReplaceCommand";
    private static final String MFS_SHOWPROGRESSONSTATUSBAR = "MultiFileSearch.ShowProgressOnStatusBar";
    static boolean ShowProgressOnStatusBar;
    private MultiFileSearchInfo mfsi;
    public static int LOCK_PAGE_CMD_ID;
    private static int CREATE_WORKINGSET_CMD_ID;

    static {
        MFS_LOG_WINDOW_SEARCH_AGAIN_CMD_ID = Ide.findOrCreateCmdID((String)"MFSLogWindowSearchAgain");
        ShowProgressOnStatusBar = true;
    }

    private void updateLogWindowActions() {
        this.update(actionLogWindowStopSearch, null);
        this.update(actionLogWindowSearchAgain, null);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 28) {
            this.performSearch(false);
            return true;
        }
        if (n == 76) {
            this.performSearch(true);
            return true;
        }
        if (n == MFS_LOG_WINDOW_STOP_SEARCH_CMD_ID) {
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof SearchPage) {
                ((SearchPage)logPage).stopSearch();
            }
            return true;
        }
        if (n == MFS_LOG_WINDOW_SEARCH_AGAIN_CMD_ID) {
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof SearchPage) {
                ((SearchPage)logPage).startSearch();
            }
            return true;
        }
        return false;
    }

    private static boolean isReusablePage(LogPage logPage) {
        SearchPage searchPage;
        return logPage.getClass() == SearchPage.class && !(searchPage = (SearchPage)logPage).isLocked() && !searchPage.isSearchRunning();
    }

    private static SearchPage findUsablePage(boolean bl) {
        if (!bl) {
            LogManager logManager = LogManager.getLogManager();
            LogPage logPage = logManager.getSelectedPage();
            if (MultiFileSearchAddin.isReusablePage(logPage)) {
                return (SearchPage)logPage;
            }
            LogPage[] logPageArray = logManager.getPages();
            int n = 0;
            while (n < logPageArray.length) {
                LogPage logPage2 = logPageArray[n];
                if (MultiFileSearchAddin.isReusablePage(logPage2)) {
                    return (SearchPage)logPage2;
                }
                ++n;
            }
        }
        return null;
    }

    private void performSearch(boolean bl) {
        if (this.mfsi == null) {
            ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            if (!clientSetting.hasData("oracle.jdevimpl.multifilesearch.MultiFileSearchOptions")) {
                clientSetting.putData("oracle.jdevimpl.multifilesearch.MultiFileSearchOptions", (Copyable)new MultiFileSearchInfo());
            }
            this.mfsi = (MultiFileSearchInfo)clientSetting.getData("oracle.jdevimpl.multifilesearch.MultiFileSearchOptions");
        }
        this.mfsi.setReplacing(bl);
        MultiFileSearchDialog multiFileSearchDialog = new MultiFileSearchDialog(this.mfsi);
        if (multiFileSearchDialog.ok) {
            if (bl) {
                String string = this.mfsi.getSelectedSearchText();
                String string2 = this.mfsi.getSelectedReplaceText();
                ReplaceTextCriteria replaceTextCriteria = new ReplaceTextCriteria(string, string2, this.mfsi);
                MultiFileSearch multiFileSearch = new MultiFileSearch(this.mfsi);
                ReplaceTextSearchOperationImpl replaceTextSearchOperationImpl = new ReplaceTextSearchOperationImpl(Context.newIdeContext(), replaceTextCriteria, multiFileSearch);
                replaceTextSearchOperationImpl.runRefactoring(this.mfsi.isPreviewChange());
            } else {
                String string = this.mfsi.getSelectedSearchText();
                if (string.length() > 20) {
                    string = string.substring(0, 17) + "...";
                }
                MultiFileSearch multiFileSearch = new MultiFileSearch(this.mfsi);
                SearchPage searchPage = MultiFileSearchAddin.findUsablePage(this.mfsi.isNewTab());
                if (searchPage != null) {
                    searchPage.reuseLogPage(multiFileSearch, string);
                } else {
                    searchPage = new SearchPage(multiFileSearch, string);
                    searchPage.startSearch();
                }
            }
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 28) {
            return true;
        }
        if (n == MFS_LOG_WINDOW_STOP_SEARCH_CMD_ID) {
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof SearchPage) {
                ideAction.setEnabled(((SearchPage)logPage).isSearchRunning());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == MFS_LOG_WINDOW_SEARCH_AGAIN_CMD_ID) {
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof SearchPage) {
                ideAction.setEnabled(((SearchPage)logPage).isSearchRunning() ^ true);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    public void initialize() {
        IdeAction ideAction = IdeAction.get((int)28, (String)MFS_CMD, (String)IdeArb.getString((int)129), (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)IdeArb.getInteger((int)130), (ArrayResourceBundle)IdeArb.getInstance(), (int)131, null, (boolean)true);
        ideAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_SEARCH_FIND_IN_FILES);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Search"), JDeveloperMenuConstants.SECTION_SEARCH_MULTI_FILE_FIND);
        IdeAction ideAction2 = IdeAction.get((int)76, (String)MFS_REPLACE_CMD, (String)IdeArb.getString((int)440), (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)IdeArb.getInteger((int)441), (ArrayResourceBundle)IdeArb.getInstance(), (int)442, null, (boolean)true);
        ideAction2.addController((Controller)this);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)ideAction2, JDeveloperMenuConstants.WEIGHT_SEARCH_REPLACE_IN_FILES);
        menubar.add((Component)jMenuItem2, MenuManager.getJMenu((String)"Search"), JDeveloperMenuConstants.SECTION_SEARCH_MULTI_FILE_FIND);
        String string = MfsArb.getString(46);
        actionLogWindowStopSearch = IdeAction.get((int)MFS_LOG_WINDOW_STOP_SEARCH_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ArrayResourceBundle)IdeArb.getInstance(), (int)150, null, (boolean)false);
        actionLogWindowStopSearch.addController((Controller)this);
        string = MfsArb.getString(47);
        actionLogWindowSearchAgain = IdeAction.get((int)MFS_LOG_WINDOW_SEARCH_AGAIN_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ArrayResourceBundle)IdeArb.getInstance(), (int)324, null, (boolean)false);
        actionLogWindowSearchAgain.addController((Controller)this);
        RefactoringManager refactoringManager = RefactoringManager.getRefactoringManager();
        refactoringManager.registerUrlHandler(new ReplaceTextURLHandler(), 0.5);
        ShowProgressOnStatusBar = MultiFileSearchInfo.loadBoolean(MFS_SHOWPROGRESSONSTATUSBAR, ShowProgressOnStatusBar);
        string = MfsArb.getString(62);
        LOCK_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"MULTIFILESEARCH.LOCK_PAGE");
        IdeAction ideAction3 = IdeAction.get((int)LOCK_PAGE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ArrayResourceBundle)RefactoringArb.getInstance(), (int)26, null, (boolean)true);
        ideAction3.putValue("Check", (Object)Boolean.TRUE);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    static void wa$CREATE_WORKINGSET_CMD_ID(int n) {
        CREATE_WORKINGSET_CMD_ID = n;
    }

    static int ra$CREATE_WORKINGSET_CMD_ID() {
        return CREATE_WORKINGSET_CMD_ID;
    }

    static void mav$updateLogWindowActions(MultiFileSearchAddin multiFileSearchAddin) {
        multiFileSearchAddin.updateLogWindowActions();
    }

    private class SearchPage
    extends CompilerPage
    implements ItemListener,
    ContextMenuListener,
    TabbedWindowListener {
        private MultiFileSearch _search;
        private MultiFileSearchLog _log;
        private JPanel _panel;
        private SearchThread _searchThread;
        private Toolbar _toolbar;
        private Controller _controller;
        private JMenuItem _selectAllMenu;
        private ToggleToolButton _lockPageButton;
        private String _searchLabel;

        SearchPage(MultiFileSearch multiFileSearch, String string) {
            super("SearchPageId", string, IdeArb.getIcon((int)110));
            this._search = multiFileSearch;
            this._searchLabel = string;
            JTree jTree = super.getTree();
            jTree.setCellRenderer(new SearchCellRenderer(null));
            TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
            treeSelectionModel.setSelectionMode(2);
            this._controller = new SearchPageBaseController(this);
            LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        }

        public String getTabName() {
            return this._searchLabel;
        }

        protected String fixMessages(IdeLog.Message message) {
            String string = message.getMessage();
            string = string.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
            return string;
        }

        public HelpInfo getHelpInfo() {
            return new HelpInfo("f1_idelogwindowsearching_html");
        }

        protected void activateObject(Object object) {
            if (this._search.isNoMatchesOnly()) {
                return;
            }
            super.activateObject(object);
        }

        void reuseLogPage(MultiFileSearch multiFileSearch, String string) {
            this._search = multiFileSearch;
            this._searchLabel = string;
            super.tabNameUpdated();
            this.startSearch();
        }

        void startSearch() {
            if (this._log == null) {
                this._log = new MultiFileSearchLog();
            }
            this._search.setMatchLog(this._log);
            this._log.reinit();
            this._log.setLogPage((LogPage)this);
            this._searchThread = new SearchThread(this, this._search, this._log);
            if (this._searchThread.getPriority() > 1) {
                this._searchThread.setPriority(this._searchThread.getPriority() - 1);
            }
            this._searchThread.start();
        }

        void stopSearch() {
            this._log.cancel();
            this.cancelAsynchronousLogging();
        }

        boolean isClosed() {
            return this.owner() == null;
        }

        boolean isLocked() {
            boolean bl = false;
            if (this._panel != null) {
                bl = this._lockPageButton.isSelected();
            }
            return bl;
        }

        void toggleLock() {
            boolean bl = this._lockPageButton.isSelected();
            this._lockPageButton.setSelected(bl ^ true);
            this._lockPageButton.repaint();
        }

        boolean isSearchRunning() {
            return this._searchThread != null && this._searchThread.isRunning();
        }

        String getPattern() {
            return this._search.getSearchText();
        }

        String getLocation() {
            return this._search.getSearchingInDisplayString();
        }

        private void setNodeHierarchyInfo(MultiFileSearch multiFileSearch) {
            this.setCreateWorkspaceNodes(multiFileSearch.isCreateWorkspaceNodeInTree());
            boolean bl = multiFileSearch.isCreateProjectNodeInTree();
            JTree jTree = this.getTree();
            if (bl) {
                this.setCreateProjectNodes(true);
                jTree.setRootVisible(false);
            } else {
                this.setCreateProjectNodes(false);
                jTree.setRootVisible(true);
                TreeModel treeModel = jTree.getModel();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
                String string = null;
                string = multiFileSearch.isNoMatchesOnly() ? MfsArb.format(37, this.getPattern(), this.getLocation()) : MfsArb.format(36, this.getPattern(), this.getLocation());
                defaultMutableTreeNode.setUserObject(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectAll() {
            DefaultMutableTreeNode defaultMutableTreeNode;
            JTree jTree = super.getTree();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            synchronized (defaultMutableTreeNode2) {
                int n = jTree.getRowCount();
                jTree.setSelectionInterval(0, n - 1);
                this.copy(jTree);
            }
        }

        private void copy(JTree jTree) {
            JTextArea jTextArea = new JTextArea();
            TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
            int[] nArray = treeSelectionModel.getSelectionRows();
            int n = 0;
            while (n < nArray.length) {
                TreePath treePath = jTree.getPathForRow(nArray[n]);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                jTextArea.append(defaultMutableTreeNode.toString());
                jTextArea.append("\n");
                ++n;
            }
            jTextArea.selectAll();
            jTextArea.copy();
        }

        private Controller getSupervisingController() {
            return super.getController();
        }

        public void close() {
            super.close();
            LogManager.getLogManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
            this._controller = null;
        }

        public Controller getController() {
            return this._controller;
        }

        public synchronized void setOwner(LogOwner logOwner) {
            Component component;
            LogOwner logOwner2 = (LogOwner)this.owner();
            if (logOwner2 != null && (component = this.owner().getGUI()) instanceof TabbedWindow) {
                ((TabbedWindow)component).removeTabbedWindowListener((TabbedWindowListener)this);
            }
            if (logOwner == null) {
                this._log.cancel();
                this.cancelAsynchronousLogging();
                if (this._toolbar != null) {
                    this._toolbar.dispose();
                    this._toolbar = null;
                }
                this._panel = null;
            } else {
                Component component2;
                View view = logOwner.getLogOwnerView();
                if (view != null && (component2 = view.getGUI()) instanceof TabbedWindow) {
                    ((TabbedWindow)component2).addTabbedWindowListener((TabbedWindowListener)this);
                }
            }
            super.setOwner(logOwner);
        }

        protected Icon getLeafIcon(IdeLog.Message message) {
            return IdeArb.getIcon((int)110);
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (contextMenu == null) {
                return;
            }
            Context context = contextMenu.getContext();
            if (context == null || !context.getView().equals((Object)this)) {
                return;
            }
            if (this._selectAllMenu == null) {
                this._selectAllMenu = contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)22));
            }
            contextMenu.add((Component)this._selectAllMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
            SearchPage searchPage = (SearchPage)context.getView();
            JTree jTree = searchPage.getTree();
            this._selectAllMenu.setEnabled(jTree != null && jTree.getRowCount() > 0);
            IdeAction ideAction = IdeAction.find((int)MFS_LOG_WINDOW_STOP_SEARCH_CMD_ID);
            JMenuItem jMenuItem = new JMenuItem((Action)ideAction);
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_RUN_CTXT_MENU);
            ideAction = IdeAction.find((int)MFS_LOG_WINDOW_SEARCH_AGAIN_CMD_ID);
            jMenuItem = new JMenuItem((Action)ideAction);
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_RUN_CTXT_MENU);
            ideAction = IdeAction.find((int)LOCK_PAGE_CMD_ID);
            jMenuItem = new JMenuItem((Action)ideAction);
            if (this.isLocked()) {
                jMenuItem.setText(StringUtils.stripMnemonic((String)MfsArb.getString(63)));
            } else {
                jMenuItem.setText(StringUtils.stripMnemonic((String)MfsArb.getString(62)));
            }
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_RUN_CTXT_MENU);
            ideAction = IdeAction.find((int)MultiFileSearchAddin.ra$CREATE_WORKINGSET_CMD_ID());
            jMenuItem = new JMenuItem((Action)ideAction);
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            ideAction.setEnabled(this._search.isSingleProjectSearch());
            ideAction = IdeAction.find((int)DefaultLogPage.GOTO_SOURCE_CMD_ID);
            if (this._search.isNoMatchesOnly()) {
                ideAction.setEnabled(false);
            } else {
                this._controller.update(ideAction, null);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void activeChanged(TabbedWindowEvent tabbedWindowEvent) {
            MultiFileSearchAddin.mav$updateLogWindowActions(MultiFileSearchAddin.this);
        }

        public String getTitleName() {
            String string = MfsArb.getString(1) + " " + super.getTitleName();
            AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)string, (boolean)true);
            AccessibleUtils.updateAccessibleName((Accessible)this.getTextArea(), (String)string, (boolean)true);
            return string;
        }

        public Component getGUI() {
            if (this._panel == null) {
                this._panel = new JPanel(new BorderLayout());
                this._panel.add(super.getGUI(), "Center");
                this._toolbar = new Toolbar();
                this._toolbar.add((ToggleAction)actionLogWindowStopSearch);
                this._toolbar.add((ToggleAction)actionLogWindowSearchAgain);
                IdeAction ideAction = IdeAction.find((int)LOCK_PAGE_CMD_ID);
                IdeAction ideAction2 = ideAction.newLocalAction((View)this);
                ideAction2.setEnabled(true);
                this._lockPageButton = this._toolbar.addToggleButton((ToggleAction)ideAction2);
                this._lockPageButton.addItemListener((ItemListener)this);
                this._lockPageButton.setSelected(false);
                this._panel.add((Component)this._toolbar, "North");
                String string = RefactoringArb.getString(29);
                MultiFileSearchAddin.wa$CREATE_WORKINGSET_CMD_ID(Ide.findOrCreateCmdID((String)"MULTIFILESEARCH.CREATE_WORKINGSET"));
                IdeAction.get((int)MultiFileSearchAddin.ra$CREATE_WORKINGSET_CMD_ID(), null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, (boolean)true);
            }
            return this._panel;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            String string = null;
            string = n == 2 ? StringUtils.stripMnemonic((String)MfsArb.getString(62)) : StringUtils.stripMnemonic((String)MfsArb.getString(63));
            this._lockPageButton.setToolTipText(string);
        }

        public String getToolTip() {
            return MfsArb.getString(45);
        }

        static MultiFileSearch ra$_search(SearchPage searchPage) {
            return searchPage._search;
        }

        static JTree mav$getTree(SearchPage searchPage) {
            return searchPage.getTree();
        }

        static int ra$GOTO_SOURCE_CMD_ID() {
            return GOTO_SOURCE_CMD_ID;
        }

        static Controller mav$getSupervisingController(SearchPage searchPage) {
            return searchPage.getSupervisingController();
        }

        static void mav$copy(SearchPage searchPage, JTree jTree) {
            searchPage.copy(jTree);
        }

        static void mav$setNodeHierarchyInfo(SearchPage searchPage, MultiFileSearch multiFileSearch) {
            searchPage.setNodeHierarchyInfo(multiFileSearch);
        }

        private class SearchPageBaseController
        implements Controller {
            private SearchPage _searchPage;

            SearchPageBaseController(SearchPage searchPage2) {
                this._searchPage = searchPage2;
            }

            public boolean handleEvent(IdeAction ideAction, Context context) {
                int n = ideAction.getCommandId();
                SearchPage searchPage = null;
                if (context.getView() != null && context.getView() instanceof SearchPage) {
                    searchPage = (SearchPage)context.getView();
                }
                if (n == 18) {
                    if (searchPage != null) {
                        JTree jTree = SearchPage.mav$getTree(searchPage);
                        SearchPage.mav$copy(SearchPage.this, jTree);
                    }
                    return true;
                }
                if (n == 22) {
                    if (searchPage != null) {
                        searchPage.selectAll();
                    }
                    return true;
                }
                if (n == LOCK_PAGE_CMD_ID) {
                    if (searchPage != null && !ideAction.isLocalAction()) {
                        searchPage.toggleLock();
                    }
                    return true;
                }
                if (n == 30 || n == 31) {
                    SearchPage.mav$getSupervisingController(SearchPage.this).handleEvent(ideAction, context);
                    return true;
                }
                if (n == SearchPage.ra$GOTO_SOURCE_CMD_ID()) {
                    SearchPage.mav$getSupervisingController(SearchPage.this).handleEvent(ideAction, context);
                    return true;
                }
                if (n == 12) {
                    SearchPage.mav$getSupervisingController(SearchPage.this).handleEvent(ideAction, context);
                    return true;
                }
                if (n == MultiFileSearchAddin.ra$CREATE_WORKINGSET_CMD_ID()) {
                    HashSet hashSet = SearchPage.ra$_search(SearchPage.this).getURLHashSet();
                    int n2 = hashSet.size();
                    URL[] uRLArray = new URL[n2];
                    uRLArray = hashSet.toArray(uRLArray);
                    this.whenCreateWorkingSet(context, uRLArray);
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                int n = ideAction.getCommandId();
                JTree jTree = SearchPage.mav$getTree(SearchPage.this);
                if (n == 22) {
                    ideAction.setEnabled(jTree != null && jTree.getRowCount() > 0);
                    return true;
                }
                if (n == 18) {
                    ideAction.setEnabled(jTree != null && jTree.getSelectionCount() > 0);
                    return true;
                }
                if (n == 30 || n == 31 || n == 12) {
                    ideAction.setEnabled(jTree != null && jTree.getRowCount() > 0);
                    return true;
                }
                if (n == SearchPage.ra$GOTO_SOURCE_CMD_ID()) {
                    SearchPage.mav$getSupervisingController(SearchPage.this).update(ideAction, context);
                    return true;
                }
                return false;
            }

            private void whenCreateWorkingSet(Context context, URL[] uRLArray) {
                JLabel jLabel = new JLabel();
                JTextField jTextField = new JTextField(20);
                ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)MfsArb.getString(69));
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jLabel, "West");
                jPanel.add((Component)jTextField, "Center");
                IdeMainWindow ideMainWindow = Ide.getMainWindow();
                HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_jed_xxxxxx_html");
                JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, MfsArb.getString(70), 7);
                jEWTDialog.setContent((Component)jPanel);
                jEWTDialog.setResizable(true);
                jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, jTextField));
                if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                    Project project = SearchPage.ra$_search(SearchPage.this).getSingleProject();
                    String string = jTextField.getText();
                    WorkingSets workingSets = WorkingSets.getInstance((Project)project);
                    WorkingSet workingSet = workingSets.getWorkingSet(string);
                    if (workingSet != null) {
                        PatternFilters patternFilters = workingSet.getPatternFilters();
                        patternFilters.addExclude("**");
                        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
                        URLPath uRLPath = pathsConfiguration.getSourcePath();
                        int n = 0;
                        while (n < uRLArray.length) {
                            URL uRL = uRLArray[n];
                            String string2 = uRLPath.toRelativePath(uRL);
                            patternFilters.addInclude(string2);
                            ++n;
                        }
                    }
                }
            }

            public final class 1
            implements VetoableChangeListener {
                private final /* synthetic */ JTextField v$textField;
                final /* synthetic */ SearchPageBaseController this$0;

                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if (propertyChangeEvent.getPropertyName().equals("closed") && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && this.v$textField.getText().length() == 0) {
                        throw new PropertyVetoException("Invalid name", propertyChangeEvent);
                    }
                }

                public 1(SearchPageBaseController searchPageBaseController, JTextField jTextField) {
                    this.v$textField = jTextField;
                    this.this$0 = searchPageBaseController;
                }
            }
        }

        private final class SearchCellRenderer
        extends DefaultTreeCellRenderer {
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (!bl3 && object2 != null) {
                    this.setIcon(this.getIcon(object2));
                    if (this.hasLeafChild(defaultMutableTreeNode)) {
                        int n2 = defaultMutableTreeNode.getChildCount();
                        if (n2 == 1) {
                            this.setText(MfsArb.format(61, object2.toString(), new Integer(n2)));
                        } else {
                            this.setText(MfsArb.format(60, object2.toString(), new Integer(n2)));
                        }
                    }
                } else if (bl3) {
                    if (SearchPage.ra$_search(SearchPage.this).isNoMatchesOnly()) {
                        if (object2 != null) {
                            this.setIcon(this.getIcon(object2));
                            if (object2 instanceof CompilerPage.MsgTreeNode) {
                                String string = ((CompilerPage.MsgTreeNode)object2).toString();
                                this.setText(string);
                            }
                        }
                    } else {
                        this.setIcon(null);
                    }
                }
                return this;
            }

            private Icon getIcon(Object object) {
                if (object instanceof CompilerPage.MsgTreeNode) {
                    CompilerPage.MsgTreeNode msgTreeNode = (CompilerPage.MsgTreeNode)object;
                    return msgTreeNode.getIcon();
                }
                return null;
            }

            private boolean hasLeafChild(DefaultMutableTreeNode defaultMutableTreeNode) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!defaultMutableTreeNode2.isLeaf()) continue;
                    return true;
                }
                return false;
            }

            private SearchCellRenderer() {
            }

            SearchCellRenderer(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    public class SearchThread
    extends Thread {
        private SearchPage cp;
        private MultiFileSearch search;
        private MultiFileSearchLog log;
        private boolean running;

        void $init$() {
            this.running = false;
        }

        SearchThread(SearchPage searchPage, MultiFileSearch multiFileSearch, MultiFileSearchLog multiFileSearchLog) {
            super("SearchThread");
            this.$init$();
            this.cp = searchPage;
            this.search = multiFileSearch;
            this.log = multiFileSearchLog;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void run() {
            try {
                try {
                    this.running = true;
                    SwingUtilities.invokeAndWait(new 4());
                    this.cp.startAsynchronousLogging();
                    this.search.setupSearch();
                    SearchPage.mav$setNodeHierarchyInfo(this.cp, this.search);
                    int n = this.search.performSearch();
                    int n2 = this.log.getMatchCount();
                    String string = null;
                    string = this.search.isNoMatchesOnly() ? MfsArb.format(39, String.valueOf(n2), this.cp.getPattern(), String.valueOf(n)) : MfsArb.format(38, String.valueOf(n2), String.valueOf(n));
                    String string2 = string;
                    this.log.logProgress(string2);
                    SwingUtilities.invokeLater(new 3(this, n2, string2));
                }
                catch (CancelException cancelException) {
                    this.cp.cancelAsynchronousLogging();
                    SwingUtilities.invokeLater(new 2());
                }
                catch (SearchException searchException) {
                    this.cp.cancelAsynchronousLogging();
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), searchException.getMessage(), MfsArb.getString(5), 0);
                }
                catch (Throwable throwable) {
                    this.cp.cancelAsynchronousLogging();
                    throwable.printStackTrace();
                }
            }
            finally {
                this.running = false;
                SwingUtilities.invokeLater(new 1());
            }
        }

        static SearchPage ra$cp(SearchThread searchThread) {
            return searchThread.cp;
        }

        static MultiFileSearch ra$search(SearchThread searchThread) {
            return searchThread.search;
        }

        static MultiFileSearchLog ra$log(SearchThread searchThread) {
            return searchThread.log;
        }

        public final class 4
        implements Runnable {
            public void run() {
                SearchThread.ra$cp(SearchThread.this).clearAll();
                if (SearchThread.ra$search(SearchThread.this).isNoMatchesOnly()) {
                    SearchThread.ra$cp(SearchThread.this).log(MfsArb.format(37, SearchThread.ra$cp(SearchThread.this).getPattern(), SearchThread.ra$cp(SearchThread.this).getLocation()));
                } else {
                    SearchThread.ra$cp(SearchThread.this).log(MfsArb.format(36, SearchThread.ra$cp(SearchThread.this).getPattern(), SearchThread.ra$cp(SearchThread.this).getLocation()));
                }
                SearchThread.ra$cp(SearchThread.this).log("\n\n");
                MultiFileSearchAddin.mav$updateLogWindowActions(MultiFileSearchAddin.this);
                LogManager.getLogManager().showLog();
            }
        }

        public final class 3
        implements Runnable {
            private final /* synthetic */ int v$occurences;
            private final /* synthetic */ String v$foundStr;
            final /* synthetic */ SearchThread this$0;

            public void run() {
                if (SearchThread.ra$cp(this.this$0) != null && !SearchThread.ra$log(this.this$0).gotCancelled()) {
                    SearchThread.ra$cp(this.this$0).finishAsynchronousLogging();
                    if (this.v$occurences <= 0) {
                        SearchThread.ra$cp(this.this$0).log(this.v$foundStr + "\n");
                    }
                    LogManager.getLogManager().showLog();
                }
            }

            public 3(SearchThread searchThread, int n, String string) {
                this.v$foundStr = string;
                this.v$occurences = n;
                this.this$0 = searchThread;
            }
        }

        public final class 2
        implements Runnable {
            public void run() {
                String string = MfsArb.getString(40);
                Ide.getStatusBar().setText(string);
                if (SearchThread.ra$cp(SearchThread.this) != null && !SearchThread.ra$cp(SearchThread.this).isClosed() && !SearchThread.ra$cp(SearchThread.this).isShowingTree()) {
                    SearchThread.ra$cp(SearchThread.this).log(string);
                }
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                MultiFileSearchAddin.mav$updateLogWindowActions(MultiFileSearchAddin.this);
            }
        }
    }
}

