/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearch;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;
import oracle.jdevimpl.multifilesearch.MultiFileSearchPanel;

public final class MultiFileSearchDialog
extends JPanel {
    private MultiFileSearchInfo multiFileSearchInfo;
    private Namespace _namespace;
    static String MULTIFILESEARCHINFO = "oracle.jdevimpl.multifilesearch.MultiFileSearchInfo";
    public boolean ok;

    void $init$() {
        this.ok = false;
    }

    public MultiFileSearchDialog(MultiFileSearchInfo multiFileSearchInfo) {
        this.$init$();
        this.multiFileSearchInfo = multiFileSearchInfo;
        try {
            this.setLayout(new BorderLayout());
            MultiFileSearchPanel multiFileSearchPanel = new MultiFileSearchPanel();
            this.add((Component)((Object)multiFileSearchPanel), "Center");
            this._namespace = new Namespace();
            this._namespace.put(MULTIFILESEARCHINFO, (Object)multiFileSearchInfo);
            WorkingSetsEditor.setPatternFilters(this._namespace, multiFileSearchInfo.getPatternFilters());
            multiFileSearchPanel.onEntry(new TraversableContext(this._namespace, 1));
            if (multiFileSearchInfo.isReplacing()) {
                HelpUtils.setHelpID((JComponent)this, (String)"f1_idedreplacefiles_html");
            } else {
                HelpUtils.setHelpID((JComponent)this, (String)"f1_idedsearchfiles_html");
            }
            JEWTDialog jEWTDialog = null;
            1 var4_4 = new 1(this, multiFileSearchPanel);
            try {
                String string = this.multiFileSearchInfo.isReplacing() ? MfsArb.getString(53) : MfsArb.getString(0);
                jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)multiFileSearchPanel.getDefaultFocusComponent(), (String)string, (int)7);
                jEWTDialog.setResizable(true);
                if (this.multiFileSearchInfo.isReplacing()) {
                    jEWTDialog.setMinimumSize(600, 540);
                } else {
                    jEWTDialog.setMinimumSize(600, 500);
                }
                jEWTDialog.setCenterOver((Component)Ide.getMainWindow());
                jEWTDialog.pack();
                jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var4_4);
                this.ok = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
            finally {
                jEWTDialog.removeVetoableChangeListener((VetoableChangeListener)var4_4);
            }
            jEWTDialog = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String getComboBoxText(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object == null) {
            return "";
        }
        return (String)object;
    }

    static void populateComboBox(JComboBox jComboBox, String[] stringArray) {
        if (jComboBox != null) {
            jComboBox.removeAllItems();
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null) {
                        jComboBox.addItem(stringArray[n]);
                    }
                    ++n;
                }
                jComboBox.setSelectedItem(stringArray[0]);
            }
        }
    }

    static void addStringToComboBox(JComboBox jComboBox, String string) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        int n = defaultComboBoxModel.getIndexOf(string);
        if (n > -1) {
            jComboBox.setSelectedIndex(n);
        } else {
            jComboBox.insertItemAt(string, 0);
            jComboBox.setSelectedItem(string);
        }
    }

    static void removeStringFromComboBox(JComboBox jComboBox, String string) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        int n = defaultComboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)defaultComboBoxModel.getElementAt(n2);
            if (string.equals(string2)) {
                defaultComboBoxModel.removeElementAt(n2);
            }
            ++n2;
        }
    }

    static String[] retrieveComboBox(JComboBox jComboBox) {
        String string = MultiFileSearchDialog.getComboBoxText(jComboBox);
        int n = jComboBox.getItemCount();
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < n) {
            if (string.equals((String)jComboBox.getItemAt(n2))) {
                bl = true;
            }
            ++n2;
        }
        String[] stringArray = new String[n + (bl ? 0 : 1)];
        int n3 = 0;
        stringArray[n3++] = string;
        int n4 = 0;
        while (n4 < n) {
            String string2 = (String)jComboBox.getItemAt(n4);
            if (!string.equals(string2)) {
                stringArray[n3++] = string2;
            }
            ++n4;
        }
        return stringArray;
    }

    static boolean isComboboxEmpty(JComboBox jComboBox) {
        String string = MultiFileSearchDialog.getComboBoxText(jComboBox);
        return string.length() <= 0;
    }

    private boolean saveData(MultiFileSearchPanel multiFileSearchPanel) {
        try {
            multiFileSearchPanel.onExit(new TraversableContext(this._namespace, 1));
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog((Component)this);
            boolean bl = false;
            return bl;
        }
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)this._namespace.get(MULTIFILESEARCHINFO);
        if (multiFileSearchInfo.isRegExpEnabled()) {
            String string = multiFileSearchInfo.getSearchTexts()[0];
            try {
                MultiFileSearch.compilePattern(string, multiFileSearchInfo.isCaseSensitive());
            }
            catch (Throwable throwable) {
                JPanel jPanel = new JPanel();
                HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_idedregularexpressionsyntaxerror_html");
                MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), null);
                multiLineLabel.setText(MfsArb.format(34, string, throwable.getMessage()));
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)multiLineLabel, "Center");
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, (Component)jPanel, (String)MfsArb.getString(5), (int)5);
                jEWTDialog.setResizable(true);
                jEWTDialog.pack();
                WizardLauncher.runDialog((JDialog)jEWTDialog);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    static Namespace ra$_namespace(MultiFileSearchDialog multiFileSearchDialog) {
        return multiFileSearchDialog._namespace;
    }

    static boolean mav$saveData(MultiFileSearchDialog multiFileSearchDialog, MultiFileSearchPanel multiFileSearchPanel) {
        return multiFileSearchDialog.saveData(multiFileSearchPanel);
    }

    public final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ MultiFileSearchPanel v$mfsPanel;
        final /* synthetic */ MultiFileSearchDialog this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("closed") && (Boolean)propertyChangeEvent.getNewValue() == Boolean.FALSE) {
                this.v$mfsPanel.onEntry(new TraversableContext(MultiFileSearchDialog.ra$_namespace(this.this$0), 1));
                return;
            }
            if (!MultiFileSearchDialog.mav$saveData(this.this$0, this.v$mfsPanel)) {
                throw new PropertyVetoException(null, null);
            }
        }

        public 1(MultiFileSearchDialog multiFileSearchDialog, MultiFileSearchPanel multiFileSearchPanel) {
            this.v$mfsPanel = multiFileSearchPanel;
            this.this$0 = multiFileSearchDialog;
        }
    }
}

