/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.io.File;
import java.util.StringTokenizer;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.multifilesearch.JarPath;

public class MultiFileSearchInfo
implements Copyable {
    public static int DefaultMaxMatches = 5000;
    public static final String DATA_KEY = "oracle.jdevimpl.multifilesearch.MultiFileSearchOptions";
    private String _sourcePathText;
    private boolean _replacing;
    private String[] _searchTexts;
    private String _selectedSearchText;
    private String[] _replaceTexts;
    private String _selectedReplaceText;
    private String[] _searchLocations;
    private String _selectedSearchLocation;
    private boolean _autoFillSearchText;
    private boolean _recursiveSearch;
    private boolean _treatJarAsDir;
    private boolean _caseSensitive;
    private boolean _wholeWordOnly;
    private boolean _regExpEnabled;
    private boolean _previewChange;
    private boolean _firstMatchOnly;
    private boolean _oneMatchPerLine;
    private boolean _noMatchesOnly;
    private boolean _openFilesOnly;
    private boolean _newTab;
    private boolean _searchAllWorkspaces;
    private boolean _searchCurrentWorkspace;
    private boolean _searchCurrentProject;
    private boolean _searchCurrentPackage;
    private boolean _searchUserDefined;
    private boolean _usePatternFilters;
    private HashStructure _patternFiltersHashStructure;
    private FileTypeIncludeFilter _fileTypeIncludeFilter;
    private transient Object _searchObject;
    private transient int _maxMatches;
    private transient PatternFilters _patternFilters;
    private transient String _workingSetName;

    void $init$() {
        this._replacing = false;
        this._autoFillSearchText = true;
        this._recursiveSearch = true;
        this._treatJarAsDir = true;
        this._caseSensitive = true;
        this._wholeWordOnly = false;
        this._regExpEnabled = false;
        this._previewChange = true;
        this._firstMatchOnly = false;
        this._oneMatchPerLine = false;
        this._noMatchesOnly = false;
        this._openFilesOnly = false;
        this._newTab = false;
        this._searchAllWorkspaces = false;
        this._searchCurrentWorkspace = false;
        this._searchCurrentProject = true;
        this._searchCurrentPackage = false;
        this._searchUserDefined = false;
        this._searchObject = null;
        this._maxMatches = DefaultMaxMatches;
    }

    public MultiFileSearchInfo() {
        this.$init$();
    }

    String validatePaths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreElements()) {
            File file;
            File file2;
            String string2 = (String)stringTokenizer.nextElement();
            JarPath jarPath = JarPath.getJarPath(string2);
            if (!(jarPath != null ? !(file2 = new File(jarPath.jarName)).exists() || !file2.isFile() : !(file = new File(string2)).exists() || !file.isDirectory())) continue;
            return string2;
        }
        return null;
    }

    public String getSelectedSearchText() {
        return this._selectedSearchText;
    }

    public void setSelectedSearchText(String string) {
        this._selectedSearchText = string;
    }

    public String[] getSearchTexts() {
        String[] stringArray;
        String string = this._autoFillSearchText ? this.getWordAtCursor() : null;
        String[] stringArray2 = stringArray = this._searchTexts == null ? new String[]{} : this._searchTexts;
        if (string != null) {
            String[] stringArray3 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray3, 1, stringArray.length);
            stringArray3[0] = string;
            stringArray = stringArray3;
        }
        return this.removeDups(stringArray);
    }

    public void setSearchTexts(String[] stringArray) {
        this._searchTexts = stringArray;
    }

    public String getSelectedReplaceText() {
        return this._selectedReplaceText;
    }

    public void setSelectedReplaceText(String string) {
        this._selectedReplaceText = string;
    }

    public String[] getReplaceTexts() {
        if (this._replaceTexts == null) {
            return new String[0];
        }
        return this._replaceTexts;
    }

    public void setReplaceTexts(String[] stringArray) {
        this._replaceTexts = stringArray;
    }

    public String getSourcePathText() {
        return this._sourcePathText == null ? "" : this._sourcePathText;
    }

    public void setSourcePathText(String string) {
        this._sourcePathText = string;
    }

    public boolean isNoMatchesOnly() {
        return this._noMatchesOnly;
    }

    public void setNoMatchesOnly(boolean bl) {
        this._noMatchesOnly = bl;
    }

    public boolean isTreatJarAsDir() {
        return this._treatJarAsDir;
    }

    public void setTreatJarAsDir(boolean bl) {
        this._treatJarAsDir = bl;
    }

    public boolean isUsePatternFilters() {
        return this._usePatternFilters;
    }

    public void setUsePatternFilters(boolean bl) {
        this._usePatternFilters = bl;
    }

    public HashStructure getPatternFiltersHashStructure() {
        return this._patternFiltersHashStructure;
    }

    public void setPatternFiltersHashStructure(HashStructure hashStructure) {
        this._patternFiltersHashStructure = hashStructure;
    }

    public FileTypeIncludeFilter getFileTypeIncludeFilter() {
        return this._fileTypeIncludeFilter;
    }

    public void setFileTypeIncludeFilter(FileTypeIncludeFilter fileTypeIncludeFilter) {
        this._fileTypeIncludeFilter = fileTypeIncludeFilter;
    }

    public Object getSearchObject() throws TransientMarker {
        return this._searchObject;
    }

    public void setSearchObject(Object object) {
        this._searchObject = object;
    }

    public String getSelectedSearchLocation() {
        return this._selectedSearchLocation;
    }

    public void setSelectedSearchLocation(String string) {
        this._selectedSearchLocation = string;
    }

    public void setSearchLocationTexts(String[] stringArray) {
        this._searchLocations = stringArray;
    }

    public String[] getSearchLocationTexts() {
        if (this._searchLocations == null) {
            return new String[0];
        }
        String[] stringArray = this._searchLocations;
        return this.removeDups(stringArray);
    }

    public boolean getSearchAllWorkspaces() {
        return this._searchAllWorkspaces;
    }

    public void setSearchAllWorkspaces(boolean bl) {
        this._searchAllWorkspaces = bl;
    }

    public boolean getSearchCurrentWorkspace() {
        return this._searchCurrentWorkspace;
    }

    public void setSearchCurrentWorkspace(boolean bl) {
        this._searchCurrentWorkspace = bl;
    }

    public boolean getSearchCurrentProject() {
        return this._searchCurrentProject;
    }

    public void setSearchCurrentProject(boolean bl) {
        this._searchCurrentProject = bl;
    }

    public boolean getSearchCurrentPackage() {
        return this._searchCurrentPackage;
    }

    public void setSearchCurrentPackage(boolean bl) {
        this._searchCurrentPackage = bl;
    }

    public boolean getSearchUserDefined() {
        return this._searchUserDefined;
    }

    public void setSearchUserDefined(boolean bl) {
        this._searchUserDefined = bl;
    }

    public boolean isRecursive() {
        return this._recursiveSearch;
    }

    public void setRecursive(boolean bl) {
        this._recursiveSearch = bl;
    }

    public boolean isReplacing() {
        return this._replacing;
    }

    public void setReplacing(boolean bl) {
        this._replacing = bl;
    }

    public boolean isWholeWordOnly() {
        return this._wholeWordOnly;
    }

    public void setWholeWordOnly(boolean bl) {
        this._wholeWordOnly = bl;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public void setOneMatchPerLine(boolean bl) {
        this._oneMatchPerLine = bl;
    }

    public boolean isOneMatchPerLine() {
        return this._oneMatchPerLine;
    }

    public void setOpenFilesOnly(boolean bl) {
        this._openFilesOnly = bl;
    }

    public boolean isOpenFilesOnly() {
        return this._openFilesOnly;
    }

    public void setNewTab(boolean bl) {
        this._newTab = bl;
    }

    public boolean isNewTab() {
        return this._newTab;
    }

    public boolean isPreviewChange() {
        return this._previewChange;
    }

    public void setPreviewChange(boolean bl) {
        this._previewChange = bl;
    }

    public boolean isRegExpEnabled() {
        return this._regExpEnabled;
    }

    public void setRegExpEnabled(boolean bl) {
        this._regExpEnabled = bl;
    }

    public boolean isAutoFillSearchText() {
        return this._autoFillSearchText;
    }

    public void setAutoFillSearchText(boolean bl) {
        this._autoFillSearchText = bl;
    }

    public boolean getFirstMatchOnly() {
        return this._firstMatchOnly;
    }

    public void setFirstMatchOnly(boolean bl) {
        this._firstMatchOnly = bl;
    }

    public PatternFilters getPatternFilters() throws TransientMarker {
        if (this._patternFilters == null) {
            if (this._patternFiltersHashStructure == null) {
                this._patternFiltersHashStructure = HashStructure.newInstance();
            }
            this._patternFilters = PatternFilters.getInstance((HashStructure)this._patternFiltersHashStructure);
            if (!this._patternFilters.containsFilters()) {
                this._patternFilters.addInclude("**");
            }
        }
        return this._patternFilters;
    }

    public void setPatternFilters(PatternFilters patternFilters) {
        this._patternFilters = patternFilters;
    }

    public String getWorkingSetName() throws TransientMarker {
        return this._workingSetName;
    }

    public void setWorkingSetName(String string) {
        this._workingSetName = string;
    }

    public void setMaxMatches(int n) {
        if (n > 0) {
            this._maxMatches = n;
        }
    }

    public int getMaxMatches() throws TransientMarker {
        return this._maxMatches;
    }

    public Object copyTo(Object object) {
        MultiFileSearchInfo multiFileSearchInfo = object != null ? (MultiFileSearchInfo)object : new MultiFileSearchInfo();
        return multiFileSearchInfo;
    }

    private String getWordAtCursor() {
        String string = null;
        try {
            CodeEditor codeEditor = (CodeEditor)Ide.getMainWindow().getLastActiveView();
            int n = codeEditor.getSelectionStart();
            int n2 = codeEditor.getSelectionEnd();
            if (n == n2) {
                int n3 = codeEditor.getLineFromOffset(n);
                int n4 = codeEditor.getLineStartOffset(n3);
                int n5 = codeEditor.getLineEndOffset(n3);
                int n6 = n5 - n4;
                if (n4 < n5) {
                    String string2 = codeEditor.getText(n4, n5 - n4);
                    n = n2 = n - n4;
                    while (n > 0) {
                        char c = string2.charAt(n - 1);
                        if (!Character.isJavaIdentifierPart(c) && !Character.isJavaIdentifierStart(c)) break;
                        --n;
                    }
                    while (n2 < n6) {
                        char c = string2.charAt(n2);
                        if (!Character.isJavaIdentifierPart(c) && !Character.isJavaIdentifierStart(c)) break;
                        ++n2;
                    }
                    if (n != n2) {
                        string = string2.substring(n, n2);
                    }
                }
            } else {
                int n7;
                int n8 = codeEditor.getLineFromOffset(n);
                if (n8 == (n7 = codeEditor.getLineFromOffset(n2))) {
                    string = codeEditor.getText(n, n2 - n);
                }
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    private String[] removeDups(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return stringArray;
        }
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 + 1;
            while (n4 < n) {
                if (stringArray[n3] != null && stringArray[n4] != null && stringArray[n3].equals(stringArray[n4])) {
                    stringArray[n4] = null;
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        if (n2 > 0) {
            String[] stringArray2 = new String[n - n2];
            int n5 = 0;
            int n6 = 0;
            while (n6 < stringArray.length) {
                if (stringArray[n6] != null) {
                    stringArray2[n5++] = stringArray[n6];
                }
                ++n6;
            }
            return stringArray2;
        }
        return stringArray;
    }

    static boolean loadBoolean(String string, boolean bl) {
        String string2 = Ide.getProperty((String)string);
        return string2 == null ? bl : Boolean.valueOf(string2);
    }
}

