/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdevimpl.multifilesearch.CancelException;
import oracle.jdevimpl.multifilesearch.MatchLog;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearchAddin;
import oracle.ojc.interfaces.Storage;

class MultiFileSearchLog
implements MatchLog {
    private LogPage logPage;
    private boolean cancelled;
    public int matches;

    void $init$() {
        this.logPage = null;
        this.cancelled = false;
        this.matches = 0;
    }

    public void match(Workspace workspace, Project project, Storage storage, String string, int n, int n2, int n3) {
        ++this.matches;
        string = MfsArb.format(35, String.valueOf(n), String.valueOf(n2), string);
        IdeLog.Message message = new IdeLog.Message(workspace != null ? workspace : Ide.getActiveWorkspace(), project != null ? project : Ide.getActiveProject(), storage, string, -1, n, n2 - 1);
        if (!this.cancelled && this.logPage != null) {
            this.logPage.log((Object)message);
        }
    }

    public void match(Workspace workspace, Project project, Storage storage) {
        ++this.matches;
        IdeLog.Message message = new IdeLog.Message(workspace != null ? workspace : Ide.getActiveWorkspace(), project != null ? project : Ide.getActiveProject(), storage, null, 0, 0, 0, 5);
        if (!this.cancelled && this.logPage != null) {
            this.logPage.log((Object)message);
        }
    }

    public void logProgress(String string) throws CancelException {
        if (this.cancelled) {
            throw new CancelException();
        }
        if (MultiFileSearchAddin.ShowProgressOnStatusBar) {
            Ide.getStatusBar().setText(string);
        }
    }

    public synchronized void log(String string) {
        if (this.logPage != null) {
            this.logPage.log((Object)(string + "\n"));
        }
    }

    public int getMatchCount() {
        return this.matches;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean gotCancelled() {
        return this.cancelled;
    }

    public synchronized void setLogPage(LogPage logPage) {
        this.logPage = logPage;
    }

    public void reinit() {
        this.setLogPage(null);
        this.matches = 0;
        this.cancelled = false;
    }

    MultiFileSearchLog() {
        this.$init$();
    }
}

