/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilterPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdevimpl.model.PatternFiltersPanel;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearchDialog;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;
import oracle.jdevimpl.multifilesearch.SearchOptionsPanel;
import oracle.jdevimpl.multifilesearch.SearchScopePanel;

public class MultiFileSearchPanel
extends DefaultTraversablePanel
implements ItemListener,
ActionListener {
    private static final String HELP_TOPIC_ID = "f1_workingsetsprojsettings_html";
    private JComboBox _srcBox;
    private JCheckBox _srcCheck;
    private JCheckBox _regExpCheck;
    private JLabel _replaceTextLabel;
    private JComboBox _replaceTextBox;
    private boolean _initialized;
    private final SearchScopePanel _searchScopePanel;
    private final SearchOptionsPanel _optionsPanel;
    private JButton _fileTypeButton;
    private JCheckBox _usePatternFiltersCheck;
    private final JButton _patternFilterButton;
    private PatternFilters _patternFilters;
    private final PatternFiltersPanel _filterPanel;
    private TraversableContext _traversableContext;

    void $init$() {
        this._srcBox = new JComboBox();
        this._srcCheck = new JCheckBox();
        this._regExpCheck = new JCheckBox();
        this._replaceTextLabel = new JLabel();
        this._replaceTextBox = new JComboBox();
        this._searchScopePanel = new SearchScopePanel();
        this._optionsPanel = new SearchOptionsPanel();
        this._fileTypeButton = new JButton();
        this._usePatternFiltersCheck = new JCheckBox();
        this._patternFilterButton = new JButton();
        this._filterPanel = new PatternFiltersPanel();
    }

    public MultiFileSearchPanel() {
        this.$init$();
    }

    public void onEntry(TraversableContext traversableContext) {
        this._traversableContext = traversableContext;
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
        this._initUI(multiFileSearchInfo);
        this._patternFilters = multiFileSearchInfo.getPatternFilters();
        this._searchScopePanel.onEntry(traversableContext);
        this._optionsPanel.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
        if (MultiFileSearchDialog.isComboboxEmpty(this._srcBox)) {
            throw new TraversalException(MfsArb.getString(2));
        }
        multiFileSearchInfo.setSearchTexts(MultiFileSearchDialog.retrieveComboBox(this._srcBox));
        multiFileSearchInfo.setSelectedSearchText((String)this._srcBox.getSelectedItem());
        multiFileSearchInfo.setAutoFillSearchText(this._srcCheck.isSelected());
        multiFileSearchInfo.setRegExpEnabled(this._regExpCheck.isSelected());
        multiFileSearchInfo.setUsePatternFilters(this._usePatternFiltersCheck.isSelected());
        if (multiFileSearchInfo.isReplacing()) {
            if (MultiFileSearchDialog.isComboboxEmpty(this._replaceTextBox)) {
                throw new TraversalException(MfsArb.getString(52));
            }
            multiFileSearchInfo.setReplaceTexts(MultiFileSearchDialog.retrieveComboBox(this._replaceTextBox));
            multiFileSearchInfo.setSelectedReplaceText((String)this._replaceTextBox.getSelectedItem());
        }
        this._searchScopePanel.onExit(traversableContext);
        this._optionsPanel.onExit(traversableContext);
    }

    private void _initUI(MultiFileSearchInfo multiFileSearchInfo) {
        if (!this._initialized) {
            this.setLayout(new GridBagLayout());
            this._srcBox.setEditable(true);
            JLabel jLabel = new JLabel();
            String string = MfsArb.getString(41);
            jLabel.setToolTipText(string);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this._srcBox.getEditor().getEditorComponent(), (String)MfsArb.getString(6));
            ResourceUtils.resButton((AbstractButton)this._srcCheck, (String)MfsArb.getString(8));
            ResourceUtils.resButton((AbstractButton)this._regExpCheck, (String)MfsArb.getString(22));
            this._regExpCheck.addItemListener(this);
            ResourceUtils.resButton((AbstractButton)this._patternFilterButton, (String)MfsArb.getString(30));
            ResourceUtils.resButton((AbstractButton)this._fileTypeButton, (String)MfsArb.getString(31));
            ResourceUtils.resButton((AbstractButton)this._usePatternFiltersCheck, (String)MfsArb.getString(32));
            this._patternFilterButton.addActionListener(this);
            this._fileTypeButton.addActionListener(this);
            Insets insets = new Insets(0, 0, 0, 0);
            Insets insets2 = new Insets(5, 0, 0, 0);
            this.add(jLabel, this.gbc(0, 0, 2, 1, 0.0, 0.0, 18, 2, insets));
            this.add(this._srcBox, this.gbc(0, 1, 2, 1, 0.0, 0.0, 18, 2, insets2));
            this.add(this._srcCheck, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 2, insets2));
            this.add(this._regExpCheck, this.gbc(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 25, 0, 0)));
            if (multiFileSearchInfo.isReplacing()) {
                ResourceUtils.resLabel((JLabel)this._replaceTextLabel, (Component)this._replaceTextBox.getEditor().getEditorComponent(), (String)MfsArb.getString(54));
                this.add(this._replaceTextLabel, this.gbc(0, 3, 2, 1, 1.0, 0.0, 17, 2, insets2));
                this.add(this._replaceTextBox, this.gbc(0, 4, 2, 1, 1.0, 0.0, 17, 2, insets2));
                this._replaceTextBox.setEditable(true);
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this._fileTypeButton, this.gbc(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0)));
            jPanel.add((Component)this._usePatternFiltersCheck, this.gbc(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 40, 0, 0)));
            jPanel.add((Component)this._patternFilterButton, this.gbc(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0)));
            this.add(jPanel, this.gbc(0, 5, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 0, 10, 0)));
            this.add((Component)((Object)this._searchScopePanel), this.gbc(0, 6, 2, 6, 1.0, 0.0, 18, 2, insets));
            this.add((Component)((Object)this._optionsPanel), this.gbc(0, 13, 2, 5, 1.0, 0.0, 18, 1, insets));
            MultiFileSearchDialog.populateComboBox(this._srcBox, multiFileSearchInfo.getSearchTexts());
            String string2 = multiFileSearchInfo.getSelectedSearchText();
            if (!multiFileSearchInfo.isAutoFillSearchText() && string2 != null) {
                this._srcBox.setSelectedItem(string2);
            }
            this._srcCheck.setSelected(multiFileSearchInfo.isAutoFillSearchText());
            this._regExpCheck.setSelected(multiFileSearchInfo.isRegExpEnabled());
            if (multiFileSearchInfo.isReplacing()) {
                MultiFileSearchDialog.populateComboBox(this._replaceTextBox, multiFileSearchInfo.getReplaceTexts());
                string2 = multiFileSearchInfo.getSelectedReplaceText();
                if (string2 != null) {
                    this._replaceTextBox.setSelectedItem(string2);
                }
            }
            this._usePatternFiltersCheck.setSelected(multiFileSearchInfo.isUsePatternFilters());
            ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this._usePatternFiltersCheck, new Component[]{this._patternFilterButton});
            this._initialized = true;
        }
    }

    public String getHelpID() {
        return HELP_TOPIC_ID;
    }

    Component getDefaultFocusComponent() {
        return this._srcBox.getEditor().getEditorComponent();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)this._traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
        if (object == this._patternFilterButton) {
            JEWTDialog jEWTDialog = null;
            String string = MfsArb.getString(64);
            JDevDialogHeader jDevDialogHeader = new JDevDialogHeader();
            jDevDialogHeader.setHeaderTitle(MfsArb.getString(65));
            jDevDialogHeader.setHeaderDescription(MfsArb.getString(66));
            HashStructure hashStructure = HashStructure.newInstance();
            PatternFilters patternFilters = PatternFilters.getInstance((HashStructure)hashStructure);
            this._patternFilters.copyTo((Object)patternFilters);
            WorkingSetsEditor.setPatternFilters((Namespace)this._traversableContext, patternFilters);
            this._filterPanel.onEntry(this._traversableContext);
            jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)this._filterPanel), (Component)((Object)this._filterPanel), (String)string, (int)7);
            jEWTDialog.setDialogHeader((Component)jDevDialogHeader);
            jEWTDialog.setResizable(true);
            jEWTDialog.setCenterOver((Component)((Object)this));
            jEWTDialog.pack();
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                try {
                    this._filterPanel.onExit(this._traversableContext);
                }
                catch (TraversalException traversalException) {
                    // empty catch block
                }
                multiFileSearchInfo.setPatternFilters(patternFilters);
                HashStructure hashStructure2 = HashStructure.newInstance();
                ListStructure listStructure = ListStructure.newInstance();
                PatternFilter[] patternFilterArray = patternFilters.getFilters();
                int n = 0;
                while (n < patternFilterArray.length) {
                    listStructure.add((Object)patternFilterArray[n].toStr());
                    ++n;
                }
                hashStructure2.putListStructure("pattern-filters", listStructure);
                this._patternFilters = PatternFilters.getInstance((HashStructure)hashStructure2);
                multiFileSearchInfo.setPatternFiltersHashStructure(hashStructure2);
            } else {
                WorkingSetsEditor.setPatternFilters((Namespace)this._traversableContext, this._patternFilters);
            }
        } else if (object == this._fileTypeButton) {
            SearchFileFilterPanel searchFileFilterPanel;
            boolean bl = false;
            FileTypeIncludeFilter fileTypeIncludeFilter = multiFileSearchInfo.getFileTypeIncludeFilter();
            if (fileTypeIncludeFilter == null) {
                fileTypeIncludeFilter = new FileTypeIncludeFilter();
                bl = true;
            }
            if ((searchFileFilterPanel = new SearchFileFilterPanel(fileTypeIncludeFilter)).showDialog((Component)((Object)this)) && bl) {
                multiFileSearchInfo.setFileTypeIncludeFilter(fileTypeIncludeFilter);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this._optionsPanel.setWholeWordOnly(false);
        } else {
            this._optionsPanel.setWholeWordOnly(true);
        }
    }

    private static final class SearchFileFilterPanel
    extends FileTypeIncludeFilterPanel {
        SearchFileFilterPanel(FileTypeIncludeFilter fileTypeIncludeFilter) {
            super(fileTypeIncludeFilter, false);
        }

        protected JEWTDialog createDialog(Component component) {
            JEWTDialog jEWTDialog = super.createDialog(component);
            if (jEWTDialog == null) {
                return null;
            }
            JDevDialogHeader jDevDialogHeader = new JDevDialogHeader();
            jDevDialogHeader.setHeaderTitle(MfsArb.getString(67));
            jDevDialogHeader.setHeaderDescription(MfsArb.getString(68));
            jEWTDialog.setDialogHeader((Component)jDevDialogHeader);
            return jEWTDialog;
        }
    }
}

