/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressBar;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.SearchResultsPerHandler;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearch;
import oracle.jdevimpl.multifilesearch.ReplaceTextLogPage;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.model.SearchProgress;

public class ReplaceTextSearchOperationImpl
extends SearchOperationImpl {
    private static final boolean DEBUG = false;
    private MultiFileSearch _mfs;

    public ReplaceTextSearchOperationImpl(Context context, SearchCriteria searchCriteria, MultiFileSearch multiFileSearch) {
        super(context, searchCriteria);
        this._mfs = multiFileSearch;
    }

    public SearchResults search() {
        long l = System.currentTimeMillis();
        SearchProgress searchProgress = new SearchProgress(this);
        searchProgress.start();
        return this.getSearchResults();
    }

    public void doSearch(SearchProgress searchProgress) {
        RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
        RefactoringEvent refactoringEvent = new RefactoringEvent(1, this);
        refManagerImpl.fireRefEvent(refactoringEvent);
        this.searchResults(searchProgress);
    }

    MultiFileSearch getMultiFileSearch() {
        return this._mfs;
    }

    private void searchResults(SearchProgress searchProgress) {
        RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
        SearchResults searchResults = new SearchResults();
        HashSet hashSet = new HashSet();
        long l = System.currentTimeMillis();
        ProgressBar progressBar = searchProgress.getProgressBar();
        String string = MfsArb.getString(59);
        progressBar.updateProgress(string, null);
        Iterator iterator = refManagerImpl.getRegisteredUrlHandlers();
        while (iterator.hasNext()) {
            URLHandler uRLHandler = (URLHandler)iterator.next();
            HashSet hashSet2 = uRLHandler.chooseURLs(this, null, searchProgress);
            if (hashSet2 == null) continue;
            hashSet2.removeAll(hashSet);
            if (hashSet2.isEmpty()) continue;
            SearchResultsPerHandler searchResultsPerHandler = new SearchResultsPerHandler(uRLHandler, null, hashSet2.toArray(new URL[hashSet2.size()]));
            searchResults.add(searchResultsPerHandler);
            hashSet.addAll(hashSet2);
        }
        long l2 = System.currentTimeMillis();
        RefactoringEvent refactoringEvent = new RefactoringEvent(2, this, searchResults);
        refManagerImpl.fireRefEvent(refactoringEvent);
        SearchResultsPerHandler[] searchResultsPerHandlerArray = searchResults.getResults();
        int n = 0;
        while (n < searchResultsPerHandlerArray.length) {
            URL[] uRLArray;
            SearchResultsPerHandler searchResultsPerHandler = searchResultsPerHandlerArray[n];
            URLHandler uRLHandler = searchResultsPerHandler.getHandler();
            UsageModel usageModel = uRLHandler.findUsages(this, null, uRLArray = searchResultsPerHandler.getUrls(), searchProgress);
            if (usageModel == null) {
                usageModel = new UsageModel();
            }
            searchResultsPerHandler.setUsageModel(usageModel);
            ++n;
        }
        RefactoringEvent refactoringEvent2 = new RefactoringEvent(3, this, searchResults);
        refManagerImpl.fireRefEvent(refactoringEvent2);
        this.setSearchResults(searchResults);
    }

    public boolean runRefactoring(boolean bl) {
        boolean bl2 = false;
        if (this.doSearch()) {
            bl2 = bl ? ReplaceTextLogPage.showUsages(this) : this.doRefactoring();
        }
        return bl2;
    }
}

