/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.multifilesearch.MultiFileSearch;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;
import oracle.jdevimpl.multifilesearch.ReplaceTextCriteria;
import oracle.jdevimpl.multifilesearch.ReplaceTextSearchOperationImpl;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;

public class ReplaceTextURLHandler
extends TextChangeBasedRefactoringHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483540) {
            Context context = searchOperation.getContext();
            Workspace workspace = context.getWorkspace();
            Iterator iterator = workspace.getChildren();
            ArrayList arrayList = new ArrayList();
            IdeUtil.addAll(arrayList, (Iterator)iterator);
            projectArray = arrayList.toArray(new Project[arrayList.size()]);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483540) {
            ReplaceTextSearchOperationImpl replaceTextSearchOperationImpl = (ReplaceTextSearchOperationImpl)searchOperation;
            MultiFileSearch multiFileSearch = replaceTextSearchOperationImpl.getMultiFileSearch();
            hashSet = multiFileSearch.getURLs();
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483540) {
            ReplaceTextSearchOperationImpl replaceTextSearchOperationImpl = (ReplaceTextSearchOperationImpl)searchOperation;
            MultiFileSearch multiFileSearch = replaceTextSearchOperationImpl.getMultiFileSearch();
            usageModel = multiFileSearch.getUsageModel();
        }
        return usageModel;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483540) {
            ReplaceTextCriteria replaceTextCriteria = (ReplaceTextCriteria)searchCriteria;
            refactoringChangeArray = this.getRenameMethodChanges(replaceTextCriteria, usageModel);
        }
        return refactoringChangeArray;
    }

    private RefactoringChange[] getRenameMethodChanges(ReplaceTextCriteria replaceTextCriteria, UsageModel usageModel) {
        ArrayList arrayList = new ArrayList();
        String string = replaceTextCriteria.getOldText();
        String string2 = replaceTextCriteria.getNewText();
        ArrayList arrayList2 = null;
        MultiFileSearchInfo multiFileSearchInfo = replaceTextCriteria.getMultiFileSearchInfo();
        arrayList2 = multiFileSearchInfo.isRegExpEnabled() ? ReplaceTextURLHandler.regExpRename(usageModel, string2) : TextURLHandler.genericRename(usageModel, string, string2);
        arrayList.addAll(arrayList2);
        return arrayList.toArray(new RefactoringChange[arrayList.size()]);
    }

    public static ArrayList regExpRename(UsageModel usageModel, String string) {
        ArrayList<TextChange> arrayList = new ArrayList<TextChange>();
        ArrayList arrayList2 = usageModel.getUsageEntries();
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            UsageEntry usageEntry = (UsageEntry)arrayList2.get(n2);
            if (usageEntry.isIncluded()) {
                TextNode textNode = usageEntry.getTextNode();
                int n3 = usageEntry.getOffset();
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                String string2 = textBuffer.getString(n3, usageEntry.getLength());
                TextChange textChange = new TextChange(textNode, n3, string2, string);
                arrayList.add(textChange);
            }
            ++n2;
        }
        return arrayList;
    }
}

