/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.border.CompoundBorder;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearchDialog;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;

class SearchOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox _caseCheck;
    private JCheckBox _wordCheck;
    private JCheckBox _recurseCheck;
    private JCheckBox _firstMatchCheck;
    private JCheckBox _previewCheck;
    private JCheckBox _oneMatchPerLineCheck;
    private JCheckBox _newTabCheck;
    private JCheckBox _noMatchesCheck;
    private JCheckBox _treatJarAsDirCheck;
    private boolean _initialized;

    void $init$() {
        this._caseCheck = new JCheckBox();
        this._wordCheck = new JCheckBox();
        this._recurseCheck = new JCheckBox();
        this._firstMatchCheck = new JCheckBox();
        this._previewCheck = new JCheckBox();
        this._oneMatchPerLineCheck = new JCheckBox();
        this._newTabCheck = new JCheckBox();
        this._noMatchesCheck = new JCheckBox();
        this._treatJarAsDirCheck = new JCheckBox();
    }

    public SearchOptionsPanel() {
        this.$init$();
    }

    public void onEntry(TraversableContext traversableContext) {
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
        this._initUI(multiFileSearchInfo);
    }

    public void onExit(TraversableContext traversableContext) {
        if (this._initialized) {
            MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
            multiFileSearchInfo.setCaseSensitive(this._caseCheck.isSelected());
            multiFileSearchInfo.setWholeWordOnly(this._wordCheck.isSelected());
            multiFileSearchInfo.setRecursive(this._recurseCheck.isSelected());
            multiFileSearchInfo.setTreatJarAsDir(this._treatJarAsDirCheck.isSelected());
            if (multiFileSearchInfo.isReplacing()) {
                multiFileSearchInfo.setPreviewChange(this._previewCheck.isSelected());
            } else {
                multiFileSearchInfo.setFirstMatchOnly(this._firstMatchCheck.isSelected());
                multiFileSearchInfo.setOneMatchPerLine(this._oneMatchPerLineCheck.isSelected());
                multiFileSearchInfo.setNoMatchesOnly(this._noMatchesCheck.isSelected());
                multiFileSearchInfo.setNewTab(this._newTabCheck.isSelected());
            }
        }
    }

    void setWholeWordOnly(boolean bl) {
        this._wordCheck.setEnabled(bl);
    }

    private void _initUI(MultiFileSearchInfo multiFileSearchInfo) {
        if (!this._initialized) {
            ResourceUtils.resButton((AbstractButton)this._caseCheck, (String)MfsArb.getString(20));
            ResourceUtils.resButton((AbstractButton)this._wordCheck, (String)MfsArb.getString(21));
            ResourceUtils.resButton((AbstractButton)this._recurseCheck, (String)MfsArb.getString(23));
            ResourceUtils.resButton((AbstractButton)this._treatJarAsDirCheck, (String)MfsArb.getString(24));
            ResourceUtils.resButton((AbstractButton)this._firstMatchCheck, (String)MfsArb.getString(25));
            ResourceUtils.resButton((AbstractButton)this._previewCheck, (String)MfsArb.getString(26));
            ResourceUtils.resButton((AbstractButton)this._oneMatchPerLineCheck, (String)MfsArb.getString(27));
            ResourceUtils.resButton((AbstractButton)this._noMatchesCheck, (String)MfsArb.getString(29));
            ResourceUtils.resButton((AbstractButton)this._newTabCheck, (String)MfsArb.getString(28));
            this.setLayout(new GridBagLayout());
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MfsArb.getString(19)), BorderFactory.createEmptyBorder(0, 8, 8, 8));
            this.setBorder(compoundBorder);
            Insets insets = new Insets(5, 0, 0, 0);
            this.add(this._caseCheck, this.gbc(0, 0, 1, 1, 1.0, 0.0, 18, 2, insets));
            this.add(this._recurseCheck, this.gbc(0, 1, 1, 1, 1.0, 0.0, 18, 2, insets));
            this.add(this._treatJarAsDirCheck, this.gbc(0, 2, 1, 1, 1.0, 0.0, 18, 2, insets));
            this.add(this._wordCheck, this.gbc(0, 3, 1, 1, 1.0, 0.0, 18, 2, insets));
            if (multiFileSearchInfo.isReplacing()) {
                this.add(this._previewCheck, this.gbc(0, 4, 1, 1, 1.0, 0.0, 18, 2, insets));
            } else {
                this.add(this._firstMatchCheck, this.gbc(0, 4, 1, 1, 1.0, 0.0, 18, 2, insets));
                this.add(this._oneMatchPerLineCheck, this.gbc(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets));
                this.add(this._noMatchesCheck, this.gbc(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets));
                this.add(this._newTabCheck, this.gbc(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets));
            }
            this._caseCheck.setSelected(multiFileSearchInfo.isCaseSensitive());
            this._wordCheck.setSelected(multiFileSearchInfo.isWholeWordOnly());
            this._recurseCheck.setSelected(multiFileSearchInfo.isRecursive());
            this._treatJarAsDirCheck.setSelected(multiFileSearchInfo.isTreatJarAsDir());
            this._firstMatchCheck.setSelected(multiFileSearchInfo.getFirstMatchOnly());
            this._previewCheck.setSelected(multiFileSearchInfo.isPreviewChange());
            this._oneMatchPerLineCheck.setSelected(multiFileSearchInfo.isOneMatchPerLine());
            this._noMatchesCheck.setSelected(multiFileSearchInfo.isNoMatchesOnly());
            this._newTabCheck.setSelected(multiFileSearchInfo.isNewTab());
            ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this._firstMatchCheck, new Component[]{this._noMatchesCheck}, false);
            ItemSelectableTracker itemSelectableTracker2 = new ItemSelectableTracker((ItemSelectable)this._noMatchesCheck, new Component[]{this._firstMatchCheck, this._oneMatchPerLineCheck}, false);
            this._initialized = true;
        }
    }
}

