/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.component.URLPathEditPanel;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearch;
import oracle.jdevimpl.multifilesearch.MultiFileSearchDialog;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;

class SearchScopePanel
extends DefaultTraversablePanel {
    private JRadioButton allWorkspacesRB;
    private JRadioButton currentWorkspaceRB;
    private JRadioButton currentProjectRB;
    private JComboBox workingSetBox;
    private JRadioButton currentPackageRB;
    private JRadioButton openFilesOnlyRB;
    private JRadioButton userDefinedRB;
    private ButtonGroup searchBtnGroup;
    private JComboBox userDefinedBox;
    private JButton userDefinedBrowseBtn;
    private boolean _initialized;
    private URL[] _packageURL;
    private String _packageDisplayPath;

    void $init$() {
        this.allWorkspacesRB = new JRadioButton();
        this.currentWorkspaceRB = new JRadioButton();
        this.currentProjectRB = new JRadioButton();
        this.workingSetBox = new JComboBox();
        this.currentPackageRB = new JRadioButton();
        this.openFilesOnlyRB = new JRadioButton();
        this.userDefinedRB = new JRadioButton();
        this.searchBtnGroup = new ButtonGroup();
        this.userDefinedBox = new JComboBox();
        this.userDefinedBrowseBtn = new JButton();
        this._packageURL = null;
    }

    public SearchScopePanel() {
        this.$init$();
    }

    public void onEntry(TraversableContext traversableContext) {
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
        this._initUI(multiFileSearchInfo);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        MultiFileSearchInfo multiFileSearchInfo = (MultiFileSearchInfo)traversableContext.get(MultiFileSearchDialog.MULTIFILESEARCHINFO);
        if (this.userDefinedRB.isSelected()) {
            if (MultiFileSearchDialog.isComboboxEmpty(this.userDefinedBox)) {
                throw new TraversalException(MfsArb.getString(3));
            }
            String string = SearchScopePanel.getInvalidSearchPathElement(multiFileSearchInfo, this.userDefinedBox);
            if (string != null) {
                throw new TraversalException(MfsArb.format(4, string));
            }
        }
        if (this._initialized) {
            multiFileSearchInfo.setSearchAllWorkspaces(this.allWorkspacesRB.isSelected());
            multiFileSearchInfo.setSearchCurrentWorkspace(this.currentWorkspaceRB.isSelected());
            multiFileSearchInfo.setSearchCurrentProject(this.currentProjectRB.isSelected());
            multiFileSearchInfo.setSearchCurrentPackage(this.currentPackageRB.isSelected());
            multiFileSearchInfo.setSearchUserDefined(this.userDefinedRB.isSelected());
            multiFileSearchInfo.setOpenFilesOnly(this.openFilesOnlyRB.isSelected());
            multiFileSearchInfo.setSearchLocationTexts(MultiFileSearchDialog.retrieveComboBox(this.userDefinedBox));
            String string = (String)this.userDefinedBox.getSelectedItem();
            if (string != null) {
                multiFileSearchInfo.setSelectedSearchLocation(string);
            }
            if (this.allWorkspacesRB.isSelected()) {
                multiFileSearchInfo.setSearchObject(Ide.getWorkspaces());
            } else if (this.currentWorkspaceRB.isSelected()) {
                multiFileSearchInfo.setSearchObject(Ide.getActiveWorkspace());
            } else if (this.currentProjectRB.isSelected()) {
                multiFileSearchInfo.setSearchObject(Ide.getActiveProject());
                multiFileSearchInfo.setWorkingSetName((String)this.workingSetBox.getSelectedItem());
            } else if (this.currentPackageRB.isSelected() && this._packageURL != null && this._packageURL.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this._packageURL.length) {
                    stringBuffer.append(URLFileSystem.getPath((URL)this._packageURL[n]));
                    stringBuffer.append(";");
                    ++n;
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                multiFileSearchInfo.setSearchObject(stringBuffer.toString());
            }
            if (this.userDefinedRB.isSelected()) {
                multiFileSearchInfo.setSearchObject(this.userDefinedBox.getSelectedItem());
            }
        }
    }

    private void browseBtn_actionPerformed(ActionEvent actionEvent) {
        URLPathEditPanel uRLPathEditPanel = new URLPathEditPanel(URLPath.newURLPathFromString((String)MultiFileSearchDialog.getComboBoxText(this.userDefinedBox)));
        HelpSystem.getHelpSystem().registerTopic((JComponent)uRLPathEditPanel, "f1_idededitpath_html");
        if (OnePageWizardDialogFactory.runDialog((Component)((Object)this), (Component)uRLPathEditPanel, (Component)uRLPathEditPanel.getInitialFocus(), (String)MfsArb.getString(44))) {
            URLPath uRLPath = uRLPathEditPanel.getPath();
            String string = uRLPath.toString();
            this.userDefinedBox.addItem(string);
            this.userDefinedBox.setSelectedItem(string);
            this.userDefinedRB.setSelected(true);
        }
    }

    private void labelAndEnablePredefinedSearches() {
        this.allWorkspacesRB.setEnabled(Ide.getWorkspaces() != null);
        this.allWorkspacesRB.setEnabled(Ide.getWorkspaces().getListOfChildren().size() > 0);
        Workspace workspace = Ide.getActiveWorkspace();
        this.currentWorkspaceRB.setEnabled(workspace != null);
        String string = null;
        string = workspace != null ? workspace.getShortLabel() : MfsArb.getString(18);
        ResourceUtils.resButton((AbstractButton)this.currentWorkspaceRB, (String)MfsArb.format(11, string));
        Project project = Ide.getActiveProject();
        this.currentProjectRB.setEnabled(project != null);
        if (project != null) {
            string = project.getShortLabel();
            this._populateWorkingSets(project);
        } else {
            string = MfsArb.getString(18);
        }
        ResourceUtils.resButton((AbstractButton)this.currentProjectRB, (String)MfsArb.format(9, string));
        this.processPackage();
        if (this._packageURL == null) {
            this.currentPackageRB.setEnabled(false);
            ResourceUtils.resButton((AbstractButton)this.currentPackageRB, (String)MfsArb.getString(13));
        } else {
            this.currentPackageRB.setEnabled(true);
            ResourceUtils.resButton((AbstractButton)this.currentPackageRB, (String)MfsArb.format(12, this._packageDisplayPath));
        }
    }

    private void _populateWorkingSets(Project project) {
        WorkingSets workingSets = WorkingSets.getInstance((Project)project);
        List list = workingSets.getWorkingSetNames();
        DefaultListComboBoxModel defaultListComboBoxModel = new DefaultListComboBoxModel(list);
        this.workingSetBox.setModel(defaultListComboBoxModel);
        this.workingSetBox.setSelectedItem(workingSets.getCurrentWorkingSetName());
    }

    private void _initUI(MultiFileSearchInfo multiFileSearchInfo) {
        if (!this._initialized) {
            String string;
            ResourceUtils.resButton((AbstractButton)this.allWorkspacesRB, (String)MfsArb.getString(10));
            ResourceUtils.resButton((AbstractButton)this.userDefinedRB, (String)MfsArb.getString(15));
            ResourceUtils.resButton((AbstractButton)this.openFilesOnlyRB, (String)MfsArb.getString(14));
            this.labelAndEnablePredefinedSearches();
            this.searchBtnGroup.add(this.allWorkspacesRB);
            this.searchBtnGroup.add(this.currentWorkspaceRB);
            this.searchBtnGroup.add(this.currentProjectRB);
            this.searchBtnGroup.add(this.currentPackageRB);
            this.searchBtnGroup.add(this.userDefinedRB);
            this.searchBtnGroup.add(this.openFilesOnlyRB);
            this.workingSetBox.setEditable(false);
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.workingSetBox.getEditor().getEditorComponent(), (String)MfsArb.getString(16));
            ResourceUtils.resButton((AbstractButton)this.userDefinedBrowseBtn, (String)MfsArb.getString(43));
            this.userDefinedBox.setEditable(true);
            JLabel jLabel2 = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.userDefinedBox.getEditor().getEditorComponent(), (String)MfsArb.getString(7));
            this.userDefinedBrowseBtn.addActionListener(new 1());
            this.setLayout(new GridBagLayout());
            Insets insets = new Insets(5, 0, 0, 0);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MfsArb.getString(17)), BorderFactory.createEmptyBorder(0, 8, 8, 8));
            this.setBorder(compoundBorder);
            this.add(this.allWorkspacesRB, this.gbc(0, 0, 1, 1, 1.0, 0.0, 18, 2, insets));
            this.add(this.currentWorkspaceRB, this.gbc(0, 1, 1, 1, 1.0, 0.0, 18, 2, insets));
            this.add(this.currentProjectRB, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 2, insets));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)jLabel, this.gbc(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 20, 0, 0)));
            jPanel.add((Component)this.workingSetBox, this.gbc(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 20, 0, 0)));
            this.add(jPanel, this.gbc(0, 3, 1, 2, 1.0, 0.0, 18, 2, insets));
            this.add(this.currentPackageRB, this.gbc(1, 0, 1, 1, 0.0, 1.0, 18, 2, insets));
            this.add(this.openFilesOnlyRB, this.gbc(1, 1, 1, 1, 0.0, 0.0, 18, 2, insets));
            this.add(this.userDefinedRB, this.gbc(1, 2, 1, 1, 1.0, 1.0, 18, 2, insets));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.add((Component)jLabel2, this.gbc(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 20, 0, 0)));
            jPanel2.add((Component)this.userDefinedBox, this.gbc(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 20, 0, 0)));
            jPanel2.add((Component)this.userDefinedBrowseBtn, this.gbc(1, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0)));
            this.add(jPanel2, this.gbc(1, 3, 1, 2, 1.0, 0.0, 18, 2, insets));
            ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.userDefinedRB, new Component[]{this.userDefinedBox, this.userDefinedBrowseBtn});
            ItemSelectableTracker itemSelectableTracker2 = new ItemSelectableTracker((ItemSelectable)this.currentProjectRB, new Component[]{this.workingSetBox});
            MultiFileSearchDialog.populateComboBox(this.userDefinedBox, multiFileSearchInfo.getSearchLocationTexts());
            this.allWorkspacesRB.setSelected(multiFileSearchInfo.getSearchAllWorkspaces());
            this.currentWorkspaceRB.setSelected(multiFileSearchInfo.getSearchCurrentWorkspace());
            this.currentProjectRB.setSelected(multiFileSearchInfo.getSearchCurrentProject());
            this.currentPackageRB.setSelected(multiFileSearchInfo.getSearchCurrentPackage());
            this.openFilesOnlyRB.setSelected(multiFileSearchInfo.isOpenFilesOnly());
            this.userDefinedRB.setSelected(multiFileSearchInfo.getSearchUserDefined());
            if (this.allWorkspacesRB.isSelected() && !this.allWorkspacesRB.isEnabled()) {
                this.currentWorkspaceRB.setSelected(true);
            }
            if (this.currentWorkspaceRB.isSelected() && !this.currentWorkspaceRB.isEnabled()) {
                this.currentProjectRB.setSelected(true);
            }
            if (this.currentProjectRB.isSelected() && !this.currentProjectRB.isEnabled()) {
                this.currentPackageRB.setSelected(true);
            }
            if (this.currentPackageRB.isSelected() && !this.currentPackageRB.isEnabled()) {
                this.userDefinedRB.setSelected(true);
            }
            if ((string = multiFileSearchInfo.getSelectedSearchLocation()) != null) {
                this.userDefinedBox.setSelectedItem(string);
            }
            this._initialized = true;
        }
    }

    private static String getInvalidSearchPathElement(MultiFileSearchInfo multiFileSearchInfo, JComboBox jComboBox) {
        String string = MultiFileSearchDialog.getComboBoxText(jComboBox);
        String string2 = multiFileSearchInfo.validatePaths(string);
        return string2;
    }

    private void processPackage() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        View view = ideMainWindow.getLastActiveView();
        if (view == null) {
            return;
        }
        Context context = view.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length == 0 || elementArray[0] instanceof Workspaces || elementArray[0] instanceof Workspace || elementArray[0] instanceof Project) {
            return;
        }
        if (elementArray[0] instanceof JavaSourceNode) {
            JavaSourceNode javaSourceNode = (JavaSourceNode)elementArray[0];
            this._packageDisplayPath = javaSourceNode.getPackage();
            this._packageURL = new URL[1];
            this._packageURL[0] = URLFileSystem.getParent((URL)javaSourceNode.getURL());
            return;
        }
        URL uRL = null;
        if (view instanceof NavigatorWindow) {
            if (elementArray[0] instanceof RelativeDirectoryContextFolder) {
                RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)elementArray[0];
                this._packageDisplayPath = relativeDirectoryContextFolder.getRelativePath();
                if (ModelUtil.hasLength((String)this._packageDisplayPath)) {
                    URL[] uRLArray = relativeDirectoryContextFolder.getRootDirectories().getEntries();
                    if (uRLArray != null && uRLArray.length > 0) {
                        this._packageURL = new URL[uRLArray.length];
                        int n = 0;
                        while (n < uRLArray.length) {
                            URL uRL2;
                            URL uRL3 = uRLArray[n];
                            this._packageURL[n] = uRL2 = URLFactory.newURL((URL)uRL3, (String)this._packageDisplayPath);
                            ++n;
                        }
                    }
                    return;
                }
                uRL = MultiFileSearch.getFirstChildURL(elementArray[0]);
            }
        } else if (elementArray[0] instanceof Locatable) {
            uRL = ((Locatable)elementArray[0]).getURL();
        }
        if (uRL != null) {
            this._packageURL = new URL[1];
            this._packageURL[0] = URLFileSystem.getParent((URL)uRL);
            Project project = context.getProject();
            if (project != null) {
                ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
                ContentSet contentSet = projectContent.getAllContents();
                this._packageDisplayPath = contentSet.toRelativePath(this._packageURL[0]);
            } else {
                this._packageDisplayPath = URLFileSystem.getPlatformPathName((URL)this._packageURL[0]);
            }
            if (this._packageDisplayPath != null && this._packageDisplayPath.endsWith("/")) {
                this._packageDisplayPath = this._packageDisplayPath.substring(0, this._packageDisplayPath.length() - 1);
            } else if (this._packageDisplayPath == null && this._packageURL != null) {
                this._packageDisplayPath = URLFileSystem.getPlatformPathName((URL)this._packageURL[0]);
            }
        }
    }

    static void mav$browseBtn_actionPerformed(SearchScopePanel searchScopePanel, ActionEvent actionEvent) {
        searchScopePanel.browseBtn_actionPerformed(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchScopePanel.mav$browseBtn_actionPerformed(SearchScopePanel.this, actionEvent);
        }
    }
}

