/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.resource.IdeImplMenuArb;
import oracle.jdevimpl.navigator.WorkspacesWrapper;

final class ApplicationNavigatorManager
extends ProjectNavigatorManager {
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"ApplicationNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final String SHOW_NAVIGATOR_CMD = "Ide.APP_NAVIGATOR_CMD_ID";
    private static final int SHOW_NAVIGATOR_CMD_ID = Ide.findOrCreateCmdID((String)"Ide.APP_NAVIGATOR_CMD_ID");
    private static final String NAVIGATOR_DEFAULT_NAME = "ApplicationNavigatorName";
    private static final String NAVIGATOR_WINDOW_ID = "ApplicationNavigatorWindow";
    private Folder _rootFolder;

    public void initialize() {
        super.initialize();
        Menubar menubar = Ide.getMenubar();
        IdeAction ideAction = this.getShowAction();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_APPLICATION_NAVIGATOR + 0.001f);
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    protected String getViewCategory() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/navigator/an-accelerators.xml";
    }

    protected String getDefaultName() {
        return NAVIGATOR_DEFAULT_NAME;
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)64, (String)AddinManager.getAddinManager().getCommand(64, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)158), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeArb.getInteger((int)159), (ArrayResourceBundle)IdeArb.getInstance(), (int)160, null, (boolean)true);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        if (navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith((Dockable)navigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
            NavigatorManager.setWorkspaceNavigatorManager((NavigatorManager)this);
        }
        return dockingParam;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_APPLICATION_NAVIGATOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)IdeImplMenuArb.getString((int)5), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeImplMenuArb.getInteger((int)6), (ArrayResourceBundle)IdeImplMenuArb.getInstance(), (int)4, null, (boolean)true);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideapplicationnavigator_html");
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
        super.configureNavigator(navigatorWindow);
        navigatorWindow.getGUI();
        navigatorWindow.getTreeExplorer().getCellRendererAttributes().set(CellRendererAttributes.HIDE_FILE_EXTENSIONS | CellRendererAttributes.HIDE_CHILDREN);
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow(this.getRootFolder(), true, 5);
    }

    private Folder getRootFolder() {
        if (this._rootFolder == null) {
            this._rootFolder = new WorkspacesWrapper(ModelArb.getString((int)42), IdeArb.getIcon((int)160));
        }
        return this._rootFolder;
    }

    ApplicationNavigatorManager() {
    }
}

