/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.jdevimpl.navigator.FileNameComparator;

final class ApplicationsFilter
extends ChildFilterHelper {
    private static final FileNameComparator _comparator = new FileNameComparator();

    public void initChildren(Context context, List list) {
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = workspaces.getChildren();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Collections.sort(arrayList, _comparator);
            list.addAll(arrayList);
        }
    }

    public boolean handleChildrenAdded(Context context, List list, TNode tNode, TreeExplorer treeExplorer) {
        int n = 0;
        if (tNode instanceof MutableTreeNode) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)tNode;
            for (Object e : list) {
                if (!(e instanceof Workspace)) continue;
                Workspace workspace = (Workspace)e;
                int n2 = 0;
                int n3 = tNode.getChildCount();
                while (n2 < n3) {
                    int n4;
                    TNode tNode2;
                    Element element;
                    TreeNode treeNode = tNode.getChildAt(n2);
                    if (treeNode instanceof TNode && (element = (tNode2 = (TNode)treeNode).getData()) instanceof Workspace && (n4 = _comparator.compare(workspace, element)) < 0) break;
                    ++n2;
                }
                mutableTreeNode.insert((MutableTreeNode)treeExplorer.createTNode((Element)workspace), n2);
                ++n;
            }
        }
        return n > 0;
    }

    public boolean handleChildrenRemoved(Context context, List list, TNode tNode, TreeExplorer treeExplorer) {
        int n = 0;
        if (tNode instanceof MutableTreeNode) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)tNode;
            int n2 = tNode.getChildCount() - 1;
            while (n2 >= 0) {
                TreeNode treeNode = tNode.getChildAt(n2);
                if (treeNode instanceof TNode) {
                    TNode tNode2 = (TNode)treeNode;
                    Element element = tNode2.getData();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (element != iterator.next()) continue;
                        mutableTreeNode.remove(n2);
                        ++n;
                        break;
                    }
                }
                --n2;
            }
        }
        return n > 0;
    }

    ApplicationsFilter() {
    }
}

