/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.navigator.SubjectFolder;

class LibraryFolder
extends SubjectFolder {
    private static Icon _libraryIcon;
    private final Context _context;
    private final String _displayName;
    private final Library _library;

    LibraryFolder(Context context, JLibrary jLibrary) {
        if (jLibrary == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this._displayName = jLibrary.getName();
        this._library = jLibrary;
    }

    LibraryFolder(Context context, JDK jDK) {
        if (jDK == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this._displayName = jDK.getShortLabel();
        this._library = jDK;
    }

    public Object getData() {
        return this._library;
    }

    public String getShortLabel() {
        return this._displayName;
    }

    public Icon getIcon() {
        return this._library.getIcon();
    }

    ArrayList getChildrenList() {
        ArrayList arrayList = new ArrayList();
        PatternFilters patternFilters = this.getWorkingSet();
        if (this._context.getBoolean("show-root-dirs")) {
            IntersectedFilters intersectedFilters = new IntersectedFilters(patternFilters);
            this.addURLPath(arrayList, this._library.getSourcePath(), intersectedFilters);
            this.addURLPath(arrayList, this._library.getClassPath(), intersectedFilters);
        } else {
            ContentSet contentSet = new ContentSet(HashStructure.newInstance());
            URLPath uRLPath = contentSet.getURLPath();
            uRLPath.add(this._library.getSourcePath());
            uRLPath.add(this._library.getClassPath());
            ContentLevel contentLevel = ContentLevel.newInstanceForHideDirs((ContentSet)contentSet, (PatternFilters)patternFilters, (boolean)true);
            contentLevel.addFlatDirs(this._context, arrayList);
        }
        return arrayList;
    }

    private PatternFilters getWorkingSet() {
        if (this._context.getBoolean("enable-working-sets")) {
            return WorkingSet.getCurrentWorkingSetFilters((Project)this._context.getProject());
        }
        return null;
    }

    private void addURLPath(ArrayList arrayList, URLPath uRLPath, IntersectedFilters intersectedFilters) {
        if (uRLPath != null) {
            for (URL uRL : uRLPath) {
                ContentLevel contentLevel = ContentLevel.newInstanceForShowDirs((URL)uRL, (IntersectedFilters)intersectedFilters, (boolean)true);
                arrayList.add(contentLevel.newFolder(this._context));
            }
        }
    }
}

