/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdevimpl.navigator.LibraryFolder;
import oracle.jdevimpl.navigator.Res;

final class LibrarySupport
extends NavigatorInit
implements Controller {
    private static final String TOGGLE_LIBS_CMD = "SystemNavigator.toggleLibs";
    static final int TOGGLE_LIBS_CMD_ID = Ide.findOrCreateCmdID((String)"SystemNavigator.toggleLibs");
    private static IdeAction _toggleLibsAction;
    static final String SHOW_LIBS = "show-libs";
    private static final boolean DEFAULT_SHOW_LIBS = false;
    private boolean _showLibs;
    private Controller _controller;

    void $init$() {
        this._showLibs = false;
    }

    static void init(ProjectNavigatorManager projectNavigatorManager) {
        if (_toggleLibsAction == null) {
            _toggleLibsAction = LibrarySupport.newToggleLibsAction();
        }
        projectNavigatorManager.addNavigatorInit(new NavigatorInitFactory(LibrarySupport.class));
    }

    LibrarySupport(NavigatorWindow navigatorWindow, Context context) {
        super(navigatorWindow, context);
        this.$init$();
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new 1();
        }
        return this._controller;
    }

    public void loadPreferences(PropertyAccess propertyAccess) {
        this._showLibs = LibrarySupport.str2Boolean((PropertyAccess)propertyAccess, (String)SHOW_LIBS, (boolean)false);
    }

    public void savePreferences(PropertyAccess propertyAccess) {
        LibrarySupport.boolean2Str((PropertyAccess)propertyAccess, (String)SHOW_LIBS, (boolean)this._showLibs);
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean(SHOW_LIBS, this._showLibs);
    }

    public void initToolbar(Toolbar toolbar) {
        IdeAction ideAction = _toggleLibsAction.newLocalAction((View)this.getNavigatorWindow());
        ideAction.addController((Controller)this);
        ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)ideAction);
        toolbar.add((Component)toggleToolButton, 5);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOGGLE_LIBS_CMD_ID) {
            this._showLibs ^= true;
            ideAction.setState(this._showLibs);
            ProjectNavigatorManager.refreshAllProjectsInNavigator((Context)context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOGGLE_LIBS_CMD_ID) {
            ideAction.setEnabled(true);
            ideAction.setState(this._showLibs);
            return true;
        }
        return false;
    }

    private static IdeAction newToggleLibsAction() {
        IdeAction ideAction = IdeAction.get((int)TOGGLE_LIBS_CMD_ID, (String)TOGGLE_LIBS_CMD, (String)Res.getString(4), null, null, (ArrayResourceBundle)Res.getInstance(), (int)5, null, (boolean)true);
        ideAction.putValue("Check", (Object)Boolean.TRUE);
        return ideAction;
    }

    final class 1
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            Element[] elementArray;
            int n = ideAction.getCommandId();
            if (n == 20 && (elementArray = context.getSelection()) != null && elementArray.length > 0) {
                TNode tNode;
                Element element;
                Element element2 = elementArray[0];
                if (element2 instanceof LibraryFolder) {
                    ideAction.setEnabled(false);
                    return true;
                }
                TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
                if (tNodeArray != null && tNodeArray.length > 0 && (element = (tNode = tNodeArray[0]).getAncestor(LibraryFolder.class)) != null) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            return false;
        }
    }
}

