/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.navigator.WorkspacesWrapper;

final class SystemNavigatorManager
extends ProjectNavigatorManager {
    private static final String SHOW_NAVIGATOR_CMD = "Ide.SYSTEM_CMD_ID";
    private static final int SHOW_NAVIGATOR_CMD_ID = Ide.findOrCreateCmdID((String)"Ide.SYSTEM_CMD_ID");
    private static final String NAVIGATOR_DEFAULT_NAME = "SystemNavigatorName";
    private static final String NAVIGATOR_WINDOW_ID = "SystemNavigatorWindow";
    private Folder _rootFolder;

    public void initialize() {
        super.initialize();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = this.createNavigateMenuItem();
        JMenu jMenu = MenuManager.getJMenu((String)"Navigate");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_NAVIGATE_SELECT);
        IdeAction ideAction = this.getShowAction();
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        JMenu jMenu2 = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem2, jMenu2, MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    protected String getViewCategory() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getDefaultName() {
        return NAVIGATOR_DEFAULT_NAME;
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)SHOW_NAVIGATOR_CMD_ID, null, (String)Res.getString(1), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(110), (ArrayResourceBundle)IdeArb.getInstance(), (int)157, null, (boolean)true);
    }

    protected DockingParam createNavigatorDockingParam() {
        ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
        Dockable dockable = null;
        if (explorerManager != null) {
            ViewId viewId = explorerManager.getDefaultViewId();
            dockable = DockStation.getDockStation().findDockable(viewId);
        }
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(dockable, 2, 0);
        return dockingParam;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idesystemnavigator_html");
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
        super.configureNavigator(navigatorWindow);
        navigatorWindow.getGUI();
        navigatorWindow.getTreeExplorer().getCellRendererAttributes().set(CellRendererAttributes.HIDE_CHILDREN);
    }

    protected NavigatorWindow createNavigatorWindow() {
        NavigatorManager navigatorManager = NavigatorManager.getApplicationNavigatorManager();
        int n = 0;
        if (navigatorManager == null) {
            n |= 1;
        }
        return this.createNavigatorWindow(this.getRootFolder(), true, n);
    }

    private Folder getRootFolder() {
        if (this._rootFolder == null) {
            this._rootFolder = new WorkspacesWrapper(ModelArb.getString((int)42), IdeArb.getIcon((int)157));
        }
        return this._rootFolder;
    }

    private JMenuItem createNavigateMenuItem() {
        IdeAction ideAction = IdeAction.get((int)57, (String)"oracle.ide.cmd.NotImplementedCommand", (String)IdeArb.getString((int)352));
        return Ide.getMenubar().createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_NAVIGATOR);
    }

    SystemNavigatorManager() {
    }
}

