/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdevimpl.model.NewWorkingSetPanel;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.model.WorkingSetsPanel;
import oracle.jdevimpl.navigator.LibraryFolder;
import oracle.jdevimpl.navigator.Res;

final class WorkingSetSupport
extends NavigatorInit
implements Controller {
    private final ToggleAction _workingSeNonAction;
    private final MenuToolButton _workingSetMenu;
    private IdeAction _newFromSelectionAction;
    private IdeAction _unhideAction;
    private IdeAction _unhideAllAction;
    private IdeAction _hideSelectionAction;
    private static IdeAction _addToWorkingSetAction;
    private static IdeAction _manageWorkingSetsAction;
    private static final String ACTION_WORK_SET_PREFIX = "working-set-";

    void $init$() {
        this._workingSeNonAction = new WorkingSetNonAction();
        this._workingSetMenu = new MenuToolButton(this._workingSeNonAction);
    }

    static void init(ProjectNavigatorManager projectNavigatorManager) {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(WorkingSetSupport.class.getClassLoader(), "oracle/jdevimpl/navigator/accelerators.xml");
        projectNavigatorManager.addNavigatorInit(new NavigatorInitFactory(WorkingSetSupport.class));
    }

    WorkingSetSupport(NavigatorWindow navigatorWindow, Context context) {
        super(navigatorWindow, context);
        this.$init$();
        this._workingSetMenu.addPopupMenuListener((PopupMenuListener)new 10());
        this.createAddToWorkingSetAction();
        if (_manageWorkingSetsAction == null) {
            IdeAction ideAction = this.createManageWorkingSetsAction();
            JMenu jMenu = IdeMenus.findOrCreateJMenu((String)"ViewOptions");
            JMenuItem jMenuItem = IdeMenus.createMenuItem((IdeAction)ideAction, (float)MenuConstants.increment((float)MenuConstants.WEIGHT_TOOLS_DEFAULT_PROJECT_PROPERTIES));
            Ide.getMenubar().add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_OPTIONS_MANAGE_WORKING_SETS);
        }
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean("enable-working-sets", true);
    }

    public void initToolbar(Toolbar toolbar) {
        toolbar.add((Component)this._workingSetMenu, 4);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Project project = context.getProject();
        WorkingSets workingSets = WorkingSets.getInstance((Project)project);
        String string = (String)ideAction.getValue("Name");
        WorkingSetSupport.saveWorkingSetChanges(project, new 9(this, workingSets, string));
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        ideAction.setEnabled(context.getProject() != null);
        return true;
    }

    private void repopulateWorkingSetMenu(JPopupMenu jPopupMenu) {
        this._workingSetMenu.removeAllPopupItems();
        NavigatorWindow navigatorWindow = this.getNavigatorWindow();
        Context context = navigatorWindow.getContext();
        if (context != null) {
            Project project = context.getProject();
            if (project != null) {
                WorkingSets workingSets = WorkingSets.getInstance((Project)project);
                String string = workingSets.getCurrentWorkingSetName();
                List list = workingSets.getWorkingSetNames();
                Iterator iterator = list.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string2 = iterator.next().toString();
                    IdeAction ideAction = this.createWorkSetToggleAction(n++, string2);
                    if (string2.equals(string)) {
                        ideAction.putValue("State", (Object)Boolean.TRUE);
                    }
                    this._workingSetMenu.addPopupItem((ToggleAction)ideAction);
                }
                if (n > 0) {
                    jPopupMenu.addSeparator();
                }
            }
            IdeAction ideAction = this.createHideSelectionAction();
            ideAction.updateAction(context);
            this._workingSetMenu.addPopupItem((ToggleAction)ideAction);
            IdeAction ideAction2 = this.createUnhideAction();
            ideAction2.updateAction(context);
            this._workingSetMenu.addPopupItem((ToggleAction)ideAction2);
            IdeAction ideAction3 = this.createUnhideAllAction();
            ideAction3.updateAction(context);
            this._workingSetMenu.addPopupItem((ToggleAction)ideAction3);
            jPopupMenu.addSeparator();
            IdeAction ideAction4 = this.createNewFromSelectionAction();
            ideAction4.updateAction(context);
            this._workingSetMenu.addPopupItem((ToggleAction)ideAction4);
            IdeAction ideAction5 = this.createManageWorkingSetsAction();
            ideAction5.updateAction(context);
            this._workingSetMenu.addPopupItem((ToggleAction)ideAction5);
        }
    }

    private IdeAction createNewFromSelectionAction() {
        if (this._newFromSelectionAction == null) {
            this._newFromSelectionAction = this.createAction("working-set-new-from-selection", Res.getString(7), Res.getInteger(8), null);
            8 var1_1 = new 8();
            this._newFromSelectionAction.addController((Controller)var1_1);
        }
        return this._newFromSelectionAction;
    }

    private IdeAction createUnhideAction() {
        if (this._unhideAction == null) {
            this._unhideAction = this.createAction("working-set-unhide-children", Res.getString(12), Res.getInteger(13), null);
            7 var1_1 = new 7();
            this._unhideAction.addController((Controller)var1_1);
        }
        return this._unhideAction;
    }

    private IdeAction createUnhideAllAction() {
        if (this._unhideAllAction == null) {
            this._unhideAllAction = this.createAction("working-set-unhide-all-children", Res.getString(15), Res.getInteger(16), null);
            6 var1_1 = new 6();
            this._unhideAllAction.addController((Controller)var1_1);
        }
        return this._unhideAllAction;
    }

    private IdeAction createHideSelectionAction() {
        if (this._hideSelectionAction == null) {
            this._hideSelectionAction = this.createAction("working-set-hide-selection", Res.getString(9), Res.getInteger(10), null);
            5 var1_1 = new 5();
            this._hideSelectionAction.addController((Controller)var1_1);
        }
        return this._hideSelectionAction;
    }

    private IdeAction createAddToWorkingSetAction() {
        if (_addToWorkingSetAction == null) {
            String string = Res.getString(20);
            String string2 = StringUtils.stripMnemonic((String)string);
            String string3 = MenuManager.getJMenu((String)"Tools").getText();
            char c = Res.getMnemonic(21);
            _addToWorkingSetAction = IdeAction.get((int)WorkingSets.ADD_TO_WORKING_SET_CMD_ID, null, (String)string2, (String)string3, (Integer)new Integer(c), (ResourceBundle)Res.getInstance(), null, null, (boolean)false);
            4 var5_5 = new 4();
            _addToWorkingSetAction.addController((Controller)var5_5);
        }
        return _addToWorkingSetAction;
    }

    private IdeAction createManageWorkingSetsAction() {
        if (_manageWorkingSetsAction == null) {
            _manageWorkingSetsAction = this.createAction("working-set-manage-working-sets", Res.getString(17), Res.getInteger(18), null);
            3 var1_1 = new 3();
            _manageWorkingSetsAction.addController((Controller)var1_1);
        }
        return _manageWorkingSetsAction;
    }

    private static void saveWorkingSetChanges(Project project, Runnable runnable) {
        project.applyBatchChanges(runnable);
        try {
            project.saveUserProperties();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private WorkingSet getEditableWorkingSet(Project project) {
        WorkingSet workingSet = WorkingSets.getInstance((Project)project).getCurrentWorkingSet();
        if (!WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(workingSet.getName())) {
            return workingSet;
        }
        return null;
    }

    private boolean canHide(Context context) {
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        if (this.getEditableWorkingSet(project) == null) {
            return false;
        }
        return this.canHandleSelection(context);
    }

    private boolean canUnhide(Context context) {
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        if (this.getEditableWorkingSet(project) == null) {
            return false;
        }
        if (context.getSelection().length > 0) {
            PatternFilters patternFilters = WorkingSet.getCurrentWorkingSetFilters((Project)project);
            if (!patternFilters.containsFilters()) {
                return false;
            }
            PatternFilter[] patternFilterArray = patternFilters.getFilters();
            URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
            if (tNodeArray != null) {
                int n = 0;
                while (n < tNodeArray.length) {
                    URL uRL;
                    RelativeDirectoryContextFolder relativeDirectoryContextFolder;
                    String string;
                    TNode tNode = tNodeArray[n];
                    Element element = tNode.getData();
                    if (element instanceof Project && context.getSelection().length == 1) {
                        boolean bl = true;
                        int n2 = 0;
                        while (n2 < patternFilterArray.length) {
                            if (patternFilterArray[n2].isExclude()) {
                                return true;
                            }
                            if (bl && "**".equals(patternFilterArray[n2].getPattern())) {
                                bl = false;
                            }
                            ++n2;
                        }
                        if (bl) {
                            return true;
                        }
                    }
                    if (element instanceof RelativeDirectoryContextFolder && (string = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRelativePath()) != null && !"".equals(string) && (uRL = uRLPath.toQualifiedURL(string)) != null) {
                        if (!patternFilters.isIncluded(string)) {
                            return true;
                        }
                        int n3 = 0;
                        while (n3 < patternFilterArray.length) {
                            String string2 = patternFilterArray[n3].getPattern();
                            if (patternFilterArray[n3].isExclude() && (string2.indexOf("**") >= 0 || string2.startsWith(string))) {
                                return true;
                            }
                            ++n3;
                        }
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    private boolean canHandleSelection(Context context) {
        Project project = context.getProject();
        if (project != null && context.getSelection().length > 0) {
            URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
            if (tNodeArray != null) {
                int n = 0;
                while (n < tNodeArray.length) {
                    TNode tNode = tNodeArray[n];
                    TreeNode[] treeNodeArray = tNode.getPath();
                    int n2 = treeNodeArray.length - 1;
                    while (n2 > 0) {
                        URL uRL;
                        RelativeDirectoryContextFolder relativeDirectoryContextFolder;
                        String string;
                        URL uRL2;
                        String string2;
                        TNode tNode2 = (TNode)treeNodeArray[n2];
                        Element element = tNode2.getData();
                        if (!(element instanceof Project) && !(element instanceof Workspace) && !(element instanceof LibraryFolder) && (element instanceof Locatable ? (string2 = uRLPath.toShortestRelativePath(uRL2 = ((Locatable)element).getURL())) != null : element instanceof RelativeDirectoryContextFolder && (string = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRelativePath()) != null && !"".equals(string) && (uRL = uRLPath.toQualifiedURL(string)) != null)) {
                            return true;
                        }
                        --n2;
                    }
                    ++n;
                }
                return false;
            }
        }
        return false;
    }

    private CompoundPattern[] getPatternsForSelection(Context context) {
        TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
        if (tNodeArray != null) {
            Project project = context.getProject();
            URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            ArrayList<CompoundPattern> arrayList = new ArrayList<CompoundPattern>();
            int n = 0;
            while (n < tNodeArray.length) {
                TNode tNode = tNodeArray[n];
                Element element = tNode.getData();
                if (element instanceof Locatable) {
                    URL uRL = ((Locatable)element).getURL();
                    TNode tNode2 = tNode.getAncestorTNode(RelativeDirectoryContextFolder.class, true);
                    if (tNode2 != null) {
                        RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)tNode2.getData();
                        String string = relativeDirectoryContextFolder.getRelativePath();
                        if (string.length() > 0) {
                            String string2 = string + "/" + tNode.toString();
                            arrayList.add(new CompoundPattern(string2));
                        } else {
                            URLPath uRLPath2 = relativeDirectoryContextFolder.getRootDirectories();
                            String string3 = uRLPath2.toShortestRelativePath(uRL);
                            if (string3 != null) {
                                arrayList.add(new CompoundPattern(string3));
                            }
                        }
                    } else {
                        String string;
                        Context context2;
                        boolean bl = false;
                        NavigatorWindow navigatorWindow = this.getNavigatorWindow();
                        if (navigatorWindow != null && (context2 = navigatorWindow.getContext()).containsProperty("flat-level") && context2.getInt("flat-level") == 0) {
                            URL[] uRLArray = uRLPath.getEntries();
                            int n2 = 0;
                            while (n2 < uRLArray.length) {
                                String string4 = new URLPath(uRLArray[n2]).toRelativePath(uRL);
                                if (string4 != null) {
                                    arrayList.add(new CompoundPattern(string4));
                                    bl = true;
                                }
                                ++n2;
                            }
                        }
                        if (!bl && (string = uRLPath.toShortestRelativePath(uRL)) != null) {
                            arrayList.add(new CompoundPattern(string));
                        }
                    }
                } else if (element instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
                    String string = relativeDirectoryContextFolder.getRelativePath();
                    CompoundPattern compoundPattern = new CompoundPattern(string);
                    arrayList.add(compoundPattern);
                    List list = this.getImpliedSubPatterns(tNode, string, uRLPath);
                    if (list.size() > 0) {
                        compoundPattern.addAdditionalFilter(list);
                    }
                }
                ++n;
            }
            return arrayList.toArray(new CompoundPattern[arrayList.size()]);
        }
        return new CompoundPattern[0];
    }

    private CompoundPattern[] getUnhidePatternsSelection(Context context) {
        TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
        if (tNodeArray != null) {
            Project project = context.getProject();
            URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            ArrayList<CompoundPattern> arrayList = new ArrayList<CompoundPattern>();
            int n = 0;
            while (n < tNodeArray.length) {
                RelativeDirectoryContextFolder relativeDirectoryContextFolder;
                String string;
                URL uRL;
                TNode tNode = tNodeArray[n];
                Element element = tNode.getData();
                if (element instanceof Project && context.getSelection().length == 1) {
                    arrayList.add(new CompoundPattern("**"));
                    break;
                }
                if (element instanceof RelativeDirectoryContextFolder && (uRL = uRLPath.toQualifiedURL(string = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRelativePath())) != null) {
                    CompoundPattern compoundPattern = new CompoundPattern(string);
                    arrayList.add(compoundPattern);
                    List list = this.getImpliedSubPatterns(tNode, string, uRLPath);
                    if (list.size() > 0) {
                        compoundPattern.addAdditionalFilter(list);
                    }
                }
                ++n;
            }
            return arrayList.toArray(new CompoundPattern[arrayList.size()]);
        }
        return new CompoundPattern[0];
    }

    private List getImpliedSubPatterns(TNode tNode, String string, URLPath uRLPath) {
        TNode tNode2 = (TNode)tNode.getParent();
        Enumeration enumeration = tNode2.getChildTNodes();
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            RelativeDirectoryContextFolder relativeDirectoryContextFolder;
            String string2;
            URL uRL;
            TNode tNode3 = (TNode)enumeration.nextElement();
            Element element = tNode3.getData();
            if (element instanceof Locatable) {
                element = ((TNode)tNode3.getParent()).getData();
            }
            if (!(element instanceof RelativeDirectoryContextFolder) || (uRL = uRLPath.toQualifiedURL(string2 = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRelativePath())) == null) continue;
            if (string2.startsWith(string) && !string2.equals(string)) {
                arrayList.add(string2);
                bl = true;
                continue;
            }
            if (bl) break;
        }
        return arrayList;
    }

    private void simplifyFilters(PatternFilters patternFilters) {
        PatternFilter[] patternFilterArray = patternFilters.getFilters();
        if (patternFilterArray.length > 0 && patternFilterArray[0].getPattern().equals("**")) {
            patternFilters.setFilters(new PatternFilter[]{patternFilterArray[0]});
        } else {
            int n = patternFilterArray.length;
            int n2 = 0;
            while (n2 < patternFilterArray.length) {
                if ("**".equals(patternFilterArray[n2].getPattern())) {
                    n = n2 + 1;
                    break;
                }
                ++n2;
            }
            if (n < patternFilterArray.length) {
                PatternFilter[] patternFilterArray2 = new PatternFilter[n];
                System.arraycopy(patternFilterArray, 0, patternFilterArray2, 0, n);
                patternFilters.setFilters(patternFilterArray2);
            }
        }
    }

    private static String[] getInitialSelectionPath(Context context) {
        TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
        if (tNodeArray != null && tNodeArray.length > 0) {
            RelativeDirectoryContextFolder relativeDirectoryContextFolder;
            String string;
            TNode tNode = tNodeArray[0];
            String string2 = null;
            Element element = tNode.getData();
            if (element instanceof Locatable) {
                URL uRL = ((Locatable)element).getURL();
                string2 = "/" + URLFileSystem.getFileName((URL)uRL);
                TNode tNode2 = (TNode)tNode.getParent();
                if (tNode2 != null) {
                    element = tNode2.getData();
                }
            }
            if (element instanceof RelativeDirectoryContextFolder && (string = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRelativePath()) != null && !"".equals(string)) {
                if (string2 != null) {
                    string = string + string2;
                }
                return string.split("/");
            }
        } else {
            Node node = context.getNode();
            if (node != null) {
                URL uRL = node.getURL();
                String string = ProjectContent.getInstance((PropertyStorage)context.getProject()).getAllContents().getAllRootDirs().toShortestRelativePath(uRL);
                if (string != null && !"".equals(string)) {
                    return string.split("/");
                }
            }
        }
        return new String[0];
    }

    private Runnable doUnhide(Context context, PatternFilters patternFilters, CompoundPattern[] compoundPatternArray, boolean bl) {
        return new 2(this, compoundPatternArray, patternFilters, context, bl);
    }

    private Runnable doAddFilters(PatternFilters patternFilters, CompoundPattern[] compoundPatternArray, boolean bl) {
        return new 1(this, compoundPatternArray, bl, patternFilters);
    }

    private IdeAction createWorkSetToggleAction(int n, String string) {
        IdeAction ideAction = this.createAction(ACTION_WORK_SET_PREFIX + n, string, null, null);
        ideAction.addController((Controller)this);
        ideAction.putValue("Name", (Object)string);
        ideAction.putValue("Check", (Object)Boolean.TRUE);
        ideAction.putValue("State", (Object)Boolean.FALSE);
        return ideAction;
    }

    private IdeAction createAction(String string, String string2, Integer n, Icon icon) {
        int n2 = Ide.findOrCreateCmdID((String)string);
        String string3 = MenuManager.getJMenu((String)"View").getText();
        return IdeAction.get((int)n2, (String)string, (String)string2, (String)string3, (Integer)n, (Icon)icon, null, (boolean)true);
    }

    private int calculateDepth(String string) {
        int n = 1;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '/') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    static void mav$repopulateWorkingSetMenu(WorkingSetSupport workingSetSupport, JPopupMenu jPopupMenu) {
        workingSetSupport.repopulateWorkingSetMenu(jPopupMenu);
    }

    static boolean mav$canHandleSelection(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.canHandleSelection(context);
    }

    static void maS$saveWorkingSetChanges(Project project, Runnable runnable) {
        WorkingSetSupport.saveWorkingSetChanges(project, runnable);
    }

    static CompoundPattern[] mav$getPatternsForSelection(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.getPatternsForSelection(context);
    }

    static Runnable mav$doAddFilters(WorkingSetSupport workingSetSupport, PatternFilters patternFilters, CompoundPattern[] compoundPatternArray, boolean bl) {
        return workingSetSupport.doAddFilters(patternFilters, compoundPatternArray, bl);
    }

    static boolean mav$canUnhide(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.canUnhide(context);
    }

    static WorkingSet mav$getEditableWorkingSet(WorkingSetSupport workingSetSupport, Project project) {
        return workingSetSupport.getEditableWorkingSet(project);
    }

    static CompoundPattern[] mav$getUnhidePatternsSelection(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.getUnhidePatternsSelection(context);
    }

    static Runnable mav$doUnhide(WorkingSetSupport workingSetSupport, Context context, PatternFilters patternFilters, CompoundPattern[] compoundPatternArray, boolean bl) {
        return workingSetSupport.doUnhide(context, patternFilters, compoundPatternArray, bl);
    }

    static boolean mav$canHide(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.canHide(context);
    }

    static NavigatorWindow mav$getNavigatorWindow(WorkingSetSupport workingSetSupport) {
        return workingSetSupport.getNavigatorWindow();
    }

    static String[] maS$getInitialSelectionPath(Context context) {
        return WorkingSetSupport.getInitialSelectionPath(context);
    }

    static void mav$simplifyFilters(WorkingSetSupport workingSetSupport, PatternFilters patternFilters) {
        workingSetSupport.simplifyFilters(patternFilters);
    }

    static int mav$calculateDepth(WorkingSetSupport workingSetSupport, String string) {
        return workingSetSupport.calculateDepth(string);
    }

    final class 10
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            WorkingSetSupport.mav$repopulateWorkingSetMenu(WorkingSetSupport.this, (JPopupMenu)popupMenuEvent.getSource());
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    final class 9
    implements Runnable {
        private final /* synthetic */ WorkingSets v$workingSets;
        private final /* synthetic */ String v$workingSetName;
        final /* synthetic */ WorkingSetSupport this$0;

        public void run() {
            this.v$workingSets.setCurrentWorkingSetName(this.v$workingSetName);
        }

        public 9(WorkingSetSupport workingSetSupport, WorkingSets workingSets, String string) {
            this.v$workingSetName = string;
            this.v$workingSets = workingSets;
            this.this$0 = workingSetSupport;
        }
    }

    final class 8
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            NewWorkingSetPanel newWorkingSetPanel = new NewWorkingSetPanel();
            newWorkingSetPanel.setHelpID("f1_idednewworkingset_html");
            Project project = context.getProject();
            WorkingSets workingSets = WorkingSets.getInstance((Project)project);
            Namespace namespace = new Namespace();
            TDialogLauncher tDialogLauncher = newWorkingSetPanel.getTDialogLauncher((Component)Ide.getMainWindow(), namespace);
            boolean bl = tDialogLauncher.showDialog();
            if (bl) {
                String string = (String)namespace.find("name");
                WorkingSetSupport.maS$saveWorkingSetChanges(project, new 1(this, workingSets, string, context));
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = WorkingSetSupport.mav$canHandleSelection(WorkingSetSupport.this, context);
            ideAction.setEnabled(bl);
            return true;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WorkingSets v$workingSets;
            private final /* synthetic */ String v$wsName;
            private final /* synthetic */ Context v$context;
            final /* synthetic */ 8 this$0;

            public void run() {
                WorkingSet workingSet = this.v$workingSets.getWorkingSet(this.v$wsName);
                CompoundPattern[] compoundPatternArray = WorkingSetSupport.mav$getPatternsForSelection(this.this$0.WorkingSetSupport.this, this.v$context);
                PatternFilters patternFilters = workingSet.getPatternFilters();
                patternFilters.setFilters(new PatternFilter[0]);
                WorkingSetSupport.mav$doAddFilters(this.this$0.WorkingSetSupport.this, patternFilters, compoundPatternArray, true).run();
                this.v$workingSets.setCurrentWorkingSetName(this.v$wsName);
            }

            public 1(8 var1_1, WorkingSets workingSets, String string, Context context) {
                this.v$context = context;
                this.v$wsName = string;
                this.v$workingSets = workingSets;
                this.this$0 = var1_1;
            }
        }
    }

    final class 7
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Project project = context.getProject();
            WorkingSet workingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, project);
            PatternFilters patternFilters = workingSet.getPatternFilters();
            CompoundPattern[] compoundPatternArray = WorkingSetSupport.mav$getUnhidePatternsSelection(WorkingSetSupport.this, context);
            WorkingSetSupport.maS$saveWorkingSetChanges(project, WorkingSetSupport.mav$doUnhide(WorkingSetSupport.this, context, patternFilters, compoundPatternArray, false));
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = WorkingSetSupport.mav$canUnhide(WorkingSetSupport.this, context);
            ideAction.setEnabled(bl);
            return true;
        }
    }

    final class 6
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Project project = context.getProject();
            WorkingSet workingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, project);
            PatternFilters patternFilters = workingSet.getPatternFilters();
            CompoundPattern[] compoundPatternArray = WorkingSetSupport.mav$getUnhidePatternsSelection(WorkingSetSupport.this, context);
            WorkingSetSupport.maS$saveWorkingSetChanges(project, WorkingSetSupport.mav$doUnhide(WorkingSetSupport.this, context, patternFilters, compoundPatternArray, true));
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = WorkingSetSupport.mav$canUnhide(WorkingSetSupport.this, context);
            ideAction.setEnabled(bl);
            return true;
        }
    }

    final class 5
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Project project = context.getProject();
            WorkingSet workingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, project);
            PatternFilters patternFilters = workingSet.getPatternFilters();
            CompoundPattern[] compoundPatternArray = WorkingSetSupport.mav$getPatternsForSelection(WorkingSetSupport.this, context);
            WorkingSetSupport.maS$saveWorkingSetChanges(project, WorkingSetSupport.mav$doAddFilters(WorkingSetSupport.this, patternFilters, compoundPatternArray, false));
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = WorkingSetSupport.mav$canHide(WorkingSetSupport.this, context);
            ideAction.setEnabled(bl);
            return true;
        }
    }

    final class 4
    implements Controller {
        private String relPath;
        private Project activeProject;
        private WorkingSet activeWorkingSet;

        public boolean handleEvent(IdeAction ideAction, Context context) {
            Element element = context.getElement();
            if (element != null && this.relPath != null && this.activeWorkingSet != null) {
                1 var4_4 = new 1(this, element);
                IdeUtil.invokeAfterRepaint((Runnable)var4_4);
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            Project project;
            this.relPath = null;
            this.activeProject = null;
            this.activeWorkingSet = null;
            Element element = context.getElement();
            if (element == null || !(element instanceof Locatable)) {
                ideAction.setEnabled(false);
                return true;
            }
            URL uRL = ((Locatable)element).getURL();
            if (this.enableAction(ideAction, element, uRL, project = context.getProject())) {
                return true;
            }
            Workspace workspace = context.getWorkspace();
            if (this.enableAction(ideAction, element, uRL, project, workspace)) {
                return true;
            }
            Workspaces workspaces = Ide.getWorkspaces();
            if (workspaces != null) {
                Iterator iterator = workspaces.getChildren();
                while (iterator.hasNext()) {
                    Workspace workspace2 = (Workspace)iterator.next();
                    if (workspace == workspace2 || !this.enableAction(ideAction, element, uRL, project, workspace2)) continue;
                    return true;
                }
            }
            ideAction.setEnabled(false);
            return true;
        }

        private boolean enableAction(IdeAction ideAction, Element element, URL uRL, Project project, Workspace workspace) {
            if (workspace != null && project != null) {
                Iterator iterator = workspace.getChildren();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (project == e || !(e instanceof Project) || !this.enableAction(ideAction, element, uRL, (Project)e)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean enableAction(IdeAction ideAction, Element element, URL uRL, Project project) {
            if (project != null && project.containsChild(element)) {
                boolean bl;
                this.activeProject = project;
                this.activeWorkingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, project);
                if (this.activeWorkingSet != null) {
                    URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
                    this.relPath = uRLPath.toRelativePath(uRL);
                    bl = !this.activeWorkingSet.getPatternFilters().isIncluded(this.relPath);
                } else {
                    bl = false;
                }
                ideAction.setEnabled(bl);
                return true;
            }
            return false;
        }

        static Project ra$activeProject(4 var0) {
            return var0.activeProject;
        }

        static WorkingSet ra$activeWorkingSet(4 var0) {
            return var0.activeWorkingSet;
        }

        static String ra$relPath(4 var0) {
            return var0.relPath;
        }

        final class oracle.jdevimpl.navigator.WorkingSetSupport$4$1
        implements Runnable {
            private final /* synthetic */ Element v$element;
            final /* synthetic */ 4 this$0;

            public void run() {
                try {
                    WorkingSetSupport.maS$saveWorkingSetChanges(4.ra$activeProject(this.this$0), new 1());
                    String string = Res.format(22, this.v$element.getShortLabel(), 4.ra$activeWorkingSet(this.this$0).getName());
                    Ide.getStatusBar().setText(string);
                    NavigatorWindow navigatorWindow = WorkingSetSupport.mav$getNavigatorWindow(this.this$0.WorkingSetSupport.this);
                    if (navigatorWindow.isVisible()) {
                        TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
                        TNode tNode = treeExplorer.findTNode(this.v$element, null);
                        treeExplorer.setSelected(tNode);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public oracle.jdevimpl.navigator.WorkingSetSupport$4$1(4 var1_1, Element element) {
                this.v$element = element;
                this.this$0 = var1_1;
            }

            final class 1
            implements Runnable {
                public void run() {
                    4.ra$activeWorkingSet(1.this.this$0).getPatternFilters().addInclude(4.ra$relPath(1.this.this$0));
                }
            }
        }
    }

    final class 3
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Project project = context.getProject();
            Project project2 = (Project)project.copyTo(null);
            Namespace namespace = new Namespace();
            namespace.put("Project", (Object)project2);
            ChangeBuffer changeBuffer = new ChangeBuffer();
            project2.getUserPropertiesOnly().addStructureChangeListener((StructureChangeListener)changeBuffer);
            namespace.put("initial-selection", (Object)WorkingSetSupport.maS$getInitialSelectionPath(context));
            WorkingSetsPanel workingSetsPanel = new WorkingSetsPanel();
            TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), WorkingSetsEditor.NAVIGABLE_LABEL, (Traversable)workingSetsPanel, namespace);
            tDialogLauncher.setPackDialog(false);
            JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
            jEWTDialog.setMaximumInitialSize(525, 400);
            boolean bl = jEWTDialog.runDialog();
            jEWTDialog.dispose();
            project2.getUserPropertiesOnly().removeStructureChangeListener((StructureChangeListener)changeBuffer);
            if (bl && ModelUtil.areDifferent((Object)project, (Object)project2)) {
                WorkingSetSupport.maS$saveWorkingSetChanges(project, new 1(this, project, changeBuffer));
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(context.getProject() != null && context.getView() instanceof ProjectNavigatorWindow);
            return true;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Project v$project;
            private final /* synthetic */ ChangeBuffer v$userChangeBuffer;
            final /* synthetic */ 3 this$0;

            public void run() {
                this.v$project.getUserPropertiesOnly().applyChanges(this.v$userChangeBuffer.getChanges());
            }

            public 1(3 var1_1, Project project, ChangeBuffer changeBuffer) {
                this.v$userChangeBuffer = changeBuffer;
                this.v$project = project;
                this.this$0 = var1_1;
            }
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ CompoundPattern[] v$compoundPatterns;
        private final /* synthetic */ PatternFilters v$filters;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ boolean v$unhideAll;
        final /* synthetic */ WorkingSetSupport this$0;

        public void run() {
            if (this.v$compoundPatterns.length == 1 && this.v$compoundPatterns[0]._primaryFilter.equals("**")) {
                this.v$filters.setFilters(new PatternFilter[0]);
                this.v$filters.addInclude("**");
                return;
            }
            WorkingSetSupport.mav$simplifyFilters(this.this$0, this.v$filters);
            int n = this.getFlatLevel(this.v$context);
            ArrayList<PatternFilter> arrayList = new ArrayList<PatternFilter>(Arrays.asList(this.v$filters.getFilters()));
            int n2 = arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PatternFilter patternFilter = (PatternFilter)iterator.next();
                if (patternFilter.isInclude()) continue;
                String string = patternFilter.getPattern();
                int n3 = 0;
                while (n3 < this.v$compoundPatterns.length) {
                    String string2 = this.v$compoundPatterns[n3]._primaryFilter;
                    if (!string.equals(string2) && string.startsWith(string2)) {
                        int n4;
                        if (this.v$unhideAll || n == 1) {
                            iterator.remove();
                        } else if (WorkingSetSupport.mav$calculateDepth(this.this$0, string) > n && ((n4 = string.indexOf("/**/")) == -1 || n4 == string2.length())) {
                            iterator.remove();
                        }
                    }
                    ++n3;
                }
            }
            if (arrayList.size() < n2) {
                PatternFilter[] patternFilterArray = arrayList.toArray(new PatternFilter[arrayList.size()]);
                this.v$filters.setFilters(patternFilterArray);
            }
            int n5 = 0;
            while (n5 < this.v$compoundPatterns.length) {
                String string = this.v$compoundPatterns[n5]._primaryFilter;
                if (WorkingSetSupport.mav$calculateDepth(this.this$0, string) < n) {
                    string = string + "/*";
                }
                this.v$filters.addInclude(string, true);
                ++n5;
            }
        }

        private int getFlatLevel(Context context) {
            View view = context.getView();
            if (view instanceof ProjectNavigatorWindow) {
                ProjectNavigatorWindow projectNavigatorWindow = (ProjectNavigatorWindow)view;
                Context context2 = new Context();
                projectNavigatorWindow.copyPreferencesTo(context2);
                return context2.getInt("flat-level");
            }
            String string = view != null ? view.getClass().getName() : "null";
            return Integer.MAX_VALUE;
        }

        public 2(WorkingSetSupport workingSetSupport, CompoundPattern[] compoundPatternArray, PatternFilters patternFilters, Context context, boolean bl) {
            this.v$unhideAll = bl;
            this.v$context = context;
            this.v$filters = patternFilters;
            this.v$compoundPatterns = compoundPatternArray;
            this.this$0 = workingSetSupport;
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ CompoundPattern[] v$compoundPatterns;
        private final /* synthetic */ boolean v$unhide;
        private final /* synthetic */ PatternFilters v$filters;
        final /* synthetic */ WorkingSetSupport this$0;

        public void run() {
            int n = 0;
            while (n < this.v$compoundPatterns.length) {
                String string = this.v$compoundPatterns[n]._primaryFilter;
                if (this.v$unhide) {
                    this.v$filters.addInclude(string, true);
                } else {
                    this.v$filters.addExclude(string, true);
                }
                if (this.v$compoundPatterns[n].hasAdditionalFilters()) {
                    List list = this.v$compoundPatterns[n]._secondaryFilters;
                    for (String string2 : list) {
                        if (this.v$unhide) {
                            this.v$filters.addExclude(string2, true);
                            continue;
                        }
                        this.v$filters.addInclude(string2, true);
                    }
                }
                ++n;
            }
            WorkingSetSupport.mav$simplifyFilters(this.this$0, this.v$filters);
        }

        public 1(WorkingSetSupport workingSetSupport, CompoundPattern[] compoundPatternArray, boolean bl, PatternFilters patternFilters) {
            this.v$filters = patternFilters;
            this.v$unhide = bl;
            this.v$compoundPatterns = compoundPatternArray;
            this.this$0 = workingSetSupport;
        }
    }

    private class CompoundPattern {
        String _primaryFilter;
        List _secondaryFilters;

        CompoundPattern(String string) {
            this._primaryFilter = string;
        }

        public void addAdditionalFilter(List list) {
            if (this._secondaryFilters == null) {
                this._secondaryFilters = new ArrayList();
            }
            this._secondaryFilters.addAll(list);
        }

        public boolean hasAdditionalFilters() {
            return this._secondaryFilters != null && this._secondaryFilters.size() > 0;
        }
    }

    private class WorkingSetNonAction
    extends ToggleAction {
        WorkingSetNonAction() {
            super(Res.getString(6), Res.getInstance(), 19);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

