/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.help.HelpSystem;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ide.resource.IdeIcons;
import oracle.jdevimpl.palette.CodeSnippetPanel;

public class CodeSnippetWizard
implements Invokable,
VetoableChangeListener {
    private JEWTDialog _dlg;
    private CodeSnippetPanel _panel;
    private CodeEditor _editor;
    private Context _context;
    private PaletteManager pm;
    private Palette _palette;
    private boolean _pageSet;

    void $init$() {
        this._panel = null;
        this._editor = null;
        this._context = null;
        this.pm = PaletteManager.getPaletteManager();
        this._palette = this.pm.getPalette();
        this._pageSet = false;
    }

    public boolean invoke(Context context, String[] stringArray) {
        this._panel = new CodeSnippetPanel();
        this._pageSet = true;
        this._context = context;
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), "Add Code Snippet", 7);
        this._dlg.setContent((Component)this._panel);
        this._dlg.setPreferredSize(new Dimension(500, 300));
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._dlg.getContent(), "f1_idedaddsnippet_html");
        boolean bl = this._dlg.runDialog();
        this._dlg.removeVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.dispose();
        return bl;
    }

    public boolean invoke(Context context, CodeEditor codeEditor) {
        this._panel = new CodeSnippetPanel();
        this._editor = codeEditor;
        this._context = context;
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), "Add Code Snippet", 7);
        String string = codeEditor.getSelectedText();
        if (string.trim().length() > 0) {
            this._panel.setSnippet(string);
        }
        this._dlg.setContent((Component)this._panel);
        this._dlg.setPreferredSize(new Dimension(500, 300));
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._dlg.getContent(), "f1_idedaddsnippet_html");
        boolean bl = this._dlg.runDialog();
        this._dlg.removeVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.dispose();
        return bl;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this.addSnippet()) {
            throw new PropertyVetoException("no", propertyChangeEvent);
        }
    }

    private boolean addSnippet() {
        boolean bl = true;
        String string = "";
        if (this._panel.getName().trim().length() == 0) {
            string = "You must choose a name for your Code Snippet";
            bl = false;
            this._panel.getNameFld().requestFocus();
        } else if (this._panel.getSnippet().trim().length() == 0) {
            string = "There is no snippet to add. Please create a snippet to add.";
            bl = false;
            this._panel.getSnippetFld().requestFocus();
        } else if (this._palette.getPaletteItem(this._panel.getName(), "Code Snippets") != null) {
            string = "Name already exists. Select another name.";
            bl = false;
            this._panel.getNameFld().requestFocus();
        }
        if (!bl) {
            JOptionPane.showMessageDialog((Component)this._dlg, string, "Jdeveloper Message", 0);
            return false;
        }
        if (!this._pageSet) {
            PalettePage palettePage = this._palette.getPalettePage("Code Snippets");
            palettePage.getPaletteItems();
            this._palette.setEditPage(palettePage);
        }
        PalettePage palettePage = this._palette.getEditPage();
        palettePage.addPaletteItem(IdeIcons.getString((int)2), "Code Snippet", true, this._panel.getName(), this._panel.getName(), "jsp", "oracle.jdeveloper.palette.wizard.CodeSnippetEditor", "");
        PaletteItem paletteItem = palettePage.getPaletteItem(this._panel.getName());
        paletteItem.setItemCodeSnippet(this._panel.getSnippet());
        return true;
    }

    public CodeSnippetWizard() {
        this.$init$();
    }
}

