/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.util.BitSet;
import java.util.HashMap;
import oracle.jdevimpl.profiler.support.Capabilities;

public class CapabilitiesImpl
implements Capabilities {
    private BitSet capabilities = new BitSet();
    private static final String[] capabilityStrings = new String[]{"RTH", "PTI", "RUT", "RST", "RCT", "RET", "RWT", "REM", "RCS", "REX", "SHP", "PME", "RAL", "RAS", "RIO", "RMU", "RIU", "REU", "PEV"};
    private static HashMap<String, Integer> stringToBit = new HashMap();

    static {
        int n = 0;
        while (n < capabilityStrings.length) {
            stringToBit.put(capabilityStrings[n], n);
            ++n;
        }
    }

    public CapabilitiesImpl() {
    }

    public CapabilitiesImpl(CapabilitiesImpl capabilitiesImpl) {
        this();
        this.capabilities.or(capabilitiesImpl.capabilities);
    }

    private void set(String string) {
        Integer n = stringToBit.get(string.toUpperCase());
        if (n == null) {
            throw new IllegalArgumentException("Internal error: invalid capability '" + string + "'");
        }
        this.capabilities.set(n);
    }

    public CapabilitiesImpl(String string, String string2, String string3) {
        this();
        int n = string.length();
        int n2 = string3.length();
        int n3 = string.length() - n2;
        int n4 = string2.length();
        if (n < n4 + n2 || !string.startsWith(string2) || !string.endsWith(string3)) {
            throw new IllegalArgumentException("Internal error: invalid capabilities " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = n4;
        while (n5 < n3) {
            char c = string.charAt(n5);
            if (c == ';') {
                this.set(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(c);
            }
            ++n5;
        }
        if (stringBuffer.length() > 0) {
            this.set(stringBuffer.toString());
        }
    }

    public boolean canProfileTime() {
        return this.capabilities.get(0);
    }

    public void setProfileTime(boolean bl) {
        this.capabilities.set(0, bl);
    }

    public boolean canReportUserTime() {
        return this.capabilities.get(1);
    }

    public void setReportUserTime(boolean bl) {
        this.capabilities.set(1, bl);
    }

    public boolean canReportSystemTime() {
        return this.capabilities.get(2);
    }

    public void setReportSystemTime(boolean bl) {
        this.capabilities.set(2, bl);
    }

    public boolean canReportCombinedTime() {
        return this.capabilities.get(3);
    }

    public void setReportCombinedTime(boolean bl) {
        this.capabilities.set(3, bl);
    }

    public boolean canReportElapsedTime() {
        return this.capabilities.get(4);
    }

    public void setReportElapsedTime(boolean bl) {
        this.capabilities.set(4, bl);
    }

    public boolean canReportWaitTime() {
        return this.capabilities.get(5);
    }

    public void setReportWaitTime(boolean bl) {
        this.capabilities.set(5, bl);
    }

    public boolean canReportExactMethodCount() {
        return this.capabilities.get(6);
    }

    public void setReportExactMethodCount(boolean bl) {
        this.capabilities.set(6, bl);
    }

    public boolean canReportCallStack() {
        return this.capabilities.get(7);
    }

    public void setReportCallStack(boolean bl) {
        this.capabilities.set(7, bl);
    }

    public boolean canReportCallThread() {
        return this.capabilities.get(8);
    }

    public void setReportCallThread(boolean bl) {
        this.capabilities.set(8, bl);
    }

    public boolean canReportExactTimes() {
        return this.capabilities.get(9);
    }

    public void setReportExactTimes(boolean bl) {
        this.capabilities.set(9, bl);
    }

    public boolean canSetHighPrecision() {
        return this.capabilities.get(10);
    }

    public void setHighPrecision(boolean bl) {
        this.capabilities.set(10, bl);
    }

    public boolean canProfileMemory() {
        return this.capabilities.get(0);
    }

    public void setProfileMemory(boolean bl) {
        this.capabilities.set(0, bl);
    }

    public boolean canReportAllocatingLoader() {
        return this.capabilities.get(12);
    }

    public void setReportAllocatingLoader(boolean bl) {
        this.capabilities.set(12, bl);
    }

    public boolean canReportAllocatingStack() {
        return this.capabilities.get(13);
    }

    public void setReportAllocatingStack(boolean bl) {
        this.capabilities.set(13, bl);
    }

    public boolean canReportAllocatingThread() {
        return this.capabilities.get(14);
    }

    public void setReportAllocatingThread(boolean bl) {
        this.capabilities.set(14, bl);
    }

    public boolean canReportIndividualObjects() {
        return this.capabilities.get(15);
    }

    public void setReportIndividualObjects(boolean bl) {
        this.capabilities.set(15, bl);
    }

    public boolean canReportMemoryUsed() {
        return this.capabilities.get(16);
    }

    public void setReportMemoryUsed(boolean bl) {
        this.capabilities.set(16, bl);
    }

    public boolean canReportInclusiveUsed() {
        return this.capabilities.get(17);
    }

    public void setReportInclusiveUsed(boolean bl) {
        this.capabilities.set(17, bl);
    }

    public boolean canReportExclusiveUsed() {
        return this.capabilities.get(18);
    }

    public void setReportExclusiveUsed(boolean bl) {
        this.capabilities.set(18, bl);
    }

    public boolean canProfileEvents() {
        return this.capabilities.get(19);
    }

    public void setProfileEvents(boolean bl) {
        this.capabilities.set(19, bl);
    }

    public Capabilities or(Capabilities capabilities, Capabilities capabilities2) {
        CapabilitiesImpl capabilitiesImpl = new CapabilitiesImpl((CapabilitiesImpl)capabilities);
        capabilitiesImpl.capabilities.or(((CapabilitiesImpl)capabilities2).capabilities);
        return capabilitiesImpl;
    }

    public Capabilities and(Capabilities capabilities, Capabilities capabilities2) {
        CapabilitiesImpl capabilitiesImpl = new CapabilitiesImpl((CapabilitiesImpl)capabilities);
        capabilitiesImpl.capabilities.and(((CapabilitiesImpl)capabilities2).capabilities);
        return capabilitiesImpl;
    }

    public Capabilities diff(Capabilities capabilities, Capabilities capabilities2) {
        CapabilitiesImpl capabilitiesImpl = new CapabilitiesImpl((CapabilitiesImpl)capabilities);
        BitSet bitSet = capabilitiesImpl.capabilities;
        BitSet bitSet2 = ((CapabilitiesImpl)capabilities2).capabilities;
        int n = 0;
        int n2 = capabilitiesImpl.capabilities.size();
        while (n < n2) {
            bitSet.set(n, bitSet.get(n) && !bitSet2.get(n));
            ++n;
        }
        return capabilitiesImpl;
    }

    String stringRep(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n = 0;
        int n2 = this.capabilities.size();
        while (n < n2) {
            if (this.capabilities.get(n)) {
                if (n > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append(capabilityStrings[n]);
            }
            ++n;
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

