/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.jdevimpl.profiler.jvmti.ClassInfo;
import oracle.jdevimpl.profiler.jvmti.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    private ArrayList<ClassInfo> classes;
    private HashMap<String, ArrayList> classMap;
    private Model model;
    public static final int JAVA_LANG_CLASS = 1;

    void $init$() {
        this.classes = new ArrayList();
        this.classMap = new HashMap();
    }

    public Classes(Model model) {
        this.$init$();
        this.model = model;
        this.defineClass(1, "java/lang/Class");
    }

    public void defineClass(int n, String string) {
        this.model.getObjects().defineObject(1, n);
        while (this.classes.size() <= n) {
            this.classes.add(null);
        }
        ClassInfo classInfo = this.classes.get(n);
        if (classInfo != null) {
            if (!classInfo.getName().equals(string)) {
                throw new IllegalStateException("Class id " + n + " already defined as " + classInfo.getName() + " not " + string);
            }
        } else {
            classInfo = new ClassInfo(n, string);
            this.classes.set(n, classInfo);
            ArrayList<ClassInfo> arrayList = this.classMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ClassInfo>(1);
                this.classMap.put(string, arrayList);
            }
            arrayList.add(classInfo);
        }
    }

    public ClassInfo getClassInfo(int n) {
        ClassInfo classInfo = this.classes.get(n);
        if (classInfo == null) {
            throw new IllegalStateException("Id " + n + " not defined");
        }
        return classInfo;
    }

    public ArrayList<ClassInfo> getClasses(String string) {
        return this.classMap.get(string);
    }
}

