/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import oracle.jdevimpl.profiler.jvmti.CapabilitiesImpl;
import oracle.jdevimpl.profiler.jvmti.SessionImpl;
import oracle.jdevimpl.profiler.support.SessionException;

public class Commands {
    private SessionImpl session;
    private static final char GET_CAPABILITIES = '\u0000';
    private static final char REQUEST_CAPABILITIES = '\u0001';
    private static final char START_COLLECTING = '\u0002';
    private static final char STOP_COLLECTING = '\u0003';
    private static final char SET_FILTER = '\u0004';
    private static final char SET_SAMPLE_INTERVAL = '\u0005';
    private static final char SET_CALL_STACK_MAX = '\u0006';
    private static final char SET_ALLOC_STACK_MAX = '\u0007';
    private static final char START_APPLICATION = '\n';
    private static final byte TIME = 0;
    private static final byte MEMORY = 0;
    private static final byte EVENTS = 0;

    Commands(SessionImpl sessionImpl) {
        this.session = sessionImpl;
    }

    private void sendCommand(char c) throws IOException {
        this.session.getTransport().sendByte((byte)c);
    }

    public synchronized void startApplication() throws SessionException {
        try {
            this.sendCommand('\n');
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    public synchronized void getCapabilities() throws SessionException {
        try {
            this.sendCommand('\u0000');
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    public synchronized void requestCapabilities(CapabilitiesImpl capabilitiesImpl) {
        try {
            this.sendCommand('\u0001');
            this.session.getTransport().sendString(capabilitiesImpl.stringRep("rc[", "]"));
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    private void startCollecting(byte by) {
        try {
            this.sendCommand('\u0002');
            this.session.getTransport().sendByte(by);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    private void stopCollecting(byte by) {
        try {
            this.sendCommand('\u0003');
            this.session.getTransport().sendByte(by);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    public synchronized void startCollectingTime() throws SessionException {
        this.startCollecting((byte)0);
    }

    public synchronized void stopCollectingTime() throws SessionException {
        this.stopCollecting((byte)0);
    }

    public synchronized void startCollectingMemory() throws SessionException {
        this.startCollecting((byte)0);
    }

    public synchronized void stopCollectingMemory() throws SessionException {
        this.stopCollecting((byte)0);
    }

    public synchronized void startCollectingEvents() throws SessionException {
        this.startCollecting((byte)0);
    }

    public synchronized void stopCollectingEvents() throws SessionException {
        this.stopCollecting((byte)0);
    }

    private String packFilter(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            char c = string2.charAt(n);
            if (c == ';' || c == ' ' || c == '\t' || c == ',') {
                bl2 = true;
            } else {
                if (bl2 && !bl) {
                    stringBuffer.append(';');
                }
                bl = false;
                bl2 = false;
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private void setFilter(String string) {
        try {
            this.sendCommand('\u0004');
            this.session.getTransport().sendString(string);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    public synchronized void setStackFilter(String string) throws SessionException {
        this.setFilter(this.packFilter("sf[", string, "]"));
    }

    public synchronized void setMemoryFilter(String string) throws SessionException {
        this.setFilter(this.packFilter("mf[", string, "]"));
    }

    public synchronized void setEventFilter(String string) throws SessionException {
        this.setFilter(this.packFilter("ef[", string, "]"));
    }

    public synchronized void setSampleInterval(long l) throws SessionException {
        try {
            this.sendCommand('\u0005');
            this.session.getTransport().sendLong(l);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    public synchronized void setCallStackDepth(int n) throws SessionException {
        try {
            this.sendCommand('\u0006');
            this.session.getTransport().sendInt(n);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }
}

