/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import java.util.HashMap;
import oracle.jdevimpl.jvmti.common.Transport;
import oracle.jdevimpl.profiler.jvmti.EventHandler;

public class EventManager {
    private static HashMap<Character, EventHandler> handlers;

    public void reset() {
        handlers = null;
    }

    public static synchronized void addEventHandler(char c, EventHandler eventHandler) {
        if (handlers == null) {
            handlers = new HashMap();
        }
        handlers.put(Character.valueOf(c), eventHandler);
    }

    private static synchronized EventHandler getHandler(char c) {
        if (handlers == null) {
            throw new IllegalStateException("Internal error: no event handlers installed");
        }
        if (!handlers.containsKey(Character.valueOf(c))) {
            throw new IllegalStateException("Internal error: no event handlers installed for event " + c);
        }
        return handlers.get(Character.valueOf(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEvent(char c, Transport transport) throws IOException {
        EventHandler eventHandler = EventManager.getHandler(c);
        eventHandler.handleEvent(c, transport);
        EventHandler eventHandler2 = eventHandler;
        synchronized (eventHandler2) {
            eventHandler.notifyAll();
        }
    }

    public static Object getLockObject(char c) {
        return EventManager.getHandler(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForEvent(char c) throws InterruptedException {
        EventHandler eventHandler;
        EventHandler eventHandler2 = eventHandler = EventManager.getHandler(c);
        synchronized (eventHandler2) {
            eventHandler.wait();
        }
    }
}

