/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import oracle.jdevimpl.jvmti.common.Transport;
import oracle.jdevimpl.profiler.jvmti.AgentState;
import oracle.jdevimpl.profiler.jvmti.CapabilitiesImpl;
import oracle.jdevimpl.profiler.jvmti.EventHandler;
import oracle.jdevimpl.profiler.jvmti.EventManager;
import oracle.jdevimpl.profiler.jvmti.SessionImpl;

public class LowLevelEventHandler
implements EventHandler {
    private SessionImpl session;

    LowLevelEventHandler(SessionImpl sessionImpl) {
        this.session = sessionImpl;
        EventManager.addEventHandler('\u0000', this);
        EventManager.addEventHandler('\u0001', this);
        EventManager.addEventHandler('\u0002', this);
        EventManager.addEventHandler('\u0003', this);
    }

    public void handleEvent(char c, Transport transport) {
        switch (c) {
            case '\u0000': {
                this.handleAgentState(transport);
                break;
            }
            case '\u0001': {
                this.handleDefineClass(transport);
                break;
            }
            case '\u0002': {
                this.handleDefineObject(transport);
                break;
            }
            case '\u0003': {
                this.handleDefineThread(transport);
            }
        }
    }

    private void handleAgentState(Transport transport) {
        try {
            AgentState agentState = this.session.getAgentState();
            agentState.setAvailableCapabilities(new CapabilitiesImpl(transport.receiveString(), "ac[", "]"));
            agentState.setRequestedCapabilities(new CapabilitiesImpl(transport.receiveString(), "rc[", "]"));
            agentState.setEnabledCapabilities(new CapabilitiesImpl(transport.receiveString(), "ec[", "]"));
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    private void handleDefineClass(Transport transport) {
        try {
            int n = transport.receiveInt();
            String string = transport.receiveString();
            this.session.getModel().getClasses().defineClass(n, string);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    private void handleDefineObject(Transport transport) {
        try {
            int n = transport.receiveInt();
            int n2 = transport.receiveInt();
            this.session.getModel().getObjects().defineObject(n, n2);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }

    private void handleDefineThread(Transport transport) {
        try {
            int n = transport.receiveInt();
            int n2 = transport.receiveInt();
            String string = transport.receiveString();
            this.session.getModel().getThreads().defineThread(n, n2, string);
        }
        catch (IOException iOException) {
            this.session.transportIOException(iOException);
        }
    }
}

