/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import oracle.jdevimpl.profiler.jvmti.CapabilitiesImpl;
import oracle.jdevimpl.profiler.jvmti.ClassRefImpl;
import oracle.jdevimpl.profiler.jvmti.EventManager;
import oracle.jdevimpl.profiler.jvmti.ObjectRefImpl;
import oracle.jdevimpl.profiler.jvmti.SessionImpl;
import oracle.jdevimpl.profiler.jvmti.ThreadRefImpl;
import oracle.jdevimpl.profiler.support.Capabilities;
import oracle.jdevimpl.profiler.support.CapabilityNotEnabled;
import oracle.jdevimpl.profiler.support.ClassRef;
import oracle.jdevimpl.profiler.support.EventItemCollector;
import oracle.jdevimpl.profiler.support.MemoryItemCollector;
import oracle.jdevimpl.profiler.support.ObjectRef;
import oracle.jdevimpl.profiler.support.Profilee;
import oracle.jdevimpl.profiler.support.SessionException;
import oracle.jdevimpl.profiler.support.ThreadRef;
import oracle.jdevimpl.profiler.support.TimeItemCollector;
import oracle.jdevimpl.profiler.support.VM;

public class ProfileeImpl
implements Profilee {
    private SessionImpl session;
    private int gotCapabilities;
    private static CapabilitiesImpl typicalCapabilities = new CapabilitiesImpl();
    private CapabilitiesImpl requestedCapabilities;
    private CapabilitiesImpl enabledCapabilities;
    private CapabilitiesImpl availableCapabilities;

    void $init$() {
        this.gotCapabilities = 0;
        this.requestedCapabilities = new CapabilitiesImpl();
        this.enabledCapabilities = new CapabilitiesImpl();
    }

    static {
        typicalCapabilities.setProfileTime(true);
        typicalCapabilities.setReportCallStack(true);
        typicalCapabilities.setReportElapsedTime(true);
        typicalCapabilities.setReportUserTime(true);
    }

    ProfileeImpl(SessionImpl sessionImpl) {
        this.$init$();
        this.session = sessionImpl;
    }

    public VM getVM() {
        return null;
    }

    public Capabilities getTypicalCapabilities() {
        return new CapabilitiesImpl(typicalCapabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCapabilities() {
        if (this.gotCapabilities != this.session.getState()) {
            Object object = EventManager.getLockObject('\u0001');
            synchronized (object) {
                try {
                    this.session.getCommands().getCapabilities();
                    EventManager.waitForEvent('\u0001');
                }
                catch (InterruptedException interruptedException) {
                    throw new SessionException("thread interrupted", interruptedException);
                }
            }
        }
        this.gotCapabilities = this.session.getState();
    }

    public Capabilities getAvailableCapabilities() {
        this.requireConfigureConnected();
        this.waitForCapabilities();
        return new CapabilitiesImpl(this.session.getAgentState().getAvailableCapabilities());
    }

    public void requestCapabilities(Capabilities capabilities) {
        this.requireConfigure();
        this.gotCapabilities = 0;
        this.session.getCommands().requestCapabilities((CapabilitiesImpl)capabilities);
    }

    public Capabilities getEnabledCapabilities() {
        this.requireConfigureConnected();
        this.waitForCapabilities();
        return new CapabilitiesImpl(this.session.getAgentState().getEnabledCapabilities());
    }

    public void setTimeSampleRate(long l) {
        this.requireConfigureConnected();
        this.session.getCommands().setSampleInterval(l);
    }

    public void setMaxCallStackDepth(int n) {
        this.requireConfigureConnected();
    }

    public void startCollectingTime() {
        this.requireConfigureConnected();
        this.requireTime();
    }

    public void stopCollectingTime() {
        this.requireConfigureConnected();
        this.requireTime();
    }

    public void startCollectingMemory() {
        this.requireConfigureConnected();
        this.requireMemory();
    }

    public void stopCollectingMemory() {
        this.requireConfigureConnected();
        this.requireMemory();
    }

    public void startCollectingEvents() {
        this.requireConfigureConnected();
        this.requireEvents();
    }

    public void stopCollectingEvents() {
        this.requireConfigureConnected();
        this.requireEvents();
    }

    public void reportTime(TimeItemCollector timeItemCollector, int n) {
        this.requireConnected();
        this.requireTime();
    }

    public void reportMemory(MemoryItemCollector memoryItemCollector, int n) {
        this.requireConnected();
        this.requireMemory();
    }

    public void reportEvents(EventItemCollector eventItemCollector, int n) {
        this.requireConnected();
        this.requireEvents();
    }

    public void setStackFilter(String string) {
        this.requireConfigureConnected();
        this.requireAtLeastOne();
    }

    public void setMemoryFilter(String string) {
        this.requireConfigureConnected();
        this.requireMemory();
    }

    public void setEventFilter(String string) {
        this.requireConfigureConnected();
        this.requireEvents();
    }

    private void requireTime() {
        if (!this.getEnabledCapabilities().canProfileTime()) {
            throw new CapabilityNotEnabled("canProfileTime");
        }
    }

    private void requireMemory() {
        if (!this.getEnabledCapabilities().canProfileMemory()) {
            throw new CapabilityNotEnabled("canProfileMemory");
        }
    }

    private void requireEvents() {
        if (!this.getEnabledCapabilities().canProfileEvents()) {
            throw new CapabilityNotEnabled("canProfileEvents");
        }
    }

    private void requireAtLeastOne() {
        Capabilities capabilities = this.getEnabledCapabilities();
        if (!(capabilities.canProfileEvents() || capabilities.canProfileMemory() || capabilities.canProfileTime())) {
            throw new CapabilityNotEnabled("canProfileEvents|canProfileMemory|canProfileTime");
        }
    }

    private void requireConfigureConnected() {
        if (this.session.getState() != 1 && this.session.getState() != 2) {
            this.session.sessionStateException("CONFIGURE, CONNECTED");
        }
    }

    private void requireConnected() {
        if (this.session.getState() != 2) {
            this.session.sessionStateException("CONNECTED");
        }
    }

    private void requireConfigure() {
        if (this.session.getState() != 1) {
            this.session.sessionStateException("CONFIGURE");
        }
    }

    public ObjectRef newFlyweightObjectRef() {
        return new ObjectRefImpl(this.session.getModel());
    }

    public ClassRef newFlyweightClassRef() {
        return new ClassRefImpl(this.session.getModel());
    }

    public ThreadRef newFlyweightThreadRef() {
        return new ThreadRefImpl(this.session.getModel());
    }
}

