/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import oracle.jdevimpl.jvmti.common.Transport;
import oracle.jdevimpl.profiler.jvmti.AgentState;
import oracle.jdevimpl.profiler.jvmti.Commands;
import oracle.jdevimpl.profiler.jvmti.EventLoop;
import oracle.jdevimpl.profiler.jvmti.Model;
import oracle.jdevimpl.profiler.jvmti.ProfileeImpl;
import oracle.jdevimpl.profiler.support.Profilee;
import oracle.jdevimpl.profiler.support.Session;
import oracle.jdevimpl.profiler.support.SessionException;
import oracle.jdevimpl.profiler.support.SessionStateException;

public class SessionImpl
implements Session {
    private int state;
    private Profilee profilee;
    private Transport transport;
    private AgentState agentState;
    private Commands commands;
    private Model model;
    private static final int DEFAULT_PORT = 4000;
    private static final String CONFIGURE_HANDSHAKE = "configure";
    private static final String CONNECT_HANDSHAKE = "connect";
    private static final int VERSION = 1;
    private String[] readableStates;

    void $init$() {
        this.readableStates = new String[]{"INITIAL", "CONFIGURE", "CONNECTED", "DISCONNECTED", "TERMINATED"};
    }

    public SessionImpl() {
        this.$init$();
        this.state = 0;
        this.agentState = new AgentState();
        this.commands = new Commands(this);
        this.model = new Model();
    }

    public Model getModel() {
        return this.model;
    }

    public int getState() {
        return this.state;
    }

    Transport getTransport() {
        if (this.transport == null) {
            this.transport = new Transport();
        }
        return this.transport;
    }

    Commands getCommands() {
        return this.commands;
    }

    AgentState getAgentState() {
        return this.agentState;
    }

    private int getPort() {
        return 4000;
    }

    void sessionStateException(String string) throws SessionStateException {
        throw new SessionStateException(this.readableStates[this.state] + " expecting " + string);
    }

    public void configure() throws SessionException {
        if (this.state != 0) {
            this.sessionStateException("INITIAL");
        }
        if (!this.transport.makeSocketConnection(this.getPort(), CONFIGURE_HANDSHAKE, 1)) {
            throw new SessionException("Unable to make configure connection");
        }
        this.agentState = new AgentState();
        this.commands = new Commands(this);
        EventLoop.startEventLoop(this);
    }

    public void start() throws SessionException {
        if (this.state != 1) {
            this.sessionStateException("CONFIGURE");
        }
    }

    public void disconnect() throws SessionException {
        if (this.state != 1 && this.state != 2) {
            this.sessionStateException("CONFIGURE, CONNECTED");
        }
    }

    public void connect() throws SessionException {
        if (this.state != 0 && this.state != 3) {
            this.sessionStateException("INITIAL, DISCONNECTED");
        }
        if (!this.transport.makeSocketConnection(this.getPort(), CONNECT_HANDSHAKE, 1)) {
            throw new SessionException("Unable to make connect connection");
        }
    }

    public void terminate() throws SessionException {
        if (this.state == 1 || this.state == 2) {
            this.transport.closeSocketConnection();
        } else if (this.state != 3) {
            this.sessionStateException("CONFIGURE, CONNECTED, DISCONNECTED");
        }
        this.profilee = null;
        this.transport = null;
        this.agentState = null;
    }

    public void transportIOException(IOException iOException) throws SessionException {
        throw new SessionException("connection failed", iOException);
    }

    public void abnormalTerminate(Throwable throwable) {
    }

    public Profilee getProfilee() throws SessionStateException {
        if (this.state != 1 && this.state != 2) {
            this.sessionStateException("CONFIGURE, CONNECTED");
        }
        if (this.profilee == null) {
            this.profilee = new ProfileeImpl(this);
        }
        return this.profilee;
    }
}

