/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import oracle.ide.controls.AWTColorComponent;
import oracle.ide.controls.JavaColorChooserPane;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyState;

public final class ColorEditor
implements PropertyChangeListener,
CmtPropertyEditor {
    private String propName;
    private PropertyChangeListener listener;
    private Color color;
    private JavaColorChooserPane editor;

    public void setPropertyState(CmtPropertyState cmtPropertyState) {
        this.propName = cmtPropertyState != null ? cmtPropertyState.getProperty().getName() : null;
    }

    public Color getColorValue() {
        return this.color;
    }

    public void setColorValue(Color color) {
        this.color = color;
        this.fire();
        if (this.editor != null) {
            this.editor.setCurrentColor(color);
        }
    }

    public void setValue(Object object) {
        if (object == null) {
            this.setColorValue(Color.black);
        } else {
            this.setColorValue((Color)object);
        }
    }

    public Object getValue() {
        return this.getColorValue();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x + 3, rectangle.y + 3, 13, rectangle.height - 7);
        graphics.setColor(this.color);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 4, 12, rectangle.height - 8);
        graphics.setColor(color);
        String string = this.getText();
        if (string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            int n = fontMetrics.getAscent() - fontMetrics.getDescent();
            int n2 = rectangle.y + rectangle.height - (rectangle.height - n) / 2;
            SwingUtils.drawString((Graphics)graphics, (String)string, (int)(rectangle.x + 21), (int)n2);
        }
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
    }

    protected String getText() {
        Color color = this.getColorValue();
        if (color == null) {
            return null;
        }
        String string = AWTColorComponent.getText((Color)color);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(color.getRed());
            stringBuffer.append(", ");
            stringBuffer.append(color.getGreen());
            stringBuffer.append(", ");
            stringBuffer.append(color.getBlue());
            return stringBuffer.toString();
        }
        return string;
    }

    public String getJavaInitializationString() {
        String string = AWTColorComponent.getText((Color)this.getColorValue());
        if (string != null) {
            return "java.awt." + string;
        }
        string = "new java.awt.Color(" + this.color.getRed() + ", " + this.color.getGreen() + ", " + this.color.getBlue() + ")";
        return string;
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new JavaColorChooserPane(this.getColorValue());
            this.editor.addPropertyChangeListener((PropertyChangeListener)this);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.editor, "f1_guipropedcolor_html");
        }
        return this.editor;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedColor".equals(propertyChangeEvent.getPropertyName())) {
            this.color = (Color)propertyChangeEvent.getNewValue();
            this.fire();
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }

    void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, this.propName, null, this.getValue()));
        }
    }
}

