/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;

public final class DimensionEditor
implements PropertyEditor {
    private PropertyChangeListener listener;
    private Dimension value;

    public void setValue(Object object) {
        this.value = (Dimension)object;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return String.valueOf(this.value.width) + ", " + this.value.height;
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return null;
        }
        return "new java.awt.Dimension(" + this.value.width + ", " + this.value.height + ")";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        if (n != 2) {
            throw new IllegalArgumentException();
        }
        try {
            this.value = new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, null, null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }
}

