/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import oracle.jdevimpl.propertyeditor.ActualFontEditor;

public final class FontEditor
implements PropertyEditor {
    PropertyChangeListener listener;
    Font font;
    ActualFontEditor editor;

    public Font getFontValue() {
        return this.font;
    }

    public void setFontValue(Font font) {
        if (this.editor != null) {
            this.editor.setFontValue(font);
        } else {
            this.font = font;
            this.fire();
        }
    }

    public void setValue(Object object) {
        this.setFontValue((Font)object);
    }

    public Object getValue() {
        return this.getFontValue();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getAsText() {
        Font font = this.getFontValue();
        return font != null ? "\"" + font.getName() + "\", " + this.getStyleText() + ", " + font.getSize() : "";
    }

    public String getJavaInitializationString() {
        return "new java.awt.Font(" + this.getAsText() + ")";
    }

    private String getStyleText() {
        Font font = this.getFontValue();
        return String.valueOf(font.getStyle());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\"");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        if (n != 3) {
            throw new IllegalArgumentException();
        }
        try {
            this.setValue(new Font(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ActualFontEditor(this);
        }
        return this.editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }

    void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "FontEditor???", null, this.getValue()));
        }
    }
}

