/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;

public final class InsetsEditor
implements PropertyEditor {
    private PropertyChangeListener listener;
    private Insets value;

    public void setValue(Object object) {
        this.value = (Insets)object;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return String.valueOf(this.value.top) + ", " + this.value.left + ", " + this.value.bottom + ", " + this.value.right;
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return null;
        }
        return "new java.awt.Insets(" + this.value.top + ", " + this.value.left + ", " + this.value.bottom + ", " + this.value.right + ")";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        if (n != 4) {
            throw new IllegalArgumentException();
        }
        try {
            this.setValue(new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "InsetsEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }
}

