/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class IntegerTagEditor
implements PropertyEditor {
    private int[] values;
    private String[] resourceStrings;
    private String[] sourceCodeStrings;
    private PropertyChangeListener listener;
    private Object value;

    public IntegerTagEditor(int[] nArray, String[] stringArray, String[] stringArray2) {
        if (nArray == null) {
            nArray = new int[stringArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
        }
        this.values = nArray;
        this.resourceStrings = stringArray;
        this.sourceCodeStrings = stringArray2 != null ? stringArray2 : stringArray;
    }

    public IntegerTagEditor(int[] nArray, String[] stringArray, String[] stringArray2, boolean bl) {
        this(nArray, stringArray, stringArray2);
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = n + 1;
                while (n2 < stringArray.length) {
                    int n3 = stringArray[n].compareTo(stringArray[n2]);
                    if (n3 > 0) {
                        String string = stringArray[n];
                        stringArray[n] = stringArray[n2];
                        stringArray[n2] = string;
                        string = stringArray2[n];
                        stringArray2[n] = stringArray2[n2];
                        stringArray2[n2] = string;
                        int n4 = nArray[n];
                        nArray[n] = nArray[n2];
                        nArray[n2] = n4;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public final void setValue(Object object) {
        this.value = object;
        this.fire();
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isPaintable() {
        return false;
    }

    public final void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    private String getAsText(boolean bl) {
        int n = this.value == null || !(this.value instanceof Integer) ? this.values[0] : (Integer)this.value;
        int n2 = 0;
        while (n2 < this.values.length) {
            if (this.values[n2] == n) break;
            ++n2;
        }
        if (n2 >= this.values.length) {
            return "";
        }
        return bl ? this.sourceCodeStrings[n2] : this.resourceStrings[n2];
    }

    public final String getAsText() {
        return this.getAsText(false);
    }

    public final String getJavaInitializationString() {
        return this.getAsText(true);
    }

    public final void setAsText(String string) throws IllegalArgumentException {
        int n = 0;
        if (string != null) {
            while (n < this.resourceStrings.length) {
                if (string.equals(this.resourceStrings[n])) break;
                ++n;
            }
            if (n >= this.resourceStrings.length) {
                throw new IllegalArgumentException();
            }
            this.value = new Integer(this.values[n]);
            this.fire();
        }
    }

    public final String[] getTags() {
        return this.resourceStrings;
    }

    public final Component getCustomEditor() {
        return null;
    }

    public final boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "???", null, this.value));
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }
}

