/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.jdevimpl.propertyeditor.Res;

public final class LocaleEditor
implements PropertyEditor {
    static String[] resourceStrings;
    static boolean initialized;
    private boolean defaultSelected;
    private String[][] locales;
    private PropertyChangeListener listener;
    private Locale value;

    static {
        initialized = false;
    }

    void $init$() {
        this.defaultSelected = false;
        this.locales = new String[][]{{"ar", "Arabic"}, {"be", "Byelorussian"}, {"bg", "Bulgarian"}, {"ca", "Catalan"}, {"cs", "Czech"}, {"da", "Danish"}, {"de", "German"}, {"de_AT", "German (Austria)"}, {"de_CH", "German (Switzerland)"}, {"el", "Greek"}, {"en", "English"}, {"en_AU", "English (Australia)"}, {"en_CA", "English (Canada)"}, {"en_GB", "English (United Kingdom)"}, {"en_IE", "English (Ireland)"}, {"en_NZ", "English (New Zealand)"}, {"en_ZA", "English (South Africa)"}, {"es", "Spanish"}, {"es_AR", "Spanish (Argentina)"}, {"es_BO", "Spanish (Bolivia)"}, {"es_CL", "Spanish (Chile)"}, {"es_CO", "Spanish (Colombia)"}, {"es_CR", "Spanish (Costa Rica)"}, {"es_DO", "Spanish (Dominican Republic)"}, {"es_EC", "Spanish (Ecuador)"}, {"es_GT", "Spanish (Guatemala"}, {"es_HN", "Spanish (Honduras)"}, {"es_MX", "Spanish (Mexico)"}, {"es_NI", "Spanish (Nicaragua"}, {"es_PA", "Spanish (Panama)"}, {"es_PE", "Spanish (Peru)"}, {"es_PR", "Spanish (Puerto Rico)"}, {"es_PY", "Spanish (Paraguay)"}, {"es_SV", "Spanish (El Salvador)"}, {"es_UY", "Spanish (Uruguay)"}, {"es_VE", "Spanish (Venezuela)"}, {"et", "Estonian"}, {"fi", "Finnish"}, {"fr", "French"}, {"fr_BE", "French (Belgium)"}, {"fr_CA", "French (Canada)"}, {"fr_CH", "French (Switzerland)"}, {"hr", "Croatian"}, {"hu", "Hungarian"}, {"is", "Icelandic"}, {"it", "Italian"}, {"it_CH", "Italian (Switzerland)"}, {"iw", "Hebrew"}, {"ja", "Japanese"}, {"ko", "Korean "}, {"lt", "Lithuanian"}, {"lv", "Latvian (Lettish)"}, {"mk", "Macedonian"}, {"nl", "Dutch"}, {"nl_BE", "Dutch (Belgium)"}, {"no", "Norwegian"}, {"no_NO_NY", "Norwegian (Norway, NY)"}, {"pl", "Polish"}, {"pt", "Portuguese"}, {"pt_BR", "Portuguese (Brazil)"}, {"ro", "Romanian"}, {"ru", "Russian"}, {"sh", "Serbo-Croatian"}, {"sk", "Slovak"}, {"sl", "Slovenian"}, {"sq", "Albanian"}, {"sr", "Serbian"}, {"sv", "Swedish"}, {"th", "Thai"}, {"tr", "Turkish"}, {"uk", "Ukrainian"}, {"zh", "Chinese"}, {"zh_TW", "Chinese (Taiwan)"}};
    }

    public LocaleEditor() {
        this.$init$();
        if (!initialized) {
            initialized = true;
            resourceStrings = new String[this.locales.length + 1];
            LocaleEditor.resourceStrings[0] = Res.getString(62);
            String string = Locale.getDefault().toString();
            int n = 0;
            while (n < this.locales.length) {
                LocaleEditor.resourceStrings[n + 1] = string.equals(this.locales[n][0]) ? LocaleEditor.getLocaleDisplayName(Locale.getDefault()) : this.locales[n][1] + " [" + this.locales[n][0] + "]";
                ++n;
            }
        }
    }

    private static String getLocaleDisplayName0(Locale locale, Locale locale2) {
        String string;
        StringBuffer stringBuffer = new StringBuffer(locale.getDisplayLanguage(locale2));
        String string2 = locale.getCountry().length() != 0 ? locale.getDisplayCountry(locale2) : "";
        String string3 = string = locale.getVariant().length() != 0 ? locale.getDisplayVariant(locale2) : "";
        if (string2.length() != 0 || string.length() != 0) {
            stringBuffer.append(" (");
            stringBuffer.append(string2);
            if (string2.length() != 0 && string.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static String getLocaleDisplayName(Locale locale) {
        String string = locale.getLanguage().equals(Locale.getDefault().getLanguage()) ? LocaleEditor.getLocaleDisplayName0(locale, locale) : LocaleEditor.getLocaleDisplayName0(locale, Locale.ENGLISH);
        return string + " [" + locale.toString() + "]".toString();
    }

    private static String getConstructorString(Locale locale) {
        return "new java.util.Locale(\"" + locale.getLanguage() + "\", \"" + locale.getCountry() + "\", \"" + locale.getVariant() + "\")";
    }

    public void setValue(Object object) {
        this.defaultSelected = object == null || object == Locale.getDefault();
        this.value = (Locale)object;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        if (this.defaultSelected) {
            return Res.getString(62);
        }
        return LocaleEditor.getLocaleDisplayName(this.value);
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return null;
        }
        if (this.defaultSelected) {
            return "java.util.Locale.getDefault()";
        }
        return LocaleEditor.getConstructorString(this.value);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string != null) {
            int n = 0;
            while (n < resourceStrings.length) {
                if (string.equals(resourceStrings[n])) {
                    if (n == 0) {
                        this.defaultSelected = true;
                        this.value = Locale.getDefault();
                    } else {
                        this.value = LocaleEditor.getLocale(this.locales[n - 1][0]);
                        this.defaultSelected = false;
                    }
                    this.fire();
                    return;
                }
                ++n;
            }
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return resourceStrings;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "LocaleEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }

    static Locale getLocale(String string) {
        if (string == null || string.length() == 0) {
            return Locale.getDefault();
        }
        String[] stringArray = new String[3];
        stringArray[2] = "";
        stringArray[1] = "";
        stringArray[0] = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        int n = 0;
        while (n < stringArray.length && stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }
}

