/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import oracle.ide.util.FastStringBuffer;

public class StringEditor
implements PropertyEditor {
    private static String[] logicalChars = new String[]{"<TAB>", "<CR>", "<NL>", "<FF>", "<<>", "<LF>"};
    private static char[] physicalChars = new char[]{'\t', '\r', '\n', '\f', '<', '\n'};
    private PropertyChangeListener listener;
    protected String value;

    public final void setValue(Object object) {
        this.value = (String)object;
        this.fire();
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isPaintable() {
        return false;
    }

    public final void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public final String getAsText() {
        String string = this.value == null ? null : StringEditor.rawTextToDisplay(this.value);
        return string;
    }

    public String getJavaInitializationString() {
        String string = StringEditor.textToSource(this.value);
        return string;
    }

    public static final String textToSource(String string) {
        return FastStringBuffer.textToSource((String)string, (boolean)false).toString();
    }

    public final void setAsText(String string) throws IllegalArgumentException {
        this.value = string == null ? null : StringEditor.displayTextToRaw(string);
    }

    public final String[] getTags() {
        return null;
    }

    public final Component getCustomEditor() {
        return null;
    }

    public final boolean supportsCustomEditor() {
        return false;
    }

    public static final boolean inCurrentCodePage(char c) {
        String string = String.valueOf(c);
        byte[] byArray = string.getBytes();
        String string2 = new String(byArray);
        return string.charAt(0) == string2.charAt(0);
    }

    public static final String rawTextToDisplay(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer();
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000') {
            int n = 0;
            while (n < physicalChars.length) {
                if (c == physicalChars[n]) {
                    fastStringBuffer2.append(logicalChars[n]);
                    break;
                }
                ++n;
            }
            if (n >= physicalChars.length) {
                if (c > '\u001f' && StringEditor.inCurrentCodePage(c)) {
                    fastStringBuffer2.append(c);
                } else {
                    fastStringBuffer2.append("<" + Integer.toString(c, 16) + ">");
                }
            }
            c = fastStringBuffer.nextChar();
        }
        return fastStringBuffer2.toString();
    }

    public static final String displayTextToRaw(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer();
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000') {
            if (c != '<') {
                fastStringBuffer2.append(c);
            } else {
                int n = fastStringBuffer.getOffset();
                FastStringBuffer fastStringBuffer3 = new FastStringBuffer();
                c = fastStringBuffer.nextChar();
                while (c != '\u0000') {
                    if (c == '>') {
                        String string2 = "<" + fastStringBuffer3.toString() + ">";
                        int n2 = 0;
                        while (n2 < logicalChars.length) {
                            if (string2.equalsIgnoreCase(logicalChars[n2])) {
                                fastStringBuffer2.append(physicalChars[n2]);
                                break;
                            }
                            ++n2;
                        }
                        if (n2 < logicalChars.length) break;
                        String string3 = fastStringBuffer3.toString();
                        try {
                            fastStringBuffer2.append((char)Integer.valueOf(string3, 16).intValue());
                        }
                        catch (Exception exception) {
                            fastStringBuffer2.append(string2);
                        }
                        break;
                    }
                    fastStringBuffer3.append(c);
                    c = fastStringBuffer.nextChar();
                }
                if (c == '\u0000') {
                    fastStringBuffer2.append('<');
                    fastStringBuffer.setOffset(n);
                }
            }
            c = fastStringBuffer.nextChar();
        }
        return fastStringBuffer2.toString();
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, null, null, this.value));
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }
}

