/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.AddinManager;
import oracle.ide.docking.DockableView;
import oracle.ide.inspector.Extension;
import oracle.ide.inspector.InspectorManager;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtExtension;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.inspector.extension.ActionMapExtension;
import oracle.jdevimpl.inspector.extension.BorderExtension;
import oracle.jdevimpl.inspector.extension.BoundedRangeModelExtension;
import oracle.jdevimpl.inspector.extension.ButtonModelExtension;
import oracle.jdevimpl.inspector.extension.CaretExtension;
import oracle.jdevimpl.inspector.extension.ComboBoxModelExtension;
import oracle.jdevimpl.inspector.extension.DocumentExtension;
import oracle.jdevimpl.inspector.extension.EditorKitExtension;
import oracle.jdevimpl.inspector.extension.JTableHeaderExtension;
import oracle.jdevimpl.inspector.extension.KeyStrokeExtension;
import oracle.jdevimpl.inspector.extension.ListModelExtension;
import oracle.jdevimpl.inspector.extension.ListSelectionModelExtension;
import oracle.jdevimpl.inspector.extension.TableColumnModelExtension;
import oracle.jdevimpl.inspector.extension.TableModelExtension;
import oracle.jdevimpl.inspector.extension.TreeSelectionModelExtension;
import oracle.jdevimpl.propertyeditor.Res;
import oracle.jdevimpl.propertyeditor.ResetsOnNull;

public final class SubcomponentChoiceEditor
implements PropertyChangeListener,
ResetsOnNull,
CmtPropertyEditor {
    public static final String EXTENSION_PREFIX = "jdeveloper.editorextension.";
    private static HashMap typeToExtensions = new HashMap();
    private PropertyChangeListener listener;
    private Object value;
    private CmtPropertyState ps;
    private Extension extension;
    private String lastTag;
    private String secondLastTag;

    static {
        typeToExtensions.put("javax.swing.ActionMap", new Extension[]{new ActionMapExtension()});
        typeToExtensions.put("javax.swing.border.Border", new Extension[]{new BorderExtension()});
        typeToExtensions.put("javax.swing.BoundedRangeModel", new Extension[]{new BoundedRangeModelExtension()});
        typeToExtensions.put("javax.swing.ButtonModel", new Extension[]{new ButtonModelExtension()});
        typeToExtensions.put("javax.swing.text.Caret", new Extension[]{new CaretExtension()});
        typeToExtensions.put("javax.swing.ComboBoxModel", new Extension[]{new ComboBoxModelExtension()});
        typeToExtensions.put("javax.swing.text.Document", new Extension[]{new DocumentExtension()});
        typeToExtensions.put("javax.swing.text.EditorKit", new Extension[]{new EditorKitExtension()});
        typeToExtensions.put("javax.swing.table.JTableHeader", new Extension[]{new JTableHeaderExtension()});
        typeToExtensions.put("javax.swing.KeyStroke", new Extension[]{new KeyStrokeExtension()});
        typeToExtensions.put("javax.swing.ListModel", new Extension[]{new ListModelExtension()});
        typeToExtensions.put("javax.swing.ListSelectionModel", new Extension[]{new ListSelectionModelExtension()});
        typeToExtensions.put("javax.swing.table.TableColumnModel", new Extension[]{new TableColumnModelExtension()});
        typeToExtensions.put("javax.swing.table.TableModel", new Extension[]{new TableModelExtension()});
        typeToExtensions.put("javax.swing.tree.TreeSelectionModel", new Extension[]{new TreeSelectionModelExtension()});
        Properties properties = AddinManager.getAddinManager().getProductProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(EXTENSION_PREFIX)) continue;
            String string2 = string.substring(EXTENSION_PREFIX.length());
            String string3 = properties.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                try {
                    Extension[] extensionArray;
                    Class<?> clazz = Class.forName(string4);
                    Extension extension = (Extension)clazz.newInstance();
                    Extension[] extensionArray2 = (Extension[])typeToExtensions.get(string2);
                    if (extensionArray2 != null) {
                        extensionArray = new Extension[extensionArray2.length + 1];
                        System.arraycopy(extensionArray2, 0, extensionArray, 0, extensionArray2.length);
                    } else {
                        extensionArray = new Extension[1];
                    }
                    extensionArray[extensionArray.length - 1] = extension;
                    typeToExtensions.put(string2, extensionArray);
                }
                catch (Exception exception) {
                    System.err.println("Extension for " + string4 + " could not be registered: " + string3);
                }
            }
        }
    }

    void $init$() {
        this.extension = null;
        this.lastTag = null;
        this.secondLastTag = null;
    }

    public void setPropertyState(CmtPropertyState cmtPropertyState) {
        this.ps = cmtPropertyState;
        if (this.extension instanceof CmtExtension) {
            ((CmtExtension)this.extension).setPropertyState(cmtPropertyState);
        }
    }

    public void setValue(Object object) {
        this.value = object;
        if (this.extension != null) {
            this.extension.removePropertyChangeListener((PropertyChangeListener)this);
            this.extension = null;
        }
        this.secondLastTag = this.lastTag;
        this.lastTag = this.getAsText();
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    private String getAsText(boolean bl) {
        Extension extension;
        if (this.value != null && this.ps != null) {
            CmtComponent cmtComponent = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] cmtSubcomponentArray = cmtComponent.getSubcomponents();
            int n = 0;
            while (n < cmtSubcomponentArray.length) {
                if (cmtSubcomponentArray[n].getLiveInstance() == this.value) {
                    return cmtSubcomponentArray[n].getName();
                }
                ++n;
            }
        }
        if ((extension = this.getExtension()) != null) {
            return bl ? extension.getJavaInitializationString() : extension.getDisplayString();
        }
        return bl && this.value == null ? "null" : Res.getString(197);
    }

    public String getAsText() {
        return this.getAsText(false);
    }

    public String getJavaInitializationString() {
        this.lastTag = this.secondLastTag;
        return this.getAsText(true);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.equals(Res.getString(197))) {
                this.value = null;
                return;
            }
            if (string.equals(this.lastTag)) {
                return;
            }
            if (this.ps != null) {
                Extension[] extensionArray;
                CmtComponent cmtComponent = this.ps.getSubcomponent().getOuterComponent();
                CmtSubcomponent[] cmtSubcomponentArray = cmtComponent.getSubcomponents();
                int n = 0;
                while (n < cmtSubcomponentArray.length) {
                    if (cmtSubcomponentArray[n].getName().equals(string)) {
                        this.value = cmtSubcomponentArray[n].getLiveInstance();
                        this.lastTag = string;
                        this.firePropertyChange();
                        return;
                    }
                    ++n;
                }
                JavaType javaType = this.ps.getProperty().getType();
                Extension[] extensionArray2 = extensionArray = javaType != null ? (Extension[])typeToExtensions.get(javaType.getQualifiedName()) : null;
                if (extensionArray != null) {
                    int n2 = 0;
                    while (n2 < extensionArray.length) {
                        Extension extension = extensionArray[n2];
                        if (extension instanceof CmtExtension) {
                            ((CmtExtension)extension).setPropertyState(this.ps);
                        }
                        String[] stringArray = extension.getTags();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (string.equals(stringArray[n3])) {
                                extension.setSelectedTag(stringArray[n3]);
                                if (extension.supportsCustomEditor() && !this.showCustomEditor(extension)) {
                                    this.lastTag = string;
                                    return;
                                }
                                this.value = extension.getValue();
                                this.lastTag = string;
                                this.firePropertyChange();
                                return;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
            }
        }
        throw new IllegalArgumentException(string);
    }

    public String[] getTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Res.getString(197));
        if (this.ps != null) {
            Extension[] extensionArray;
            String string;
            CmtComponent cmtComponent = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] cmtSubcomponentArray = cmtComponent.getSubcomponents();
            JavaType javaType = this.ps.getProperty().getType();
            if (javaType != null) {
                int n = 0;
                while (n < cmtSubcomponentArray.length) {
                    JavaClass javaClass;
                    if (this.ps.getSubcomponent() != cmtSubcomponentArray[n] && (javaClass = cmtSubcomponentArray[n].getDeclaredClass()) != null && javaType.isAssignableFrom((JavaType)javaClass)) {
                        arrayList.add(cmtSubcomponentArray[n].getName());
                    }
                    ++n;
                }
            }
            if (!arrayList.contains(string = this.getAsText())) {
                arrayList.add(string);
            }
            if (javaType != null && (extensionArray = (Extension[])typeToExtensions.get(javaType.getQualifiedName())) != null) {
                int n = 0;
                while (n < extensionArray.length) {
                    Extension extension = extensionArray[n];
                    if (extension instanceof CmtExtension) {
                        ((CmtExtension)extension).setPropertyState(this.ps);
                    }
                    String[] stringArray = extension.getTags();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        arrayList.add(stringArray[n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public Component getCustomEditor() {
        Extension extension = this.getExtension();
        return extension != null ? extension.getCustomEditor() : null;
    }

    public boolean supportsCustomEditor() {
        Extension extension = this.getExtension();
        return extension != null ? extension.supportsCustomEditor() : false;
    }

    private boolean showCustomEditor(Extension extension) {
        InspectorManager inspectorManager = InspectorManager.getInspectorManager();
        DockableView dockableView = inspectorManager.getLastView();
        JEWTDialog jEWTDialog = new JEWTDialog(WindowUtils.parentFrame((Component)dockableView.getGUI()), this.ps.getProperty().getName(), 7);
        Component component = extension.getCustomEditor();
        boolean bl = component instanceof VetoableChangeListener;
        SwingUtilities.updateComponentTreeUI(component);
        jEWTDialog.setContent(component);
        if (bl) {
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)((Object)component));
        }
        WindowUtils.centerWindow((Window)jEWTDialog, (Component)dockableView.getGUI());
        boolean bl2 = jEWTDialog.runDialog();
        if (bl) {
            jEWTDialog.removeVetoableChangeListener((VetoableChangeListener)((Object)component));
        }
        jEWTDialog.dispose();
        return bl2;
    }

    private Extension getExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.value != null && this.ps != null) {
            Extension[] extensionArray;
            CmtComponent cmtComponent = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] cmtSubcomponentArray = cmtComponent.getSubcomponents();
            int n = 0;
            while (n < cmtSubcomponentArray.length) {
                if (cmtSubcomponentArray[n].getLiveInstance() == this.value) {
                    return null;
                }
                ++n;
            }
            Class<?> clazz = this.value.getClass();
            JavaType javaType = this.ps.getProperty().getType();
            Extension[] extensionArray2 = extensionArray = javaType != null ? (Extension[])typeToExtensions.get(javaType.getQualifiedName()) : null;
            if (extensionArray != null) {
                int n2 = 0;
                while (n2 < extensionArray.length) {
                    Extension extension = extensionArray[n2];
                    Class[] classArray = extension.getImplementationClasses();
                    int n3 = 0;
                    while (n3 < classArray.length) {
                        if (clazz == classArray[n3]) {
                            this.extension = extension;
                            if (this.extension instanceof CmtExtension) {
                                ((CmtExtension)this.extension).setPropertyState(this.ps);
                            }
                            this.extension.setValue(this.value);
                            this.extension.addPropertyChangeListener((PropertyChangeListener)this);
                            return this.extension;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private void firePropertyChange() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "SubcomponentChoiceEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.value = this.getExtension().getValue();
        this.firePropertyChange();
    }

    public SubcomponentChoiceEditor() {
        this.$init$();
    }
}

