/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.java.explorer.ImportElement;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.MethodElement;
import oracle.jdevimpl.java.explorer.PackageElement;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class ElementAt {
    public static final int TYPE_JAVA_CLASS = 1;
    public static final int TYPE_JAVA_CTOR = 2;
    public static final int TYPE_JAVA_METHOD = 3;
    public static final int TYPE_JAVA_FIELD = 4;
    public static final int TYPE_JAVA_VARIABLE = 5;
    public static final int TYPE_JAVA_PACKAGE = 6;
    public static final int TYPE_JAVA_ENUM_CONSTANT = 7;
    private int _elementType;
    private SourceElement _sourceElement;
    private JavaElement _javaElement;
    private SourceElement _sourceContext;
    private static ElementAt _cachedElementAt;
    private static URL _cachedElementAtUrl;
    private static int _cachedElementAtCaretPos;
    private static boolean _cacheEnabled;

    protected ElementAt(int n, SourceElement sourceElement) {
        this._elementType = n;
        this._sourceElement = sourceElement;
    }

    protected ElementAt(JavaElement javaElement, int n) {
        this._elementType = n;
        this._javaElement = javaElement;
    }

    protected ElementAt(JavaClass javaClass) {
        this((JavaElement)javaClass, 1);
    }

    protected ElementAt(JavaMethod javaMethod) {
        this((JavaElement)javaMethod, javaMethod.isConstructor() ? 2 : 3);
    }

    protected ElementAt(JavaField javaField) {
        this((JavaElement)javaField, 4);
    }

    protected ElementAt(SourceVariable sourceVariable) {
        this(5, (SourceElement)sourceVariable);
    }

    protected ElementAt(JavaPackage javaPackage) {
        this._javaElement = javaPackage;
        this._elementType = 6;
    }

    public static void beginCache() {
        ElementAt.clearCache();
        _cacheEnabled = true;
    }

    public static void endCache() {
        _cacheEnabled = false;
        ElementAt.clearCache();
    }

    private static void clearCache() {
        _cachedElementAt = null;
        _cachedElementAtUrl = null;
    }

    public int getElementType() {
        return this._elementType;
    }

    public SourceElement getSourceElement() {
        SourceElement sourceElement = this._sourceElement != null ? this._sourceElement : this._javaElement.getSourceElement();
        return sourceElement;
    }

    public JavaElement getJavaElement() {
        return this._javaElement;
    }

    public JavaPackage getJavaPackage() {
        return (JavaPackage)this._javaElement;
    }

    private void setSourceContext(SourceElement sourceElement) {
        this._sourceContext = sourceElement;
    }

    public SourceElement getSourceContext() {
        return this._sourceContext;
    }

    public static ElementAt findElementAt(Context context) {
        ElementAt elementAt = null;
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            elementAt = ElementAt.findElementAt(context, codeEditor);
        } else if (view instanceof UIEditor) {
            elementAt = ElementAt.findElementAt(((UIEditor)view).getActiveCanvas());
        } else if (view instanceof NavigatorWindow) {
            NavigatorWindow navigatorWindow = (NavigatorWindow)view;
            elementAt = ElementAt.findElementAt(navigatorWindow, project);
        } else if (view instanceof ExplorerWindow) {
            ExplorerWindow explorerWindow = (ExplorerWindow)view;
            elementAt = ElementAt.findElementAt(explorerWindow, project);
        }
        return elementAt;
    }

    public static ElementAt findElementAt(Context context, CodeEditor codeEditor) {
        Project project = context.getProject();
        ElementAt elementAt = null;
        int n = codeEditor.getCaretPosition();
        Node node = context.getNode();
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            elementAt = ElementAt.findElementAt(textNode, project, n);
        }
        return elementAt;
    }

    public static ElementAt findElementAt(UIEditorCanvas uIEditorCanvas) {
        Element[] elementArray;
        ElementAt elementAt = null;
        Element[] elementArray2 = elementArray = uIEditorCanvas != null ? uIEditorCanvas.getSelection() : null;
        if (elementArray != null && elementArray.length == 1) {
            SourceVariable sourceVariable;
            CmtModelNode cmtModelNode = (CmtModelNode)elementArray[0];
            CmtSubcomponent cmtSubcomponent = cmtModelNode != null ? cmtModelNode.getSubcomponent() : null;
            SourceVariable sourceVariable2 = sourceVariable = cmtSubcomponent != null ? cmtSubcomponent.getVariable() : null;
            if (sourceVariable instanceof JavaField) {
                elementAt = cmtSubcomponent.getName().equals("this") ? new ElementAt(cmtSubcomponent.getOuterComponent().getType()) : new ElementAt((JavaField)sourceVariable);
            } else if (sourceVariable != null) {
                elementAt = new ElementAt(sourceVariable);
            }
        }
        return elementAt;
    }

    private static ElementAt findElementAt(NavigatorWindow navigatorWindow, Project project) {
        ElementAt elementAt = null;
        Element[] elementArray = navigatorWindow.getSelection();
        if (elementArray.length == 1) {
            Element element = elementArray[0];
            if (element instanceof RelativeDirectoryContextFolder) {
                RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
                String string = relativeDirectoryContextFolder.getRelativePath();
                if (ModelUtil.hasLength((String)string)) {
                    JavaManager javaManager = JavaManager.getJavaManager(project);
                    JavaPackage javaPackage = javaManager.getPackage(string.replace('/', '.'));
                    elementAt = new ElementAt(javaPackage);
                }
            } else if (element instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                elementAt = ElementAt.findElementAt(javaSourceNode, project);
            }
        }
        return elementAt;
    }

    private static ElementAt findElementAt(JavaSourceNode javaSourceNode, Project project) {
        SourceClass sourceClass;
        ElementAt elementAt = null;
        URL uRL = javaSourceNode.getURL();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(uRL);
        if (sourceFile != null && (sourceClass = sourceFile.getSourcePrimaryClass()) != null) {
            elementAt = new ElementAt((JavaClass)sourceClass);
        }
        return elementAt;
    }

    private static ElementAt findElementAt(ExplorerWindow explorerWindow, Project project) {
        Explorer explorer;
        ElementAt elementAt = null;
        Explorer explorer2 = explorer = explorerWindow != null ? explorerWindow.getExplorer() : null;
        if (explorer instanceof JavaExplorer) {
            Context context;
            Node node;
            CodeElement codeElement = ElementAt.getCodeElement(explorerWindow);
            if (codeElement != null && (node = (context = explorerWindow.getContext()).getNode()) instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)node;
                int n = codeElement.getStartOffset();
                elementAt = ElementAt.findElementAt((TextNode)javaSourceNode, project, n);
            }
        } else if (explorer instanceof UIEditorCanvas) {
            UIEditorCanvas uIEditorCanvas = (UIEditorCanvas)explorer;
            elementAt = ElementAt.findElementAt(uIEditorCanvas);
        }
        return elementAt;
    }

    public static CodeElement getCodeElement(ExplorerWindow explorerWindow) {
        CodeElement codeElement = null;
        Context context = explorerWindow.getContext();
        Element element = context.getElement();
        if (element instanceof ClassElement || element instanceof MethodElement || element instanceof FieldElement || element instanceof PackageElement || element instanceof ImportElement) {
            codeElement = (CodeElement)element;
        }
        return codeElement;
    }

    public static ElementAt findElementAt(TextNode textNode, Project project, int n) {
        URL uRL;
        ElementAt elementAt = null;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(uRL = textNode.getURL());
        if (sourceFile != null) {
            if (_cachedElementAtUrl == uRL && _cachedElementAtCaretPos == n) {
                elementAt = _cachedElementAt;
            } else {
                elementAt = ElementAt.findElementInSourceElement(project, (SourceElement)sourceFile, n);
                if (_cacheEnabled) {
                    _cachedElementAt = elementAt;
                    _cachedElementAtCaretPos = n;
                    _cachedElementAtUrl = uRL;
                }
            }
        }
        return elementAt;
    }

    private static ElementAt findElementInSourceElement(Project project, SourceElement sourceElement, int n) {
        ElementAt elementAt = null;
        int n2 = sourceElement.getSymbolKind();
        switch (n2) {
            case 22: {
                SourcePackage sourcePackage = (SourcePackage)sourceElement;
                String string = sourcePackage.getName();
                SourceFile sourceFile = sourcePackage.getOwningSourceFile();
                JavaProvider javaProvider = sourceFile.getProvider();
                JavaPackage javaPackage = javaProvider.getPackage(string);
                elementAt = new ElementAt(javaPackage);
                break;
            }
            case 14: {
                String string;
                SourceImport sourceImport = (SourceImport)sourceElement;
                if (sourceImport.isStatic() || !Patch.contains((SourceElement)sourceImport.getNameElement(), n) || (string = sourceImport.getName()).endsWith("*")) break;
                JavaManager javaManager = JavaManager.getJavaManager(project);
                JavaClass javaClass = javaManager.getClass(string);
                elementAt = ElementAt.findElementAt((JavaType)javaClass);
                break;
            }
            case 28: {
                SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                JavaType javaType = sourceTypeReference.getResolvedType();
                if (javaType != null) {
                    elementAt = ElementAt.findElementAt(javaType);
                    break;
                }
                elementAt = null;
                break;
            }
            case 58: {
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                elementAt = ElementAt.findElementInExpression((SourceExpression)sourceSimpleNameExpression);
                break;
            }
            case 50: {
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                SourceExpression sourceExpression = sourceDotExpression.getLhsOperand();
                if (Patch.contains((SourceElement)sourceExpression, n)) {
                    elementAt = ElementAt.findElementInSourceElement(project, (SourceElement)sourceExpression, n);
                    break;
                }
                elementAt = ElementAt.findElementInExpression((SourceExpression)sourceDotExpression);
                break;
            }
            case 54: {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                SourceName sourceName = sourceMethodCallExpression.getNameElement();
                if (Patch.contains((SourceElement)sourceName, n)) {
                    JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (javaMethod != null) {
                        elementAt = new ElementAt(javaMethod);
                        elementAt.setSourceContext((SourceElement)sourceMethodCallExpression);
                        break;
                    }
                    elementAt = null;
                    break;
                }
                elementAt = ElementAt.findElementInChildren(project, sourceElement, n);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                SourceName sourceName = sourceHasName.getNameElement();
                if (sourceName != null && Patch.contains((SourceElement)sourceName, n)) {
                    elementAt = ElementAt.findElementOfResolvedElement((SourceElement)sourceHasName);
                    break;
                }
                elementAt = ElementAt.findElementInChildren(project, sourceElement, n);
                break;
            }
            case 56: {
                SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceElement;
                SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
                if (Patch.contains((SourceElement)sourceTypeReference, n)) {
                    JavaMethod javaMethod = sourceNewClassExpression.getResolvedMethod();
                    if (javaMethod == null) break;
                    elementAt = new ElementAt(javaMethod);
                    break;
                }
                elementAt = ElementAt.findElementInChildren(project, (SourceElement)sourceNewClassExpression, n);
                break;
            }
            case 7: {
                SourceEnumConstant sourceEnumConstant = (SourceEnumConstant)sourceElement;
                elementAt = new ElementAt((JavaElement)sourceEnumConstant, 7);
                break;
            }
            default: {
                elementAt = ElementAt.findElementInChildren(project, sourceElement, n);
            }
        }
        return elementAt;
    }

    private static ElementAt findElementInExpression(SourceExpression sourceExpression) {
        SourceElement sourceElement;
        ElementAt elementAt = null;
        JavaHasType javaHasType = sourceExpression.getResolvedObject();
        if (javaHasType != null && (sourceElement = javaHasType.getSourceElement()) != null) {
            elementAt = ElementAt.findElementOfResolvedElement(sourceElement);
            elementAt.setSourceContext((SourceElement)sourceExpression);
        }
        return elementAt;
    }

    private static ElementAt findElementOfResolvedElement(SourceElement sourceElement) {
        ElementAt elementAt = null;
        int n = sourceElement.getSymbolKind();
        switch (n) {
            case 3: {
                SourceClass sourceClass = (SourceClass)sourceElement;
                elementAt = new ElementAt((JavaClass)sourceClass);
                break;
            }
            case 6: 
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                elementAt = new ElementAt((JavaMethod)sourceMethod);
                break;
            }
            case 10: {
                JavaField javaField = (JavaField)sourceElement;
                elementAt = new ElementAt(javaField);
                break;
            }
            case 13: 
            case 17: {
                SourceVariable sourceVariable = (SourceVariable)sourceElement;
                elementAt = new ElementAt(sourceVariable);
            }
        }
        return elementAt;
    }

    private static ElementAt findElementInChildren(Project project, SourceElement sourceElement, int n) {
        ElementAt elementAt = null;
        SourceElement[] sourceElementArray = sourceElement.getContainedElements();
        int n2 = 0;
        while (elementAt == null && n2 < sourceElementArray.length) {
            SourceElement sourceElement2 = sourceElementArray[n2];
            if (Patch.contains(sourceElement2, n)) {
                elementAt = ElementAt.findElementInSourceElement(project, sourceElement2, n);
            }
            ++n2;
        }
        return elementAt;
    }

    private static ElementAt findElementAt(JavaType javaType) {
        JavaClass javaClass;
        ElementAt elementAt = null;
        if (javaType != null && (javaClass = javaType.getTypeErasure()) != null) {
            elementAt = new ElementAt(javaClass);
        }
        return elementAt;
    }

    public static SourceClass getSourceClassAt(Context context, boolean bl, boolean bl2) {
        Object object = null;
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            int n = codeEditor.getCaretPosition();
            Node node = context.getNode();
            if (node instanceof TextNode) {
                SourceClass sourceClass;
                int n2;
                ElementAt elementAt;
                TextNode textNode = (TextNode)node;
                if (bl && (elementAt = ElementAt.findElementAt(textNode, project, n)) != null && (n2 = elementAt.getElementType()) == 1 && (sourceClass = (SourceClass)elementAt.getSourceElement()) != null && Util.isClassInSources(workspace, project, sourceClass)) {
                    object = sourceClass;
                }
                if (object == null) {
                    object = ElementAt.getSourceClassAt(workspace, project, textNode, n);
                }
                if (!bl2 && object != null) {
                    while (object != null && object.getName() == null) {
                        SourceClass sourceClass2 = object.getEnclosingClass();
                        object = Util.isClassInSources(workspace, project, sourceClass2) ? sourceClass2 : null;
                    }
                }
            }
        } else if (view instanceof UIEditor) {
            CmtComponentSource cmtComponentSource;
            UIEditor uIEditor = (UIEditor)view;
            CmtComponentSource cmtComponentSource2 = cmtComponentSource = uIEditor != null ? uIEditor.getComponentSource() : null;
            if (cmtComponentSource != null) {
                object = (SourceClass)cmtComponentSource.getType().getSourceElement();
            }
        } else if (view instanceof NavigatorWindow) {
            NavigatorWindow navigatorWindow = (NavigatorWindow)view;
            object = ElementAt.getSourceClassAt(workspace, navigatorWindow, project);
        } else if (view instanceof ExplorerWindow) {
            ExplorerWindow explorerWindow = (ExplorerWindow)view;
            object = ElementAt.getSourceClassAt(explorerWindow);
        }
        return object;
    }

    private static SourceClass getSourceClassAt(Workspace workspace, NavigatorWindow navigatorWindow, Project project) {
        Element element;
        SourceClass sourceClass = null;
        Element[] elementArray = navigatorWindow.getSelection();
        if (elementArray.length == 1 && (element = elementArray[0]) instanceof JavaSourceNode) {
            SourceClass sourceClass2;
            JavaSourceNode javaSourceNode = (JavaSourceNode)element;
            URL uRL = javaSourceNode.getURL();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null && Util.isClassInSources(workspace, project, sourceClass2 = Patch.getMainClass(sourceFile))) {
                sourceClass = sourceClass2;
            }
        }
        return sourceClass;
    }

    private static SourceClass getSourceClassAt(Workspace workspace, Project project, TextNode textNode, int n) {
        URL uRL;
        SourceClass sourceClass = null;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(uRL = textNode.getURL());
        if (sourceFile != null) {
            SourceElement sourceElement = sourceFile.getElementAt(n);
            while (sourceElement != null && sourceClass == null) {
                SourceClass sourceClass2 = (SourceClass)Util.getAncestorOfClass(SourceClass.class, sourceElement);
                if (sourceClass2 == null) break;
                if (Util.isClassInSources(workspace, project, sourceClass2)) {
                    sourceClass = sourceClass2;
                }
                sourceElement = sourceClass2.getParent();
            }
        }
        return sourceClass;
    }

    private static SourceClass getSourceClassAt(ExplorerWindow explorerWindow) {
        UIEditorCanvas uIEditorCanvas;
        Element[] elementArray;
        Explorer explorer;
        SourceClass sourceClass = null;
        if (explorerWindow != null && (explorer = explorerWindow.getExplorer()) instanceof UIEditorCanvas && (elementArray = (uIEditorCanvas = (UIEditorCanvas)explorer).getSelection()) != null && elementArray.length > 0) {
            CmtComponent cmtComponent;
            CmtModelNode cmtModelNode = (CmtModelNode)elementArray[0];
            CmtSubcomponent cmtSubcomponent = cmtModelNode != null ? cmtModelNode.getSubcomponent() : null;
            CmtComponent cmtComponent2 = cmtComponent = cmtSubcomponent != null ? cmtSubcomponent.getOuterComponent() : null;
            if (cmtComponent != null) {
                sourceClass = (SourceClass)cmtComponent.getType().getSourceElement();
            }
        }
        return sourceClass;
    }
}

