/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring;

import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.RefactorManager;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.WeightedList;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.events.RefactoringListener;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.RefactorAddin;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.duplicate.DuplicateClassController;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceController;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceURLHandler;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeStaticController;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigController;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveController;
import oracle.jdevimpl.refactoring.oprs.moveclasses.MoveClassesURLHandler;
import oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass.ExtractSuperclassController;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpController;
import oracle.jdevimpl.refactoring.oprs.movemember.pushdown.PushDownController;
import oracle.jdevimpl.refactoring.oprs.rename.RenameController;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldURLHandler;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;
import oracle.jdevimpl.refactoring.oprs.rename.variable.FindRenameVariableURLHandler;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteClassHandler;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteController;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteFieldHandler;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteMethodHandler;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeController;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeURLHandler;
import oracle.jdevimpl.refactoring.search.FindClassURLHandler;
import oracle.jdevimpl.refactoring.search.FindConstructorURLHandler;
import oracle.jdevimpl.refactoring.search.UsageController;
import oracle.jdevimpl.refactoring.util.RadioKeyController;

public class RefManagerImpl
extends RefactoringManager {
    private WeightedList _weightedUrlHandlers;
    private ArrayList _refListeners;
    private static final String FIELD_PREFIX = "_";

    void $init$() {
        this._weightedUrlHandlers = new WeightedList();
        this._refListeners = new ArrayList();
    }

    static RefManagerImpl createInstance() {
        RefactorManager.INSTANCE = new RefManagerImpl();
        return (RefManagerImpl)RefactorManager.INSTANCE;
    }

    private RefManagerImpl() {
        this.$init$();
        this.registerUrlHandler(new FindClassURLHandler(), 0.5);
        this.registerUrlHandler(new FindConstructorURLHandler(), 0.5);
        this.registerUrlHandler(new FindRenameVariableURLHandler(), 0.5);
        this.registerUrlHandler(new RenameMethodURLHandler(), 0.5);
        this.registerUrlHandler(new RenameFieldURLHandler(), 0.5);
        this.registerUrlHandler(new SafeDeleteClassHandler(), 0.5);
        this.registerUrlHandler(new SafeDeleteMethodHandler(), 0.5);
        this.registerUrlHandler(new SafeDeleteFieldHandler(), 0.5);
        this.registerUrlHandler(new UseSupertypeURLHandler(), 0.5);
        this.registerUrlHandler(new MoveClassesURLHandler(), 0.5);
        this.registerUrlHandler(new ExtractInterfaceURLHandler(), 0.5);
        this.registerUrlHandler(new TextURLHandler(), 1.0);
    }

    public void registerUrlHandler(URLHandler uRLHandler, double d) {
        this._weightedUrlHandlers.add((Object)uRLHandler, d);
    }

    public void unregisterUrlHandler(URLHandler uRLHandler) {
        this._weightedUrlHandlers.remove((Object)uRLHandler);
    }

    public Iterator getRegisteredUrlHandlers() {
        return this._weightedUrlHandlers.iterator();
    }

    public void addRefactoringListener(RefactoringListener refactoringListener) {
        this._refListeners.add(refactoringListener);
    }

    public void removeRefactoringListener(RefactoringListener refactoringListener) {
        this._refListeners.remove(refactoringListener);
    }

    public void fireRefEvent(RefactoringEvent refactoringEvent) {
        int n = refactoringEvent.getId();
        RefactoringListener[] refactoringListenerArray = this._refListeners.toArray(new RefactoringListener[this._refListeners.size()]);
        int n2 = 0;
        while (n2 < refactoringListenerArray.length) {
            RefactoringListener refactoringListener = refactoringListenerArray[n2];
            try {
                switch (n) {
                    case 1: {
                        refactoringListener.beforeRefactor(refactoringEvent);
                        break;
                    }
                    case 2: {
                        refactoringListener.nodesPopulated(refactoringEvent);
                        break;
                    }
                    case 3: {
                        refactoringListener.usagesPopulated(refactoringEvent);
                        break;
                    }
                    case 4: {
                        refactoringListener.beforeDo(refactoringEvent);
                        break;
                    }
                    case 5: {
                        refactoringListener.afterDo(refactoringEvent);
                        break;
                    }
                    case 6: {
                        refactoringListener.beforeUndo(refactoringEvent);
                        break;
                    }
                    case 7: {
                        refactoringListener.afterUndo(refactoringEvent);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
            ++n2;
        }
    }

    public void addRefactoringController(int n, Controller controller, double d) {
        RefactorAddin.getInstance().addRefactoringController(n, controller, d);
    }

    public void removeRefactoringController(int n, Controller controller) {
        RefactorAddin.getInstance().removeRefactoringController(n, controller);
    }

    public boolean canMoveClasses(Context context, SourceClass[] sourceClassArray) {
        return MoveController.canMoveClasses(context, sourceClassArray);
    }

    public void initiateMoveClasses(Context context, SourceClass[] sourceClassArray) {
        MoveController.whenMoveClasses(context, sourceClassArray);
    }

    public boolean moveClasses(Context context, MoveClassesCriteria moveClassesCriteria, boolean bl) {
        MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
        return ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl);
    }

    public void initiateRenameClass(Context context, SourceClass sourceClass) {
        RenameController.whenRenameClass(context, sourceClass);
    }

    public boolean renameClasses(Context context, Map map) {
        boolean bl = true;
        MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(false, false, null, null);
        JavaManager javaManager = JavaManager.getJavaManager(context.getProject());
        Iterator iterator = map.keySet().iterator();
        while (bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            SourceClass sourceClass = javaManager.getSourceClass(string);
            if (sourceClass != null) {
                String string2 = sourceClass.getPackageName();
                String string3 = (String)map.get(string);
                JavaClass javaClass = sourceClass.getOwningClass();
                if (javaClass == null) {
                    String string4 = sourceClass.getName();
                    int n = string3.lastIndexOf(46);
                    String string5 = n == -1 ? "" : string3.substring(0, n);
                    String string6 = string3.substring(n + 1);
                    moveClassesCriteria.addClassMove(javaManager, string2, string4, string5, string6);
                    continue;
                }
                String string7 = javaClass.getQualifiedName();
                if (string3.startsWith(string7)) {
                    String string8 = string.substring(string7.length() + 1);
                    String string9 = string3.substring(string7.length() + 1);
                    if (string9.indexOf(46) == -1) {
                        String string10 = javaClass.getName();
                        moveClassesCriteria.addClassMove(javaManager, string2, string10 + '.' + string8, string2, string10 + '.' + string9);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        if (bl) {
            bl = this.moveClasses(context, moveClassesCriteria, false);
        }
        return bl;
    }

    public boolean canRenamePackage(Context context, JavaPackage javaPackage) {
        return RenameController.canRenamePackage();
    }

    public void initiateRenamePackage(Context context, JavaPackage javaPackage) {
        RenameController.whenRenamePackage(context, javaPackage);
    }

    public boolean canRenameMethod(Context context, SourceMethod sourceMethod) {
        return RenameController.canRenameMethod(context, sourceMethod);
    }

    public void initiateRenameMethod(Context context, SourceMethod sourceMethod) {
        RenameController.whenRenameMethod(context, sourceMethod);
    }

    public boolean renameMethod(Context context, String string, String string2, String string3, String[] stringArray) {
        boolean bl = false;
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceClass sourceClass = javaManager.getSourceClass(string);
        if (sourceClass != null) {
            JavaMethod javaMethod;
            boolean bl2 = false;
            JavaType[] javaTypeArray = new JavaType[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string4 = stringArray[n];
                javaTypeArray[n] = javaManager.getClass(string4);
                if (javaTypeArray[n] == null) {
                    bl2 = true;
                }
                ++n;
            }
            if (!bl2 && (javaMethod = sourceClass.getMethod(string2, javaTypeArray)) != null) {
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
                RenameMethodCriteria renameMethodCriteria = new RenameMethodCriteria(methodDescription, string3, false, false);
                SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, renameMethodCriteria);
                bl = searchOperationImpl.runRefactoring(false);
            }
        }
        return bl;
    }

    public boolean canRenameField(Context context, SourceFieldVariable sourceFieldVariable) {
        return RenameController.canRenameField(context, sourceFieldVariable);
    }

    public void initiateRenameField(Context context, SourceFieldVariable sourceFieldVariable) {
        RenameController.whenRenameField(context, (SourceMemberVariable)sourceFieldVariable);
    }

    public boolean renameField(Context context, String string, String string2, String string3, String string4) {
        return this.renameField(context, string, string2, string3, string4, false, false, false, false);
    }

    public boolean renameField(Context context, String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JavaField javaField;
        SourceFieldVariable sourceFieldVariable;
        boolean bl5 = false;
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceClass sourceClass = javaManager.getSourceClass(string);
        if (sourceClass != null && (sourceFieldVariable = (SourceFieldVariable)(javaField = sourceClass.getField(string3)).getSourceElement()) != null) {
            bl5 = RenameController.renameField(context, (SourceMemberVariable)sourceFieldVariable, string4, bl, bl2, bl3, bl4);
        }
        return bl5;
    }

    public boolean canSafeDelete(Context context, URL[] uRLArray) {
        return SafeDeleteController.canSafeDeleteFiles(context, uRLArray);
    }

    public boolean safeDeleteFiles(Context context, URL[] uRLArray) {
        return SafeDeleteController.safeDeleteFiles(context, uRLArray);
    }

    public boolean safeDeleteClasses(Context context, SourceClass[] sourceClassArray) {
        return SafeDeleteController.safeDeleteClasses(context, sourceClassArray);
    }

    public boolean safeDeleteMethod(Context context, SourceMethod sourceMethod) {
        return SafeDeleteController.whenSafeDeleteMethod(context, sourceMethod);
    }

    public boolean safeDeleteField(Context context, SourceFieldVariable sourceFieldVariable) {
        return SafeDeleteController.whenSafeDeleteField(context, (SourceMemberVariable)sourceFieldVariable);
    }

    public static RefManagerImpl getImplInstance() {
        return (RefManagerImpl)RefManagerImpl.getRefactoringManager();
    }

    public boolean canMoveMember(Context context, SourceMember sourceMember) {
        return MoveController.canMoveStaticMember(context, sourceMember);
    }

    public void initiateMoveMember(Context context, SourceMember sourceMember) {
        MoveController.whenMoveStaticMembers(context, sourceMember);
    }

    public boolean canFindClassUsages(Context context, JavaClass javaClass) {
        return true;
    }

    public void initiateFindClassUsages(Context context, JavaClass javaClass) {
        UsageController.whenFindClassUsages(context, javaClass);
    }

    public boolean canFindMethodUsages(JavaMethod javaMethod) {
        return true;
    }

    public void initiateFindMethodUsages(Context context, JavaMethod javaMethod) {
        UsageController.whenFindMethodUsages(context, javaMethod);
    }

    public boolean canExtractInterface(Context context, SourceClass sourceClass) {
        return ExtractInterfaceController.canExtract(context, sourceClass);
    }

    public void initiateExtractInterface(Context context, SourceClass sourceClass) {
        ExtractInterfaceController.whenExtract(context, sourceClass);
    }

    public boolean extractInterface(Context context, SourceClass sourceClass, String string, String string2, JavaType[] javaTypeArray, SourceMethod[] sourceMethodArray, SourceFieldVariable[] sourceFieldVariableArray) {
        return ExtractInterfaceController.extractInterface(context, sourceClass, string, string2, javaTypeArray, sourceMethodArray, sourceFieldVariableArray);
    }

    public boolean canExtractSuperclass(Context context, SourceClass sourceClass) {
        return ExtractSuperclassController.canExtract(context, sourceClass);
    }

    public void initiateExtractSuperclass(Context context, SourceClass sourceClass) {
        ExtractSuperclassController.whenExtract(context, sourceClass);
    }

    public boolean canChangeMethod(Context context, SourceMethod sourceMethod) {
        return MetSigController.canHandle(context, sourceMethod);
    }

    public void initiateChangeMethod(Context context, SourceMethod sourceMethod) {
        MetSigController.whenHandle(context, sourceMethod);
    }

    public boolean changeMethod(Context context, ChangeMethodCriteria changeMethodCriteria) {
        return MetSigController.changeMethod(context, changeMethodCriteria);
    }

    public boolean canUseSupertype(Context context, SourceClass sourceClass) {
        return UseSupertypeController.canUseSupertype(context, sourceClass);
    }

    public void initiateUseSupertype(Context context, SourceClass sourceClass) {
        UseSupertypeController.whenUseSupertype(context, sourceClass);
    }

    public boolean canPullUp(SourceClass sourceClass) {
        return PullUpController.canPullUp(sourceClass);
    }

    public void initiatePullUp(Context context, SourceClass sourceClass, SourceMember sourceMember) {
        PullUpController.whenPullUp(context, sourceClass, sourceMember);
    }

    public boolean canPushDown(SourceClass sourceClass) {
        return PushDownController.canPushDown(sourceClass);
    }

    public void initiatePushDown(Context context, SourceClass sourceClass, SourceMember sourceMember) {
        PushDownController.whenPushDown(context, sourceClass, sourceMember);
    }

    public static String getDefaultFieldPrefix() {
        return FIELD_PREFIX;
    }

    private SourceClass getSourceClass(Context context, URL uRL) {
        JavaClass javaClass;
        SourceFile sourceFile;
        JavaManager javaManager;
        SourceClass sourceClass = null;
        Project project = context.getProject();
        if (project != null && (javaManager = JavaManager.getJavaManager(project)) != null && (sourceFile = javaManager.getSourceFile(uRL)) != null && (javaClass = sourceFile.getPrimaryClass()) != null) {
            sourceClass = (SourceClass)javaClass.getSourceElement();
        }
        return sourceClass;
    }

    public int canSafeRename(Context context, URL uRL) {
        SourceClass sourceClass;
        int n = 1;
        if (Util.isJavaSource(uRL) && (sourceClass = this.getSourceClass(context, uRL)) != null) {
            DismissableJEWTDialog dismissableJEWTDialog = new DismissableJEWTDialog((Frame)Ide.getMainWindow());
            Box box = Box.createVerticalBox();
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)jRadioButton, (String)RefactoringArb.getString(159));
            buttonGroup.add(jRadioButton);
            box.add(jRadioButton);
            jRadioButton.addMouseListener(dismissableJEWTDialog);
            JRadioButton jRadioButton2 = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)jRadioButton2, (String)RefactoringArb.getString(160));
            buttonGroup.add(jRadioButton2);
            box.add(jRadioButton2);
            jRadioButton2.addMouseListener(dismissableJEWTDialog);
            CopyableInteger copyableInteger = CopyableInteger.loadCopyableInteger("FileRenamePref", 0);
            JRadioButton jRadioButton3 = copyableInteger.isBitSet(1) ? jRadioButton2 : jRadioButton;
            jRadioButton3.setSelected(true);
            RadioKeyController.attach(buttonGroup);
            dismissableJEWTDialog.setContent(box);
            dismissableJEWTDialog.setInitialFocus(jRadioButton3);
            HelpSystem.getHelpSystem().registerTopic((JComponent)box, "f1_idedrenamefile_html");
            if (dismissableJEWTDialog.runDialog()) {
                boolean bl = jRadioButton2.isSelected();
                copyableInteger.setBit(1, bl);
                if (bl) {
                    n = 0;
                }
            } else {
                n = 2;
            }
        }
        return n;
    }

    public boolean doSafeRename(Context context, URL uRL) {
        SourceClass sourceClass = this.getSourceClass(context, uRL);
        this.initiateRenameClass(context, sourceClass);
        return true;
    }

    public boolean canUpdateReferences(Context context, URL uRL) {
        if (Util.isJavaSource(uRL)) {
            return false;
        }
        return false;
    }

    public boolean doUpdateReferences(Context context, URL uRL, URL uRL2) {
        Object[] objectArray = new Object[]{URLFileSystem.getPlatformPathName((URL)uRL), URLFileSystem.getPlatformPathName((URL)uRL2)};
        String string = MessageFormat.format(RefactoringArb.getString(161), objectArray);
        MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(true, true, string, RefactoringArb.getString(162));
        moveClassesCriteria.addFileMove(context, uRL, uRL2);
        MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
        ((SearchOperationImpl)moveClassesOperation).runRefactoring(true);
        return false;
    }

    public boolean canMakeStatic(Context context, SourceMethod sourceMethod) {
        return MakeStaticController.handle(context, (JavaMethod)sourceMethod, false);
    }

    public boolean initiateMakeStatic(Context context, SourceMethod sourceMethod) {
        return MakeStaticController.handle(context, (JavaMethod)sourceMethod, true);
    }

    public boolean canMakeStatic(Context context, SourceFieldVariable sourceFieldVariable) {
        return MakeStaticController.handle(context, (JavaField)sourceFieldVariable, false);
    }

    public boolean initiateMakeStatic(Context context, SourceFieldVariable sourceFieldVariable) {
        return MakeStaticController.handle(context, (JavaField)sourceFieldVariable, true);
    }

    public boolean canDuplicate(Context context, SourceClass sourceClass) {
        return DuplicateClassController.handle(context, sourceClass, false);
    }

    public boolean initiateDuplicate(Context context, SourceClass sourceClass) {
        return DuplicateClassController.whenDuplicateClass(context, sourceClass);
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog
    implements MouseListener {
        public DismissableJEWTDialog(Frame frame) {
            super(frame, RefactoringArb.getString(158), 7);
        }

        public void dismiss() {
            this.dismissDialog(false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                this.dismiss();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

