/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.RefManagerImpl;

public class TextChangeCommand
extends Command {
    private static final String COMMAND_ID = "THE_CMD_ID";
    private String _commandName;
    private RefactoringChange[] _changes;
    protected SearchOperation _searchOperation;

    private static int getCommandID() {
        int n = Ide.findOrCreateCmdID((String)COMMAND_ID);
        return n;
    }

    public TextChangeCommand(Context context, String string, List list) {
        super(TextChangeCommand.getCommandID(), 3);
        this._searchOperation = null;
        Collections.sort(list);
        RefactoringChange[] refactoringChangeArray = list.toArray(new RefactoringChange[list.size()]);
        this.init(context, string, refactoringChangeArray);
    }

    public TextChangeCommand(SearchOperation searchOperation, List list) {
        super(TextChangeCommand.getCommandID(), 3);
        this._searchOperation = searchOperation;
        Collections.sort(list);
        RefactoringChange[] refactoringChangeArray = list.toArray(new RefactoringChange[list.size()]);
        this.init(searchOperation.getContext(), searchOperation.getCriteria().getShortTitle(), refactoringChangeArray);
    }

    private void init(Context context, String string, RefactoringChange[] refactoringChangeArray) {
        this.setCommandName(string);
        if (refactoringChangeArray != null) {
            this.setChanges(refactoringChangeArray);
        }
        this.setContext(context);
    }

    protected void setCommandName(String string) {
        this._commandName = string;
    }

    protected void setChanges(RefactoringChange[] refactoringChangeArray) {
        this._changes = refactoringChangeArray;
    }

    public int doit() throws Exception {
        if (!this.areNodesWritable()) {
            return 1;
        }
        this.fireEvent(true, true);
        boolean bl = true;
        HashSet<Node> hashSet = new HashSet<Node>();
        int n = this._changes.length - 1;
        while (bl && n >= 0) {
            RefactoringChange refactoringChange = this._changes[n];
            if (refactoringChange.doit()) {
                Node node = refactoringChange.getNode();
                if (node != null) {
                    hashSet.add(node);
                }
            } else {
                int n2 = n + 1;
                while (n2 < this._changes.length) {
                    RefactoringChange refactoringChange2 = this._changes[n2];
                    refactoringChange2.undo();
                    ++n2;
                }
                bl = false;
            }
            --n;
        }
        if (bl) {
            this.notifyNodes(hashSet);
        }
        this.fireEvent(true, false);
        return bl ? 0 : 1;
    }

    private void notifyNodes(HashSet hashSet) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, null);
        for (Node node : hashSet) {
            node.notifyObservers((Object)node, updateMessage);
        }
    }

    public int undo() throws Exception {
        if (!this.areNodesWritable()) {
            return 1;
        }
        this.fireEvent(false, true);
        boolean bl = true;
        HashSet<Node> hashSet = new HashSet<Node>();
        int n = 0;
        while (bl && n < this._changes.length) {
            RefactoringChange refactoringChange = this._changes[n];
            if (refactoringChange.undo()) {
                Node node = refactoringChange.getNode();
                if (node != null) {
                    hashSet.add(node);
                }
            } else {
                int n2 = n - 1;
                while (n2 >= 0) {
                    RefactoringChange refactoringChange2 = this._changes[n2];
                    refactoringChange2.doit();
                    --n2;
                }
                bl = false;
            }
            ++n;
        }
        this.fireEvent(false, false);
        if (bl) {
            this.notifyNodes(hashSet);
        }
        return bl ? 0 : 1;
    }

    public String getName() {
        return this._commandName;
    }

    public Node[] getAffectedNodes() {
        HashSet<Node> hashSet = new HashSet<Node>();
        int n = 0;
        while (n < this._changes.length) {
            RefactoringChange refactoringChange = this._changes[n];
            Node node = refactoringChange.getNode();
            if (node != null) {
                hashSet.add(node);
            }
            ++n;
        }
        return hashSet.toArray(new Node[hashSet.size()]);
    }

    private boolean areNodesWritable() {
        int n = 0;
        while (n < this._changes.length) {
            RefactoringChange refactoringChange = this._changes[n];
            Node node = refactoringChange.getNode();
            if (node != null && node.isReadOnly()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean prepareFiles() {
        boolean bl;
        ProgressBar progressBar;
        1MyRunnable myRunnable = new 1MyRunnable();
        myRunnable._progressBar = progressBar = new ProgressBar((Component)Ide.getMainWindow(), RefactoringArb.getString(169), (Runnable)myRunnable, true);
        progressBar.start(RefactoringArb.getString(170), "");
        if (myRunnable._failedFile != null) {
            String string = URLFileSystem.getPlatformPathName((URL)myRunnable._failedFile);
            String string2 = MessageFormat.format(RefactoringArb.getString(171), string);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)this._commandName, null);
            bl = false;
        } else {
            bl = progressBar.hasUserCancelled() ^ true;
        }
        return bl;
    }

    public boolean runCommand() {
        boolean bl = false;
        if (this.prepareFiles()) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                int n = commandProcessor.invoke((Command)this);
                bl = n == 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static boolean runCommand(Context context, String string, List list) {
        TextChangeCommand textChangeCommand = new TextChangeCommand(context, string, list);
        return textChangeCommand.runCommand();
    }

    public static boolean runCommand(List list, SearchOperation searchOperation) {
        TextChangeCommand textChangeCommand = new TextChangeCommand(searchOperation, list);
        return textChangeCommand.runCommand();
    }

    protected void fireEvent(boolean bl, boolean bl2) {
        int n = bl ? (bl2 ? 4 : 5) : (bl2 ? 6 : 7);
        RefactoringEvent refactoringEvent = this.createRefactoringEvent(n);
        if (refactoringEvent != null) {
            RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
            refManagerImpl.fireRefEvent(refactoringEvent);
        }
    }

    protected RefactoringEvent createRefactoringEvent(int n) {
        if (this._searchOperation != null) {
            return new RefactoringEvent(n, this._searchOperation);
        }
        return null;
    }

    public class 1MyRunnable
    implements Runnable {
        URL _failedFile;
        ProgressBar _progressBar;

        public void run() {
            Node[] nodeArray = TextChangeCommand.this.getAffectedNodes();
            int n = 0;
            while (this._failedFile == null && n < nodeArray.length) {
                Node node = nodeArray[n];
                URL uRL = node.getURL();
                String string = URLFileSystem.getPlatformPathName((URL)uRL);
                this._progressBar.updateProgress(null, string);
                if (!URLFileSystem.setReadOnly((URL)uRL, (boolean)false) && !Util.setReadOnly(uRL, false)) {
                    this._failedFile = uRL;
                }
                ++n;
            }
            this._progressBar.setDoneStatus();
        }

        1MyRunnable() {
        }
    }
}

