/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;

public abstract class BaseDialog
extends JPanel {
    private JEWTDialog _dlg;
    private String _preferenceKey;
    private Context _context;
    protected static boolean _preferNewTabChecked;
    private boolean _okButtonEnabled;
    private JLabel _messageLabel;
    private UpdateOnChanges _updateOnChangesListener;

    void $init$() {
        this._okButtonEnabled = true;
    }

    protected abstract String getTitle();

    protected abstract int getDefaultPreferences();

    protected abstract void updateOKButton();

    protected abstract void updateSettings(CopyableInteger var1);

    protected abstract JComponent getDefaultFocusedComponent();

    protected abstract String getHelpTopicID();

    protected BaseDialog(String string, Context context) {
        super(new GridBagLayout());
        this.$init$();
        this._preferenceKey = string;
        this._context = context;
    }

    public void setDlg(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
        JComponent jComponent = this.getDefaultFocusedComponent();
        this._dlg.setInitialFocus((Component)jComponent);
        this.updateOKButton();
    }

    protected Context getContext() {
        return this._context;
    }

    private JEWTDialog getDlg() {
        return this._dlg;
    }

    protected boolean isInitialized() {
        return this.getDlg() != null;
    }

    protected CopyableInteger getSettings() {
        IdeSettings ideSettings = Ide.getSettings();
        CopyableInteger copyableInteger = (CopyableInteger)ideSettings.getData(this._preferenceKey);
        if (copyableInteger == null) {
            copyableInteger = new CopyableInteger();
            copyableInteger.setValue(this.getDefaultPreferences());
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData(this._preferenceKey, (Copyable)copyableInteger);
        }
        return copyableInteger;
    }

    public boolean runDialog() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        String string = this.getHelpTopicID();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, string);
        String string2 = this.getTitle();
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, string2, 7);
        this.setDlg(jEWTDialog);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setResizable(true);
        boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
        if (bl) {
            this.updateSettings();
        }
        return bl;
    }

    private void updateSettings() {
        CopyableInteger copyableInteger = this.getSettings();
        this.updateSettings(copyableInteger);
    }

    protected void setOKButtonEnabled(boolean bl) {
        if (this._okButtonEnabled != bl) {
            this._okButtonEnabled = bl;
            SwingUtilities.invokeLater(new 1());
        }
    }

    public static boolean isPreferNewTabChecked() {
        return _preferNewTabChecked;
    }

    public static void setPreferNewTabChecked(boolean bl) {
        _preferNewTabChecked = bl;
    }

    protected void setMessage(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this._messageLabel.setText(string);
        Icon icon = string.length() == 0 ? null : (bl ? CommonIconsUtils.getWarningIcon() : CommonIconsUtils.getErrorIcon());
        this._messageLabel.setIcon(icon);
        this._messageLabel.setToolTipText(string);
    }

    protected void setMessageLabel(JLabel jLabel) {
        this._messageLabel = jLabel;
        this._messageLabel.setFocusable(true);
    }

    protected final void updateOnChanges(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        UpdateOnChanges updateOnChanges = this.getUpdateOnChangesListener();
        document.addDocumentListener(updateOnChanges);
    }

    protected final void updateOnChanges(JComboBox jComboBox) {
        ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
        JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
        Document document = jTextField.getDocument();
        UpdateOnChanges updateOnChanges = this.getUpdateOnChangesListener();
        document.addDocumentListener(updateOnChanges);
    }

    public void updateOnChanges(JCheckBox jCheckBox) {
        jCheckBox.getModel().addChangeListener(this.getUpdateOnChangesListener());
    }

    public void updateOnChanges(JTable jTable) {
        jTable.getModel().addTableModelListener(this.getUpdateOnChangesListener());
    }

    protected final void updateOnTreeCellChecked(CustomJTree customJTree) {
        UpdateOnChanges updateOnChanges = this.getUpdateOnChangesListener();
        customJTree.addTreeCellCheckedListener((TreeCellCheckedListener)updateOnChanges);
    }

    public void updateOnSelectionChange(JList jList) {
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        UpdateOnChanges updateOnChanges = this.getUpdateOnChangesListener();
        listSelectionModel.addListSelectionListener(updateOnChanges);
    }

    public void updateOnSelectionChange(JTree jTree) {
        UpdateOnChanges updateOnChanges = this.getUpdateOnChangesListener();
        jTree.addTreeSelectionListener(updateOnChanges);
    }

    private UpdateOnChanges getUpdateOnChangesListener() {
        if (this._updateOnChangesListener == null) {
            this._updateOnChangesListener = new UpdateOnChanges(null);
        }
        return this._updateOnChangesListener;
    }

    static JEWTDialog mav$getDlg(BaseDialog baseDialog) {
        return baseDialog.getDlg();
    }

    static boolean ra$_okButtonEnabled(BaseDialog baseDialog) {
        return baseDialog._okButtonEnabled;
    }

    public final class 1
    implements Runnable {
        public void run() {
            JEWTDialog jEWTDialog = BaseDialog.mav$getDlg(BaseDialog.this);
            if (jEWTDialog != null && jEWTDialog.isOKButtonEnabled() != BaseDialog.ra$_okButtonEnabled(BaseDialog.this)) {
                jEWTDialog.setOKButtonEnabled(BaseDialog.ra$_okButtonEnabled(BaseDialog.this));
            }
        }
    }

    private class UpdateOnChanges
    implements TableModelListener,
    ChangeListener,
    TreeCellCheckedListener,
    TreeSelectionListener,
    ListSelectionListener,
    DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            BaseDialog.this.updateOKButton();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            BaseDialog.this.updateOKButton();
        }

        private UpdateOnChanges() {
        }

        UpdateOnChanges(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

