/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdevimpl.refactoring.dnd.JavaSourceNodeDragHelper;

public class FolderDropHelper
implements DropHelper {
    public static final Class DROP_TARGET_CLASS = RelativeDirectoryContextFolder.class;
    private JavaManager javaManager;

    public float getWeight() {
        return 10.0f;
    }

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        if (n == 2 && this.getPackageName(object) != null) {
            int n2 = 0;
            while (n2 < dataFlavorArray.length) {
                if (dataFlavorArray[n2].equals(JavaSourceNodeDragHelper.JAVA_SOURCE_NODE_FLAVOR)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        String string;
        boolean bl = false;
        if (n == 2 && (string = this.getPackageName(object)) != null) {
            Context context = null;
            Project project = null;
            TNode tNode = (TNode)object;
            Project project2 = (Project)tNode.getAncestor(Project.class);
            try {
                if (transferableArray.length > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    Transferable transferable = transferableArray[0];
                    if (transferable.isDataFlavorSupported(TransferableContext.contextFlavor)) {
                        TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(TransferableContext.contextFlavor);
                        context = transferableContext.getContext();
                    }
                    if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (defaultMutableTreeNode = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)) instanceof TNode) {
                        project = (Project)((TNode)defaultMutableTreeNode).getAncestor(Project.class);
                    }
                }
                JavaSourceNode javaSourceNode = null;
                if (context != null && ModelUtil.areEqual((Object)project2, project)) {
                    RefactoringManager refactoringManager;
                    MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(false, false, null, null);
                    URL uRL = this.getTargetDirectory(object);
                    if (uRL != null) {
                        moveClassesCriteria.setPreferredPackageUrl(string, uRL);
                    }
                    JavaManager javaManager = this.getJavaManager(context);
                    int n2 = 0;
                    while (n2 < transferableArray.length) {
                        Transferable transferable = transferableArray[n2];
                        if (transferable.isDataFlavorSupported(JavaSourceNodeDragHelper.JAVA_SOURCE_NODE_FLAVOR)) {
                            JavaSourceNode javaSourceNode2;
                            javaSourceNode = javaSourceNode2 = (JavaSourceNode)transferable.getTransferData(JavaSourceNodeDragHelper.JAVA_SOURCE_NODE_FLAVOR);
                            URL uRL2 = javaSourceNode2.getURL();
                            SourceFile sourceFile = javaManager.getSourceFile(uRL2);
                            JavaClass javaClass = sourceFile.getPrimaryClass();
                            if (javaClass != null) {
                                String string2 = javaClass.getName();
                                String string3 = javaClass.getPackageName();
                                moveClassesCriteria.addClassMove(javaManager, string3, string2, string, string2);
                            }
                        }
                        ++n2;
                    }
                    if (moveClassesCriteria.getOldClsNames().length > 0 && (refactoringManager = RefactoringManager.getRefactoringManager()).moveClasses(context, moveClassesCriteria, false)) {
                        TreeExplorer treeExplorer = tNode.getOwner();
                        TNode tNode2 = treeExplorer.findTNode((Element)javaSourceNode, tNode);
                        if (tNode2 != null) {
                            treeExplorer.setSelected(tNode2);
                        } else {
                            treeExplorer.setSelected(tNode);
                        }
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    protected boolean isValidDropTargetType(Element element) {
        return element instanceof RelativeDirectoryContextFolder;
    }

    private String getPackageName(Object object) {
        String string;
        String string2;
        TNode tNode;
        Element element;
        if (object instanceof TNode && this.isValidDropTargetType(element = (tNode = (TNode)object).getData()) && IdeUtil.isPackageIdentifier((String)(string2 = (string = ((RelativeDirectoryContextFolder)element).getRelativePath()).replaceAll("/", ".")))) {
            return string2;
        }
        return null;
    }

    private URL getTargetDirectory(Object object) {
        RelativeDirectoryContextFolder relativeDirectoryContextFolder;
        URLPath uRLPath;
        URL[] uRLArray;
        TNode tNode;
        Element element;
        URL uRL = null;
        if (object instanceof TNode && this.isValidDropTargetType(element = (tNode = (TNode)object).getData()) && (uRLArray = (uRLPath = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRootDirectories()).getEntries()).length == 1) {
            String string = relativeDirectoryContextFolder.getRelativePath();
            URL uRL2 = uRLArray[0];
            uRL = URLFactory.newDirURL((URL)uRL2, (String)string);
        }
        return uRL;
    }

    private JavaManager getJavaManager(Context context) {
        if (this.javaManager == null) {
            this.javaManager = JavaManager.getJavaManager(context.getProject());
        }
        return this.javaManager;
    }
}

