/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.handlers;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JPaths;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.search.Scope;

public class JavaURLHelper {
    public static HashSet getJavaURLsContaining(SearchOperation searchOperation, Project project, String string, boolean bl, boolean bl2, ProgressIndicator progressIndicator) {
        String[] stringArray = new String[]{string};
        return JavaURLHelper.getJavaURLsContaining(searchOperation, project, stringArray, bl, bl2, Scope.createDummyScope(), progressIndicator);
    }

    public static HashSet getJavaURLsContaining(SearchOperation searchOperation, Project project, String[] stringArray, boolean bl, boolean bl2, Scope scope, ProgressIndicator progressIndicator) {
        HashSet<URL> hashSet = new HashSet<URL>();
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        ContentSet contentSet2 = bl2 ? ProjectContent.getInstance((PropertyStorage)project).getAllContents() : PathsConfiguration.getInstance(project).getJavaContentSet();
        HashSet hashSet2 = searchOperation.getKeywordHits(contentSet2, stringArray, progressIndicator);
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext() && !searchOperation.isUserCancelled()) {
            String string;
            URL uRL = (URL)iterator.next();
            if (!Util.isJavaSource(uRL) || !contentSet.canHaveMember(uRL) || !scope.isValidRelativePath(string = contentSet.toRelativePath(uRL))) continue;
            hashSet.add(uRL);
        }
        if (bl) {
            JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
            JavaURLHelper.search(jProjectLibraries.getJDK(), searchOperation, stringArray, progressIndicator, hashSet);
            JLibrary[] jLibraryArray = jProjectLibraries.getLibraries();
            int n = 0;
            while (n < jLibraryArray.length && !searchOperation.isUserCancelled()) {
                JLibrary jLibrary = jLibraryArray[n];
                JavaURLHelper.search(jLibrary, searchOperation, stringArray, progressIndicator, hashSet);
                ++n;
            }
        }
        return hashSet;
    }

    private static void search(JPaths jPaths, SearchOperation searchOperation, String[] stringArray, ProgressIndicator progressIndicator, HashSet hashSet) {
        URLPath uRLPath = jPaths.getSourcePath();
        HashSet hashSet2 = searchOperation.getKeywordHits(uRLPath, stringArray, progressIndicator);
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext() && !searchOperation.isUserCancelled()) {
            URL uRL = (URL)iterator.next();
            if (!Util.isJavaSource(uRL)) continue;
            hashSet.add(uRL);
        }
    }

    public static URL[] getDefiningClassURLs(SearchOperation searchOperation, String string) {
        List list;
        HashSet hashSet = new HashSet();
        Context context = searchOperation.getContext();
        Project project = context.getProject();
        JavaURLHelper.addDefiningURLs(project, string, hashSet);
        if (hashSet.isEmpty() && (list = DependencyConfiguration.getInstance((Project)project).getDependencyList()) != null) {
            boolean bl = false;
            int n = 0;
            while (!bl && n < list.size()) {
                Dependable dependable = (Dependable)list.get(n);
                Element element = dependable.getSource();
                if (element instanceof Project) {
                    Project project2 = (Project)element;
                    bl = JavaURLHelper.addDefiningURLs(project2, string, hashSet);
                }
                ++n;
            }
        }
        URL[] uRLArray = hashSet.toArray(new URL[hashSet.size()]);
        return uRLArray;
    }

    private static boolean addDefiningURLs(Project project, String string, HashSet hashSet) {
        boolean bl = false;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceClass sourceClass = javaManager.getSourceClass(string);
        if (sourceClass != null) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL uRL = sourceFile.getURL();
            hashSet.add(uRL);
            bl = true;
        }
        return bl;
    }
}

