/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.handlers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMemberCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchConstructorCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.search.Scope;

public class TextURLHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEYWORD_USAGES_KEY = "KEYWORD_USAGES";

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        String[] stringArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case 1: {
                SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchCriteria;
                if (!searchClassCriteria.isSearchInNonJavaFiles()) break;
                String string = searchClassCriteria.getClassName();
                stringArray = new String[]{string};
                break;
            }
            case 3: {
                SearchFieldCriteria searchFieldCriteria = (SearchFieldCriteria)searchCriteria;
                String string = searchFieldCriteria.getFieldName();
                stringArray = new String[]{string};
                break;
            }
            case 2: {
                SearchMethodCriteria searchMethodCriteria = (SearchMethodCriteria)searchCriteria;
                String string = searchMethodCriteria.getMethodName();
                stringArray = new String[]{string};
                break;
            }
            case -2147483546: 
            case -2147483545: {
                RenameMemberCriteria renameMemberCriteria = (RenameMemberCriteria)searchCriteria;
                if (!renameMemberCriteria.isSearchNonJavaFiles()) break;
                String string = renameMemberCriteria.getMemberNameBefore();
                stringArray = new String[]{string};
                break;
            }
            case -2147483535: {
                MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
                if (!moveClassesCriteria.isSearchInNonJavaFiles()) break;
                stringArray = moveClassesCriteria.getFqOldClassesNames();
            }
        }
        if (stringArray != null) {
            SearchOperationImpl searchOperationImpl = (SearchOperationImpl)searchOperation;
            hashSet = this.chooseURLs(searchOperationImpl, stringArray, project, progressIndicator);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        String[] stringArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case 1: {
                SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchCriteria;
                String string = searchClassCriteria.getFqClassName();
                stringArray = new String[]{string};
                break;
            }
            case 3: {
                SearchFieldCriteria searchFieldCriteria = (SearchFieldCriteria)searchCriteria;
                String string = searchFieldCriteria.getFqClassName() + "." + searchFieldCriteria.getFieldName();
                stringArray = new String[]{string};
                break;
            }
            case 2: {
                SearchMethodCriteria searchMethodCriteria = (SearchMethodCriteria)searchCriteria;
                String string = searchMethodCriteria.getFqClassName() + "." + searchMethodCriteria.getMethodName();
                stringArray = new String[]{string};
                break;
            }
            case -2147483546: 
            case -2147483545: {
                RenameMemberCriteria renameMemberCriteria = (RenameMemberCriteria)searchCriteria;
                String string = renameMemberCriteria.getFqClassName() + "." + renameMemberCriteria.getMemberNameBefore();
                stringArray = new String[]{string};
                break;
            }
            case -2147483535: {
                MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
                stringArray = moveClassesCriteria.getFqOldClassesNames();
            }
        }
        if (stringArray != null) {
            MultiMap multiMap = new MultiMap();
            usageModel = this.findUsages(searchOperation, project, uRLArray, stringArray, multiMap);
            searchOperation.setProperty(KEYWORD_USAGES_KEY, multiMap);
        }
        return usageModel;
    }

    private String getNewName(SearchOperation searchOperation, String string) {
        String string2 = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483546: 
            case -2147483545: {
                RenameMemberCriteria renameMemberCriteria = (RenameMemberCriteria)searchCriteria;
                string2 = renameMemberCriteria.getFqClassName() + "." + renameMemberCriteria.getMemberNameAfter();
                break;
            }
            case -2147483535: {
                MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
                String[] stringArray = moveClassesCriteria.getFqOldClassesNames();
                int n2 = 0;
                while (string2 == null && n2 < stringArray.length) {
                    String string3 = stringArray[n2];
                    if (string.equals(string3)) {
                        String[] stringArray2 = moveClassesCriteria.getFqNewClassesNames();
                        string2 = stringArray2[n2];
                    }
                    ++n2;
                }
                break;
            }
        }
        return string2;
    }

    private HashSet chooseURLs(SearchOperationImpl searchOperationImpl, String[] stringArray, Project project, ProgressIndicator progressIndicator) {
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2 = stringArray[n];
            int n2 = string2.lastIndexOf(46);
            stringArray2[n] = string = string2.substring(n2 + 1);
            ++n;
        }
        HashSet hashSet = searchOperationImpl.getKeywordHits(contentSet, stringArray2, progressIndicator);
        HashSet<URL> hashSet2 = new HashSet<URL>(hashSet.size());
        for (URL uRL : hashSet) {
            if (!contentSet.canHaveMember(uRL)) continue;
            hashSet2.add(uRL);
        }
        return hashSet2;
    }

    private UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, String[] stringArray, MultiMap multiMap) {
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        Scope scope = TextURLHandler.getScope(searchOperation);
        UsageModel usageModel = new UsageModel();
        int n = 0;
        while (n < uRLArray.length) {
            Node node;
            URL uRL = uRLArray[n];
            if (scope.isValidPath(contentSet, uRL) && (node = NodeFactory.find((URL)uRL)) instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                String string = textBuffer.getString(0, textBuffer.getLength());
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string2 = stringArray[n2];
                    int n3 = 0;
                    while (n3 >= 0) {
                        if ((n3 = string.indexOf(string2, n3)) < 0) continue;
                        int n4 = string2.length();
                        int n5 = n3 + n4;
                        if (n5 < string.length() && !Character.isJavaIdentifierPart(string.charAt(n5))) {
                            UsageEntry usageEntry = UsageEntry.createEntry(project, uRL, n3, n4, 0);
                            usageModel.addUsageEntry(usageEntry);
                            multiMap.add((Object)string2, (Object)usageEntry);
                        }
                        n3 += string2.length();
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return usageModel;
    }

    private static Scope getScope(SearchOperation searchOperation) {
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        switch (searchCriteria.getSearchType()) {
            case 1: {
                return ((SearchClassCriteria)searchCriteria).getScope();
            }
            case 4: {
                return ((SearchConstructorCriteria)searchCriteria).getScope();
            }
            case 3: {
                return ((SearchFieldCriteria)searchCriteria).getScope();
            }
            case 2: {
                return ((SearchMethodCriteria)searchCriteria).getScope();
            }
        }
        return Scope.createDummyScope();
    }

    public static ArrayList genericRename(UsageModel usageModel, String string, String string2) {
        ArrayList<TextChange> arrayList = new ArrayList<TextChange>();
        ArrayList arrayList2 = usageModel.getUsageEntries();
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList2.get(n2);
            if (baseUsageEntry.isIncluded()) {
                URL uRL = baseUsageEntry.getURL();
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                    int n3 = baseUsageEntry.getOffset();
                    TextChange textChange = new TextChange(textNode, n3, string, string2);
                    arrayList.add(textChange);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static ArrayList genericRename(UsageModel usageModel, String string) {
        ArrayList arrayList = usageModel.getUsageEntries();
        ArrayList arrayList2 = TextURLHandler.genericRename(arrayList, string);
        return arrayList2;
    }

    private static ArrayList genericRename(List list, String string) {
        ArrayList<TextChange> arrayList = new ArrayList<TextChange>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)list.get(n2);
            if (baseUsageEntry.isIncluded()) {
                URL uRL = baseUsageEntry.getURL();
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                    int n3 = baseUsageEntry.getOffset();
                    int n4 = baseUsageEntry.getLength();
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    String string2 = textBuffer.getString(n3, n4);
                    TextChange textChange = new TextChange(textNode, n3, string2, string);
                    arrayList.add(textChange);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        ArrayList arrayList = new ArrayList();
        MultiMap multiMap = (MultiMap)searchOperation.getProperty(KEYWORD_USAGES_KEY);
        Set set = multiMap.keySet();
        for (String string : set) {
            List list = multiMap.get((Object)string);
            String string2 = this.getNewName(searchOperation, string);
            ArrayList arrayList2 = TextURLHandler.genericRename(list, string2);
            arrayList.addAll(arrayList2);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new RefactoringChange[arrayList.size()]);
    }
}

