/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightControler;
import oracle.jdevimpl.refactoring.highlight.HighlightMark;
import oracle.jdevimpl.refactoring.highlight.LanguageHighlighter;
import oracle.jdevimpl.refactoring.highlight.ParameterHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.AnnotationHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.ConstructorHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.MethodHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.PackageHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.ResolvedTypeHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.ReturnHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.SuperAspectHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.ThrowsHighlighter;
import oracle.jdevimpl.refactoring.highlight.highliters.VariableHighlighter;

public final class HighlighPlugin
implements Comparator,
EditorPlugin {
    private BasicEditorPane _editorPane;
    private HighlightLayer _highlightLayer;
    private ArrayList _languageHighlighters;
    private ArrayList _highlights;
    private static final String KEY = "CODEHIGHLIGHT";

    void $init$() {
        this._highlights = new ArrayList();
    }

    public void install(BasicEditorPane basicEditorPane) {
        Context context = (Context)basicEditorPane.getProperty("editor-ide-context");
        Node node = context.getNode();
        this._languageHighlighters = new ArrayList();
        HighlightControler highlightControler = HighlightControler.getInstance();
        List list = highlightControler.getLanguageHighlighters();
        int n = 0;
        while (n < list.size()) {
            LanguageHighlighter languageHighlighter = (LanguageHighlighter)list.get(n);
            if (languageHighlighter.canHighlight(node)) {
                languageHighlighter.attach(context);
                this._languageHighlighters.add(languageHighlighter);
            }
            ++n;
        }
        if (!this._languageHighlighters.isEmpty()) {
            this._editorPane = basicEditorPane;
            basicEditorPane.putProperty(KEY, (Object)this);
            highlightControler.add(this);
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        HighlightControler highlightControler = HighlightControler.getInstance();
        highlightControler.remove(this);
        int n = 0;
        while (n < this._languageHighlighters.size()) {
            LanguageHighlighter languageHighlighter = (LanguageHighlighter)this._languageHighlighters.get(n);
            languageHighlighter.detach();
            ++n;
        }
        if (this._editorPane != null) {
            basicEditorPane.putProperty(KEY, null);
            this._editorPane.destroyHighlightLayer(this._highlightLayer);
        }
        this._highlights.clear();
    }

    static HighlighPlugin getHighlighPlugin(BasicEditorPane basicEditorPane) {
        return (HighlighPlugin)basicEditorPane.getProperty(KEY);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    public void highlight(SourceElement sourceElement, String string) {
        this.highlight(sourceElement.getStartOffset(), sourceElement.getEndOffset(), string);
    }

    public void highlight(int n, int n2, String string) {
        int n3 = Collections.binarySearch(this._highlights, new Point(n, n2), this);
        if (n3 < 0) {
            HighlightStyle highlightStyle = HighlightControler.getInstance().getHighlightStyle();
            HighlightLayer highlightLayer = this.getHighlightLayer();
            HighlightedText highlightedText = highlightLayer.addHighlight(highlightStyle, n, n2);
            this._highlights.add(-n3 - 1, highlightedText);
            HighlightMark highlightMark = new HighlightMark(n, n2, string);
            Context context = (Context)this._editorPane.getProperty("editor-ide-context");
            CodeEditor codeEditor = (CodeEditor)context.getView();
            FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
            int n4 = codeEditor.getLineFromOffset(n);
            fileOverviewMargin.addMark("!codehighlight", n4, (FileOverviewMark)highlightMark);
        }
    }

    void clearHighlights() {
        if (this._highlightLayer != null) {
            this._highlightLayer.removeAllHighlights();
            Context context = (Context)this._editorPane.getProperty("editor-ide-context");
            CodeEditor codeEditor = (CodeEditor)context.getView();
            FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
            fileOverviewMargin.clearMarks("!codehighlight");
            this._highlights.clear();
            this._editorPane.destroyHighlightLayer(this._highlightLayer);
            this._highlightLayer = null;
        }
    }

    void highlightMethod(SourceFile sourceFile, JavaMethod javaMethod) {
        MethodHighlighter methodHighlighter = new MethodHighlighter(this, javaMethod);
        methodHighlighter.visit((SourceElement)sourceFile);
    }

    void highlightConstructor(SourceFile sourceFile, JavaMethod javaMethod) {
        ConstructorHighlighter constructorHighlighter = new ConstructorHighlighter(this, javaMethod);
        constructorHighlighter.visit((SourceElement)sourceFile);
    }

    void highlightVariable(SourceElement sourceElement, JavaHasName javaHasName) {
        VariableHighlighter variableHighlighter = new VariableHighlighter(this, javaHasName);
        variableHighlighter.visit(sourceElement);
    }

    public void highlightParameter(SourceMethod sourceMethod, SourceVariable sourceVariable) {
        ParameterHighlighter parameterHighlighter = new ParameterHighlighter(this, sourceMethod, sourceVariable);
        parameterHighlighter.visit((SourceElement)sourceMethod.getOwningSourceFile());
    }

    public void highlightThrows(SourceElement sourceElement, JavaType javaType) {
        ThrowsHighlighter throwsHighlighter = new ThrowsHighlighter(this, javaType);
        throwsHighlighter.visit(sourceElement);
    }

    public void highlightThrows(SourceElement sourceElement, JavaType[] javaTypeArray) {
        ThrowsHighlighter throwsHighlighter = new ThrowsHighlighter(this, javaTypeArray);
        throwsHighlighter.visit(sourceElement);
    }

    public void highlightReturns(SourceMethod sourceMethod) {
        ReturnHighlighter returnHighlighter = new ReturnHighlighter(this, sourceMethod);
        returnHighlighter.visit((SourceElement)sourceMethod);
    }

    public void highlightResolvedTypes(SourceFile sourceFile, JavaType[] javaTypeArray) {
        ResolvedTypeHighlighter resolvedTypeHighlighter = new ResolvedTypeHighlighter(this, javaTypeArray);
        resolvedTypeHighlighter.visit((SourceElement)sourceFile);
    }

    public void highlightPackage(SourceFile sourceFile, JavaPackage javaPackage) {
        PackageHighlighter packageHighlighter = new PackageHighlighter(this, javaPackage);
        packageHighlighter.visit((SourceElement)sourceFile);
    }

    public void highlightSuperAspect(SourceClass sourceClass, JavaType javaType) {
        SuperAspectHighlighter superAspectHighlighter = new SuperAspectHighlighter(this, (JavaType)sourceClass, javaType);
        superAspectHighlighter.visit((SourceElement)sourceClass);
    }

    public void highlightClassDeclarations(SourceFile sourceFile) {
        TextBuffer textBuffer = sourceFile.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        List list = SourceElementAsList.asList((SourceElement)sourceFile);
        int n = 0;
        while (n < list.size()) {
            SourceClass sourceClass;
            SourceName sourceName;
            SourceElement sourceElement = (SourceElement)list.get(n);
            if (sourceElement.getSymbolKind() == 3 && (sourceName = (sourceClass = (SourceClass)sourceElement).getNameElement()) != null) {
                int n2 = sourceName.getStartOffset();
                int n3 = lineMap.getLineFromOffset(n2);
                int n4 = lineMap.getLineStartOffset(n3);
                int n5 = lineMap.getLineEndOffset(n3);
                String string = MessageFormat.format(RefactoringArb.getString(178), sourceName.getText());
                this.highlight(n4, n5, string);
            }
            ++n;
        }
    }

    public void highlightAnnotation(SourceFile sourceFile, JavaType javaType) {
        AnnotationHighlighter annotationHighlighter = new AnnotationHighlighter(this, javaType);
        annotationHighlighter.visit((SourceElement)sourceFile);
    }

    public int compare(Object object, Object object2) {
        int n;
        int n2 = HighlighPlugin.getStartValue(object);
        int n3 = n2 - (n = HighlighPlugin.getStartValue(object2));
        if (n3 != 0) {
            return n3;
        }
        int n4 = HighlighPlugin.getEndValue(object);
        int n5 = HighlighPlugin.getEndValue(object2);
        int n6 = n4 + n5;
        return n6;
    }

    private static int getStartValue(Object object) {
        int n;
        if (object instanceof HighlightedText) {
            HighlightedText highlightedText = (HighlightedText)object;
            n = highlightedText.getStartOffset();
        } else if (object instanceof Integer) {
            Integer n2 = (Integer)object;
            n = n2;
        } else if (object instanceof Point) {
            Point point = (Point)object;
            n = point.x;
        } else {
            n = 0;
        }
        return n;
    }

    private static int getEndValue(Object object) {
        int n;
        if (object instanceof HighlightedText) {
            HighlightedText highlightedText = (HighlightedText)object;
            n = highlightedText.getEndOffset();
        } else if (object instanceof Integer) {
            Integer n2 = (Integer)object;
            n = n2;
        } else if (object instanceof Point) {
            Point point = (Point)object;
            n = point.y;
        } else {
            n = 0;
        }
        return n;
    }

    public void whenHighlight(Context context, BasicEditorPane basicEditorPane) {
        int n = basicEditorPane.getSelectionStart();
        int n2 = basicEditorPane.getSelectionEnd();
        int n3 = 0;
        while (n3 < this._languageHighlighters.size()) {
            LanguageHighlighter languageHighlighter = (LanguageHighlighter)this._languageHighlighters.get(n3);
            languageHighlighter.highlight(context, this, n, n2);
            ++n3;
        }
    }

    public boolean hasHighlights() {
        return this._highlights.isEmpty() ^ true;
    }

    public boolean getHighlightAfter(int n, int[] nArray) {
        int n2 = Collections.binarySearch(this._highlights, new Integer(n), this);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        while (n2 < this._highlights.size()) {
            HighlightedText highlightedText = (HighlightedText)this._highlights.get(n2);
            int n3 = highlightedText.getStartOffset();
            if (n3 > n) {
                nArray[0] = n3;
                nArray[1] = highlightedText.getEndOffset();
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean getHighlightBefore(int n, int[] nArray) {
        int n2 = Collections.binarySearch(this._highlights, new Integer(n), this);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        while (--n2 >= 0) {
            HighlightedText highlightedText = (HighlightedText)this._highlights.get(n2);
            int n3 = highlightedText.getStartOffset();
            if (n3 >= n) continue;
            nArray[0] = n3;
            nArray[1] = highlightedText.getEndOffset();
            return true;
        }
        return false;
    }

    public HighlighPlugin() {
        this.$init$();
    }
}

