/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.find.FindNavigator;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.find.NavigableHighlighter;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.JavaHighlighter;
import oracle.jdevimpl.refactoring.highlight.LanguageHighlighter;

public class HighlightControler
implements NavigableHighlighter,
Controller,
EditorPluginsFactory {
    private static HighlightControler INSTANCE;
    private final HighlightStyle _highlightStyle;
    private static int _highlightCmdId;
    private ArrayList _installedPlugins;
    static final String MARK_CATEGORY = "!codehighlight";
    private ArrayList _languageHighlighters;

    void $init$() {
        this._installedPlugins = new ArrayList();
        this._languageHighlighters = new ArrayList();
    }

    private HighlightControler() {
        this.$init$();
        this._highlightStyle = CodeEditor.createHighlightStyle((String)this.getClass().getName(), (String)"Code Highlight", (int)75, null, (Color)Color.YELLOW);
        FileOverviewMargin.setMarkColor((String)MARK_CATEGORY, (HighlightStyle)this._highlightStyle);
        this.createActions();
        this.registerHighlighter(new JavaHighlighter());
        FindNavigator.getFindNavigator().registerNavigableHighlighter((NavigableHighlighter)this);
    }

    public void registerHighlighter(LanguageHighlighter languageHighlighter) {
        this._languageHighlighters.add(languageHighlighter);
    }

    public void unregisterHighlighter(LanguageHighlighter languageHighlighter) {
        this._languageHighlighters.remove(languageHighlighter);
    }

    public List getLanguageHighlighters() {
        return Collections.unmodifiableList(this._languageHighlighters);
    }

    public static void createInstance() {
        INSTANCE = new HighlightControler();
        CodeEditor.registerFactory((EditorPluginsFactory)INSTANCE);
    }

    private void createActions() {
        _highlightCmdId = Ide.findOrCreateCmdID((String)"Highlight.HIGHLIGHT_CMD_ID");
        String string = RefactoringArb.getString(18);
        String string2 = StringUtils.stripMnemonic((String)string);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        IdeAction ideAction = IdeAction.get((int)_highlightCmdId, null, (String)string2, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)new Integer(n), (ArrayResourceBundle)RefactoringArb.getInstance(), (int)19, null, (boolean)false);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        if (menubar != null) {
            float f = JDeveloperMenuConstants.increment((float)JDeveloperMenuConstants.WEIGHT_SEARCH_REPLACE);
            JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, f);
            JMenu jMenu = MenuManager.getJMenu((String)"Search");
            menubar.add((Component)jMenuItem, jMenu, 1.0f);
        }
    }

    public static HighlightControler getInstance() {
        return INSTANCE;
    }

    public List createPlugins(Context context) {
        ArrayList<HighlighPlugin> arrayList = new ArrayList<HighlighPlugin>(1);
        arrayList.add(new HighlighPlugin());
        return arrayList;
    }

    public HighlightStyle getHighlightStyle() {
        return this._highlightStyle;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == _highlightCmdId) {
            this.handle(context, true);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == _highlightCmdId) {
            boolean bl = this.handle(context, false);
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    private boolean handle(Context context, boolean bl) {
        HighlighPlugin highlighPlugin;
        FindableEditor findableEditor;
        BasicEditorPane basicEditorPane;
        View view;
        boolean bl2 = false;
        if (context.getProject() != null && (view = context.getView()) instanceof FindableEditor && (basicEditorPane = (findableEditor = (FindableEditor)view).getFocusedEditorPane()) != null && (highlighPlugin = HighlighPlugin.getHighlighPlugin(basicEditorPane)) != null) {
            if (bl) {
                highlighPlugin.whenHighlight(context, basicEditorPane);
                FindNavigator.getFindNavigator().setSearchHighlightMode(true);
            }
            bl2 = true;
        }
        return bl2;
    }

    public void add(HighlighPlugin highlighPlugin) {
        this._installedPlugins.add(highlighPlugin);
    }

    public void remove(HighlighPlugin highlighPlugin) {
        this._installedPlugins.remove(highlighPlugin);
    }

    public boolean hasHighlights(BasicEditorPane basicEditorPane) {
        boolean bl = false;
        HighlighPlugin highlighPlugin = HighlighPlugin.getHighlighPlugin(basicEditorPane);
        if (highlighPlugin != null && highlighPlugin.hasHighlights()) {
            bl = true;
        }
        return bl;
    }

    public void clearHighlights(BasicEditorPane basicEditorPane) {
        HighlighPlugin highlighPlugin = HighlighPlugin.getHighlighPlugin(basicEditorPane);
        if (highlighPlugin != null) {
            highlighPlugin.clearHighlights();
        }
    }

    public boolean getHighlightAfter(BasicEditorPane basicEditorPane, int n, int[] nArray) {
        boolean bl = false;
        HighlighPlugin highlighPlugin = HighlighPlugin.getHighlighPlugin(basicEditorPane);
        if (highlighPlugin != null && highlighPlugin.getHighlightAfter(n, nArray)) {
            bl = true;
        }
        return bl;
    }

    public boolean getHighlightBefore(BasicEditorPane basicEditorPane, int n, int[] nArray) {
        boolean bl = false;
        HighlighPlugin highlighPlugin = HighlighPlugin.getHighlighPlugin(basicEditorPane);
        if (highlighPlugin != null && highlighPlugin.getHighlightBefore(n, nArray)) {
            bl = true;
        }
        return bl;
    }
}

