/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.LanguageHighlighter;
import oracle.jdevimpl.refactoring.highlight.SourceVisitor;
import oracle.jdevimpl.refactoring.util.Visitor;

public class JavaHighlighter
extends LanguageHighlighter {
    public boolean canHighlight(Node node) {
        return node instanceof JavaSourceNode;
    }

    public void highlight(Context context, HighlighPlugin highlighPlugin, int n, int n2) {
        JavaSourceNode javaSourceNode = (JavaSourceNode)context.getNode();
        if (n == n2) {
            this.whenHighlight(context, highlighPlugin, javaSourceNode, n);
        } else {
            TextBuffer textBuffer = javaSourceNode.acquireTextBuffer();
            String string = textBuffer.getString(0, textBuffer.getLength());
            String string2 = string.substring(n, n2);
            this.highlightText(highlighPlugin, string, string2);
        }
    }

    private void highlightText(HighlighPlugin highlighPlugin, String string, String string2) {
        int n = string2.length();
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) != -1) {
            String string3 = MessageFormat.format(RefactoringArb.getString(172), string2);
            highlighPlugin.highlight(n2, n2 + n, string3);
            ++n2;
        }
    }

    private void whenHighlight(Context context, HighlighPlugin highlighPlugin, JavaSourceNode javaSourceNode, int n) {
        URL uRL;
        JavaManager javaManager;
        SourceFile sourceFile;
        Project project = context.getProject();
        if (project != null && (sourceFile = (javaManager = JavaManager.getJavaManager(project)).getSourceFile(uRL = javaSourceNode.getURL())) != null) {
            sourceFile.compile();
            SourceVisitor sourceVisitor = new SourceVisitor(highlighPlugin, sourceFile, n);
            ((Visitor)sourceVisitor).visit((SourceElement)sourceFile);
        }
    }
}

