/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.VariableHighlighter;

public class ParameterHighlighter
extends VariableHighlighter {
    private SourceMethod _sourceMethod;
    private int _paramPos;
    private final boolean _isConstructor;

    public ParameterHighlighter(HighlighPlugin highlighPlugin, SourceMethod sourceMethod, SourceVariable sourceVariable) {
        super(highlighPlugin, (JavaHasName)sourceVariable);
        this._sourceMethod = sourceMethod;
        this._paramPos = sourceMethod.getSourceParameters().indexOf(sourceVariable);
        this._isConstructor = this._sourceMethod.isConstructor();
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        String string;
        String string2;
        if (!this._isConstructor && (string2 = this._sourceMethod.getName()).equals(string = sourceMethodCallExpression.getName())) {
            this.check((SourceInvokeExpression)sourceMethodCallExpression);
        }
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
        if (this._isConstructor) {
            this.check((SourceInvokeExpression)sourceNewClassExpression);
        }
    }

    private void check(SourceInvokeExpression sourceInvokeExpression) {
        SourceExpression sourceExpression;
        JavaMethod javaMethod = sourceInvokeExpression.getResolvedMethod();
        if (this._sourceMethod.equals(javaMethod) && (sourceExpression = sourceInvokeExpression.getArgumentAt(this._paramPos)) != null) {
            this.highlight((SourceElement)sourceExpression, RefactoringArb.getString(173));
        }
    }
}

