/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.Visitor;

class SourceVisitor
extends Visitor {
    private final SourceFile _sourceFile;
    private final int _caretPos;
    private HighlighPlugin _highlighPlugin;

    public SourceVisitor(HighlighPlugin highlighPlugin, SourceFile sourceFile, int n) {
        this._highlighPlugin = highlighPlugin;
        this._sourceFile = sourceFile;
        this._caretPos = n;
    }

    public void visit(SourceElement sourceElement) {
        if (Patch.contains(sourceElement, this._caretPos)) {
            super.visit(sourceElement);
        }
    }

    private SourceElement getScope(SourceVariable sourceVariable) {
        SourceElement sourceElement;
        switch (sourceVariable.getSymbolKind()) {
            case 17: {
                SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceVariable;
                sourceElement = sourceLocalVariable.getOwningBlock();
                break;
            }
            case 13: {
                sourceElement = Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
                break;
            }
            default: {
                sourceElement = null;
            }
        }
        return sourceElement;
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        SourceName sourceName = sourceMethodCallExpression.getNameElement();
        if (Patch.contains((SourceElement)sourceName, this._caretPos)) {
            JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
            if (javaMethod != null) {
                this._highlighPlugin.highlightMethod(this._sourceFile, javaMethod);
            }
            this.cancel();
        }
    }

    protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
        SourceName sourceName = sourceMethod.getNameElement();
        if (sourceName != null && Patch.contains((SourceElement)sourceName, this._caretPos)) {
            this._highlighPlugin.highlightMethod(this._sourceFile, (JavaMethod)sourceMethod);
            this.cancel();
        } else {
            SourceTypeReference sourceTypeReference = sourceMethod.getSourceReturnType();
            if (sourceTypeReference != null && Patch.contains((SourceElement)sourceTypeReference, this._caretPos)) {
                this._highlighPlugin.highlightReturns(sourceMethod);
                this.cancel();
            }
        }
    }

    protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
        SourceName sourceName = sourceMethod.getNameElement();
        if (sourceName != null && Patch.contains((SourceElement)sourceName, this._caretPos)) {
            this._highlighPlugin.highlightConstructor(this._sourceFile, (JavaMethod)sourceMethod);
            this.cancel();
        }
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
        JavaMethod javaMethod;
        SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
        if (sourceTypeReference != null && Patch.contains((SourceElement)sourceTypeReference, this._caretPos) && (javaMethod = sourceNewClassExpression.getResolvedMethod()) != null) {
            this._highlighPlugin.highlightConstructor(this._sourceFile, javaMethod);
            this.cancel();
        }
    }

    protected void whenEnterClass(SourceClass sourceClass) {
        block1: {
            int n;
            int n2;
            SourceName sourceName;
            block2: {
                sourceName = sourceClass.getNameElement();
                if (sourceName == null) break block1;
                if (!Patch.contains((SourceElement)sourceName, this._caretPos)) break block2;
                JavaType[] javaTypeArray = new JavaType[]{sourceClass};
                this._highlighPlugin.highlightResolvedTypes(this._sourceFile, javaTypeArray);
                this.cancel();
                break block1;
            }
            if (this._caretPos >= sourceName.getStartOffset()) break block1;
            JavaLexer javaLexer = new JavaLexer();
            javaLexer.setTextBuffer((ReadTextBuffer)sourceClass.getOwningSourceFile().getTextBuffer());
            javaLexer.setPosition(sourceClass.getStartOffset());
            do {
                n = javaLexer.lex();
                int n3 = javaLexer.getStartOffset();
                n2 = javaLexer.getEndOffset();
                if (this._caretPos < n3) break block1;
            } while (this._caretPos > n2 || n != 103);
            this._highlighPlugin.highlightClassDeclarations(this._sourceFile);
            this.cancel();
        }
    }

    protected void whenEnterThrowsClause(SourceThrowsClause sourceThrowsClause) {
        boolean bl = false;
        List list = sourceThrowsClause.getSourceExceptions();
        int n = 0;
        while (!bl && n < list.size()) {
            SourceTypeReference sourceTypeReference = (SourceTypeReference)list.get(n);
            if (Patch.contains((SourceElement)sourceTypeReference, this._caretPos)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
            int n2 = 0;
            while (n2 < list.size()) {
                SourceTypeReference sourceTypeReference = (SourceTypeReference)list.get(n2);
                JavaType javaType = sourceTypeReference.getResolvedType();
                arrayList.add(javaType);
                ++n2;
            }
            SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceThrowsClause);
            JavaType[] javaTypeArray = arrayList.toArray(new JavaType[arrayList.size()]);
            this._highlighPlugin.highlightThrows((SourceElement)sourceMethod, javaTypeArray);
            this._highlighPlugin.highlight((SourceElement)sourceThrowsClause, RefactoringArb.getString(174));
            this.cancel();
        }
    }

    protected void whenEnterCatchStatement(SourceCatchClause sourceCatchClause) {
        SourceVariable sourceVariable = sourceCatchClause.getCatchVariable();
        try {
            SourceStatement sourceStatement;
            SourceName sourceName = sourceVariable.getNameElement();
            if (!Patch.contains((SourceElement)sourceName, this._caretPos) && !Patch.contains((SourceElement)(sourceStatement = sourceCatchClause.getPrimaryClause()), this._caretPos)) {
                SourceTypeReference sourceTypeReference = sourceVariable.getSourceType();
                JavaType javaType = sourceTypeReference.getResolvedType();
                SourceTryStatement sourceTryStatement = sourceCatchClause.getOwningTry();
                SourceStatement sourceStatement2 = sourceTryStatement.getPrimaryClause();
                this._highlighPlugin.highlightThrows((SourceElement)sourceStatement2, javaType);
                SourceElement sourceElement = sourceVariable.getParent();
                String string = MessageFormat.format(RefactoringArb.getString(175), javaType.getQualifiedName());
                this._highlighPlugin.highlight(sourceCatchClause.getStartOffset(), sourceElement.getEndOffset(), string);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
        if (javaHasType != null) {
            switch (javaHasType.getElementKind()) {
                case 5: {
                    JavaField javaField = (JavaField)javaHasType;
                    this._highlighPlugin.highlightVariable((SourceElement)this._sourceFile, (JavaHasName)javaField);
                    this.cancel();
                    break;
                }
                case 7: {
                    SourceElement sourceElement;
                    JavaLocalVariable javaLocalVariable = (JavaLocalVariable)javaHasType;
                    SourceVariable sourceVariable = (SourceVariable)javaLocalVariable.getSourceElement();
                    if (sourceVariable != null && (sourceElement = this.getScope(sourceVariable)) != null) {
                        this._highlighPlugin.highlightVariable(sourceElement, (JavaHasName)sourceVariable);
                    }
                    this.cancel();
                    break;
                }
                case 3: {
                    JavaClass javaClass = (JavaClass)javaHasType;
                    this._highlighPlugin.highlightResolvedTypes(this._sourceFile, new JavaType[]{javaClass});
                }
            }
        }
    }

    protected void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
        SourceName sourceName = sourceLocalVariable.getNameElement();
        if (Patch.contains((SourceElement)sourceName, this._caretPos)) {
            SourceElement sourceElement = this.getScope((SourceVariable)sourceLocalVariable);
            if (sourceElement != null) {
                this._highlighPlugin.highlightVariable(sourceElement, (JavaHasName)sourceLocalVariable);
            }
            this.cancel();
        }
    }

    protected void whenEnterFormalParameter(SourceVariable sourceVariable) {
        SourceName sourceName = sourceVariable.getNameElement();
        if (Patch.contains((SourceElement)sourceName, this._caretPos)) {
            SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
            this._highlighPlugin.highlightParameter(sourceMethod, sourceVariable);
            this.cancel();
        }
    }

    protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
        SourceName sourceName = sourceFieldVariable.getNameElement();
        if (Patch.contains((SourceElement)sourceName, this._caretPos)) {
            SourceFile sourceFile = sourceFieldVariable.getOwningSourceFile();
            this._highlighPlugin.highlightVariable((SourceElement)sourceFile, (JavaHasName)sourceFieldVariable);
            this.cancel();
        }
    }

    protected void whenEnterReturnStatement(SourceReturnStatement sourceReturnStatement) {
        SourceExpression sourceExpression = sourceReturnStatement.getExpression();
        if (sourceExpression == null || !Patch.contains((SourceElement)sourceExpression, this._caretPos)) {
            SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceReturnStatement);
            this._highlighPlugin.highlightReturns(sourceMethod);
            this.cancel();
        }
    }

    protected void whenEnterTypeRef(SourceTypeReference sourceTypeReference) {
        SourceElement sourceElement = sourceTypeReference.getParent();
        switch (sourceElement.getSymbolKind()) {
            case 15: 
            case 23: {
                this.highlightSuperAspect(sourceTypeReference);
                break;
            }
            case 25: {
                SourceMethod sourceMethod;
                JavaType javaType = sourceTypeReference.getResolvedType();
                if (javaType == null || (sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceTypeReference)) == null) break;
                this._highlighPlugin.highlightThrows((SourceElement)sourceMethod, javaType);
                String string = MessageFormat.format(RefactoringArb.getString(350), javaType.getQualifiedName());
                this._highlighPlugin.highlight((SourceElement)sourceTypeReference, string);
                this.cancel();
                break;
            }
            default: {
                JavaType javaType = sourceTypeReference.getResolvedType();
                if (javaType == null) break;
                this._highlighPlugin.highlightResolvedTypes(this._sourceFile, new JavaType[]{javaType});
                this.cancel();
            }
        }
    }

    protected void whenEnterImportDeclaration(SourceImport sourceImport) {
        if (!sourceImport.isStatic()) {
            String string = sourceImport.getName();
            if (string.endsWith(".*")) {
                String string2 = string.substring(0, string.length() - 2);
                JavaProvider javaProvider = this._sourceFile.getProvider();
                JavaPackage javaPackage = javaProvider.getPackage(string2);
                this._highlighPlugin.highlightPackage(this._sourceFile, javaPackage);
            } else {
                SourceFile sourceFile = sourceImport.getOwningSourceFile();
                JavaProvider javaProvider = sourceFile.getProvider();
                JavaClass javaClass = javaProvider.getClass(string);
                this._highlighPlugin.highlightResolvedTypes(this._sourceFile, new JavaType[]{javaClass});
            }
        }
        this.cancel();
    }

    protected void whenEnterAnnotation(SourceAnnotation sourceAnnotation) {
        JavaType javaType;
        SourceName sourceName = sourceAnnotation.getNameElement();
        if (Patch.contains((SourceElement)sourceName, this._caretPos) && (javaType = sourceAnnotation.getResolvedType()) != null) {
            this._highlighPlugin.highlightAnnotation(this._sourceFile, javaType);
        }
    }

    private void highlightSuperAspect(SourceTypeReference sourceTypeReference) {
        JavaType javaType = sourceTypeReference.getResolvedType();
        if (javaType != null) {
            SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceTypeReference);
            String string = MessageFormat.format(RefactoringArb.getString(176), javaType.getName(), sourceClass.getName());
            this._highlighPlugin.highlight((SourceElement)sourceTypeReference, string);
            this._highlighPlugin.highlightSuperAspect(sourceClass, javaType);
            this.cancel();
        }
    }
}

