/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.DefaultHighlighter;

public class ConstructorHighlighter
extends DefaultHighlighter {
    private JavaMethod _searchedMethod;
    private String _fullMethodName;
    private JavaType[] _javaTypes;

    public ConstructorHighlighter(HighlighPlugin highlighPlugin, JavaMethod javaMethod) {
        super(highlighPlugin);
        this._searchedMethod = javaMethod;
        this._fullMethodName = Util.getFullMethodName(this._searchedMethod, false, false, false);
        JavaClass javaClass = this._searchedMethod.getOwningClass();
        this._javaTypes = new JavaType[]{javaClass};
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
        JavaMethod javaMethod = sourceNewClassExpression.getResolvedMethod();
        if (this._searchedMethod.equals((Object)javaMethod)) {
            SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
            String string = MessageFormat.format(RefactoringArb.getString(177), this._fullMethodName);
            this.highlight((SourceElement)sourceTypeReference, string);
        }
    }

    protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
        if (this._searchedMethod.equals((Object)sourceMethod)) {
            SourceName sourceName = sourceMethod.getNameElement();
            String string = MessageFormat.format(RefactoringArb.getString(178), this._fullMethodName);
            this.highlight((SourceElement)sourceName, string);
        }
    }
}

