/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.DefaultHighlighter;

public class MethodHighlighter
extends DefaultHighlighter {
    private String _searchedMethodName;
    private JavaMethod _searchedMethod;
    private String _fullMethodName;

    public MethodHighlighter(HighlighPlugin highlighPlugin, JavaMethod javaMethod) {
        super(highlighPlugin);
        this._searchedMethod = javaMethod;
        this._searchedMethodName = javaMethod.getName();
        this._fullMethodName = Util.getFullMethodName(javaMethod, true, false, false);
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        JavaMethod javaMethod;
        String string = sourceMethodCallExpression.getName();
        if (this._searchedMethodName.equals(string) && (javaMethod = sourceMethodCallExpression.getResolvedMethod()) != null && this._searchedMethod.equals((Object)javaMethod)) {
            SourceName sourceName = sourceMethodCallExpression.getNameElement();
            String string2 = MessageFormat.format(RefactoringArb.getString(177), this._fullMethodName);
            this.highlight((SourceElement)sourceName, string2);
        }
    }

    protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
        String string = sourceMethod.getName();
        if (this._searchedMethodName.equals(string) && this._searchedMethod.equals((Object)sourceMethod)) {
            SourceName sourceName = sourceMethod.getNameElement();
            String string2 = MessageFormat.format(RefactoringArb.getString(178), this._fullMethodName);
            this.highlight((SourceElement)sourceName, string2);
        }
    }
}

