/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.TypeHighlighter;

public class PackageHighlighter
extends TypeHighlighter {
    private String _packageName;
    private String _packageNameDot;

    public PackageHighlighter(HighlighPlugin highlighPlugin, JavaPackage javaPackage) {
        super(highlighPlugin);
        this._packageName = javaPackage.getName();
        this._packageNameDot = this._packageName + '.';
    }

    protected boolean matches(SourceTypeReference sourceTypeReference) {
        JavaType javaType = sourceTypeReference.getResolvedType();
        if (javaType != null) {
            String string = javaType.getPackageName();
            if (this._packageName.equals(string)) {
                return true;
            }
            if (string.startsWith(this._packageNameDot)) {
                return true;
            }
        }
        return false;
    }

    protected void whenEnterImportDeclaration(SourceImport sourceImport) {
        String string;
        if (!sourceImport.isStatic() && (string = sourceImport.getName()).startsWith(this._packageNameDot)) {
            SourceName sourceName = sourceImport.getNameElement();
            String string2 = MessageFormat.format(RefactoringArb.getString(351), this._packageName);
            this.highlight((SourceElement)sourceName, string2);
        }
    }
}

