/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.TypeHighlighter;

public class ResolvedTypeHighlighter
extends TypeHighlighter {
    private JavaType[] _javaTypes;
    private String[] _shortNames;

    public ResolvedTypeHighlighter(HighlighPlugin highlighPlugin, JavaType javaType) {
        this(highlighPlugin, new JavaType[]{javaType});
    }

    public ResolvedTypeHighlighter(HighlighPlugin highlighPlugin, JavaType[] javaTypeArray) {
        super(highlighPlugin);
        this._javaTypes = javaTypeArray;
        this._shortNames = new String[javaTypeArray.length];
        int n = 0;
        while (n < javaTypeArray.length) {
            JavaType javaType = javaTypeArray[n];
            this._shortNames[n] = javaType.getName();
            ++n;
        }
    }

    protected boolean matches(SourceTypeReference sourceTypeReference) {
        String string = sourceTypeReference.getName();
        int n = 0;
        while (n < this._shortNames.length) {
            JavaType javaType;
            String string2 = this._shortNames[n];
            if (string.endsWith(string2) && this.matches(javaType = sourceTypeReference.getResolvedType())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean matches(JavaType javaType) {
        int n = 0;
        while (n < this._javaTypes.length) {
            JavaType javaType2 = this._javaTypes[n];
            if (javaType2.equals((Object)javaType)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
        JavaClass javaClass = sourceMethod.getOwningClass();
        if (this.matches((JavaType)javaClass)) {
            SourceName sourceName = sourceMethod.getNameElement();
            String string = MessageFormat.format(RefactoringArb.getString(355), javaClass.getQualifiedName());
            this.highlight((SourceElement)sourceName, string);
        }
    }

    protected void whenEnterClass(SourceClass sourceClass) {
        if (this.matches((JavaType)sourceClass)) {
            SourceName sourceName = sourceClass.getNameElement();
            String string = MessageFormat.format(RefactoringArb.getString(178), sourceClass.getQualifiedName());
            this.highlight((SourceElement)sourceName, string);
        }
    }

    protected void whenEnterImportDeclaration(SourceImport sourceImport) {
        this.checkImportDeclaration(sourceImport, this._javaTypes);
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
        if (javaHasType != null) {
            switch (javaHasType.getElementKind()) {
                case 3: {
                    JavaClass javaClass = (JavaClass)javaHasType;
                    if (!this.matches((JavaType)javaClass)) break;
                    String string = MessageFormat.format(RefactoringArb.getString(351), javaClass.getQualifiedName());
                    this.highlight((SourceElement)sourceSimpleNameExpression, string);
                }
            }
        }
    }
}

