/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.DefaultHighlighter;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class SuperAspectHighlighter
extends DefaultHighlighter {
    private JavaType _javaType;
    private JavaType _superType;

    public SuperAspectHighlighter(HighlighPlugin highlighPlugin, JavaType javaType, JavaType javaType2) {
        super(highlighPlugin);
        this._javaType = javaType;
        this._superType = javaType2;
    }

    protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
        JavaType[] javaTypeArray;
        String string = sourceMethod.getName();
        JavaMethod javaMethod = this._superType.getMethod(string, javaTypeArray = Patch.getParameterTypes((JavaMethod)sourceMethod));
        if (javaMethod != null) {
            SourceName sourceName = sourceMethod.getNameElement();
            String string2 = Util.getFullMethodName(javaMethod, false, false, false);
            String string3 = MessageFormat.format(RefactoringArb.getString(352), this._superType.getQualifiedName(), string2);
            this.highlight((SourceElement)sourceName, string3);
        }
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
        if (javaMethod != null) {
            JavaType[] javaTypeArray = javaMethod.getParameterTypes();
            JavaMethod javaMethod2 = this._superType.getMethod(javaMethod.getName(), javaTypeArray);
            if (javaMethod2 != null) {
                SourceName sourceName = sourceMethodCallExpression.getNameElement();
                this.highlightUsedAs((SourceElement)sourceName);
            } else {
                int n = 0;
                while (n < javaTypeArray.length) {
                    String string;
                    SourceExpression sourceExpression;
                    JavaType javaType;
                    JavaType javaType2 = javaTypeArray[n];
                    if (!"java.lang.Object".equals(javaType2.getQualifiedName()) && javaType2.isAssignableFrom(this._superType) && (javaType = (sourceExpression = sourceMethodCallExpression.getArgumentAt(n)).getResolvedType()) != null && !"null".equals(string = javaType.getQualifiedName()) && this._javaType.isAssignableFrom(javaType)) {
                        this.highlightUsedAs((SourceElement)sourceExpression);
                    }
                    ++n;
                }
            }
        }
    }

    protected void whenEnterAssignmentExpression(SourceAssignmentExpression sourceAssignmentExpression) {
        SourceExpression sourceExpression = sourceAssignmentExpression.getFirstOperand();
        JavaType javaType = sourceExpression.getResolvedType();
        SourceExpression sourceExpression2 = sourceAssignmentExpression.getSecondOperand();
        this.checkAssign(javaType, sourceExpression2);
    }

    protected void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
        JavaType javaType = sourceLocalVariable.getResolvedType();
        SourceExpression sourceExpression = sourceLocalVariable.getInitializer();
        this.checkAssign(javaType, sourceExpression);
    }

    protected void whenEnterReturnStatement(SourceReturnStatement sourceReturnStatement) {
        SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceReturnStatement);
        JavaType javaType = sourceMethod.getReturnType();
        SourceExpression sourceExpression = sourceReturnStatement.getExpression();
        this.checkAssign(javaType, sourceExpression);
    }

    private void checkAssign(JavaType javaType, SourceExpression sourceExpression) {
        JavaType javaType2;
        if (javaType != null && sourceExpression != null && javaType.isAssignableFrom(this._superType) && !javaType.isAssignableFrom(this._javaType) && (javaType2 = sourceExpression.getResolvedType()) != null && this._javaType.isAssignableFrom(javaType2)) {
            this.highlightUsedAs((SourceElement)sourceExpression);
            this.skipChildren();
        }
    }

    private void highlightUsedAs(SourceElement sourceElement) {
        String string = MessageFormat.format(RefactoringArb.getString(353), this._javaType.getName(), this._superType.getName());
        this.highlight(sourceElement, string);
    }
}

