/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.DefaultHighlighter;

public class ThrowsHighlighter
extends DefaultHighlighter {
    private SourceElement _highlightSource;
    private JavaType[] _javaTypes;

    public ThrowsHighlighter(HighlighPlugin highlighPlugin, JavaType javaType) {
        this(highlighPlugin, new JavaType[]{javaType});
    }

    public ThrowsHighlighter(HighlighPlugin highlighPlugin, JavaType[] javaTypeArray) {
        super(highlighPlugin);
        this._javaTypes = javaTypeArray;
    }

    private boolean isSearchedType(JavaType javaType) {
        if (javaType != null) {
            int n = 0;
            while (n < this._javaTypes.length) {
                JavaType javaType2 = this._javaTypes[n];
                if (javaType2.isAssignableFrom(javaType)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        SourceName sourceName = sourceMethodCallExpression.getNameElement();
        JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
        this.checkMethod(sourceName, javaMethod);
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
        SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
        SourceName sourceName = sourceTypeReference.getNameElement();
        JavaMethod javaMethod = sourceNewClassExpression.getResolvedMethod();
        this.checkMethod(sourceName, javaMethod);
    }

    private void checkMethod(SourceName sourceName, JavaMethod javaMethod) {
        if (javaMethod != null) {
            Collection collection = javaMethod.getExceptions();
            for (JavaType javaType : collection) {
                if (!this.isSearchedType(javaType)) continue;
                this.highlight((SourceElement)sourceName, "throws " + javaType.getQualifiedName());
            }
        }
    }

    protected void whenEnterTryStatement(SourceTryStatement sourceTryStatement) {
        List list = sourceTryStatement.getCatchClauses();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            JavaType javaType;
            SourceTypeReference sourceTypeReference;
            SourceCatchClause sourceCatchClause = (SourceCatchClause)iterator.next();
            SourceVariable sourceVariable = sourceCatchClause.getCatchVariable();
            if (sourceVariable == null || (sourceTypeReference = sourceVariable.getSourceType()) == null || !this.isSearchedType(javaType = sourceTypeReference.getResolvedType())) continue;
            bl = true;
        }
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                SourceCatchClause sourceCatchClause = (SourceCatchClause)list.get(n);
                this.visitChildren((SourceElement)sourceCatchClause);
                ++n;
            }
            SourceFinallyClause sourceFinallyClause = sourceTryStatement.getFinallyClause();
            if (sourceFinallyClause != null) {
                this.visitChildren((SourceElement)sourceFinallyClause);
            }
            this.skipChildren();
        }
    }

    protected void whenEnterThrowStatement(SourceThrowStatement sourceThrowStatement) {
        JavaType javaType;
        SourceExpression sourceExpression = sourceThrowStatement.getExpression();
        if (sourceExpression != null && (javaType = sourceExpression.getResolvedType()) != null && this.isSearchedType(javaType)) {
            this.highlight((SourceElement)sourceThrowStatement, "throws " + javaType.getQualifiedName());
        }
    }
}

