/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highliters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlighPlugin;
import oracle.jdevimpl.refactoring.highlight.highliters.DefaultHighlighter;

public class VariableHighlighter
extends DefaultHighlighter {
    private final String _searchedName;
    private final JavaHasName _searchedElement;
    private String _tooltip;

    public VariableHighlighter(HighlighPlugin highlighPlugin, JavaHasName javaHasName) {
        super(highlighPlugin);
        this._searchedName = javaHasName.getName();
        this._searchedElement = javaHasName;
        this._tooltip = MessageFormat.format(RefactoringArb.getString(351), this._searchedName);
    }

    private void whenVariableFound(SourceVariable sourceVariable) {
        String string = sourceVariable.getName();
        if (this._searchedName.equals(string) && this._searchedElement.equals(sourceVariable)) {
            SourceName sourceName = sourceVariable.getNameElement();
            this.highlight((SourceElement)sourceName, this._tooltip);
        }
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaHasType javaHasType;
        String string = sourceSimpleNameExpression.getName();
        if (this._searchedName.equals(string) && this._searchedElement.equals(javaHasType = sourceSimpleNameExpression.getResolvedObject())) {
            SourceName sourceName = sourceSimpleNameExpression.getNameElement();
            this.highlight((SourceElement)sourceName, this._tooltip);
        }
    }

    protected void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
        this.whenVariableFound((SourceVariable)sourceLocalVariable);
    }

    protected void whenEnterFormalParameter(SourceVariable sourceVariable) {
        this.whenVariableFound(sourceVariable);
    }

    protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
        this.whenVariableFound((SourceVariable)sourceFieldVariable);
    }
}

